/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.ReflectionUtilities;

public class InterpreterUtilities {
    public static final Byte ONE = new Byte(1);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static Object equalTo(Class lc, Class rc, Object l, Object r) {
        return InterpreterUtilities.equalityOperation(lc, rc, l, r, EqualToPredicate.INSTANCE);
    }

    public static Object notEqualTo(Class lc, Class rc, Object l, Object r) {
        return InterpreterUtilities.equalityOperation(lc, rc, l, r, NotEqualToPredicate.INSTANCE);
    }

    protected static Object equalityOperation(Class lc, Class rc, Object l, Object r, BinaryPredicate p) {
        if (lc != null && lc.isPrimitive() || rc != null && rc.isPrimitive()) {
            if (lc == Boolean.TYPE || rc == Boolean.TYPE) {
                return p.invoke((Boolean)l, (Boolean)r) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (lc == Character.TYPE) {
                l = new Integer(((Character)l).charValue());
            }
            if (rc == Character.TYPE) {
                r = new Integer(((Character)r).charValue());
            }
            return p.invoke(((Number)l).doubleValue(), ((Number)r).doubleValue()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return p.invoke(l, r) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object add(Class c, Object l, Object r) {
        if (c == (class$java$lang$String == null ? (class$java$lang$String = InterpreterUtilities.class$("java.lang.String")) : class$java$lang$String)) {
            return "" + l + r;
        }
        return InterpreterUtilities.binaryArithmeticOperation(c, l, r, AddOperation.INSTANCE);
    }

    public static Object subtract(Class c, Object l, Object r) {
        return InterpreterUtilities.binaryArithmeticOperation(c, l, r, SubtractOperation.INSTANCE);
    }

    public static Object multiply(Class c, Object l, Object r) {
        return InterpreterUtilities.binaryArithmeticOperation(c, l, r, MultiplyOperation.INSTANCE);
    }

    public static Object divide(Class c, Object l, Object r) {
        return InterpreterUtilities.binaryArithmeticOperation(c, l, r, DivideOperation.INSTANCE);
    }

    public static Object remainder(Class c, Object l, Object r) {
        return InterpreterUtilities.binaryArithmeticOperation(c, l, r, RemainderOperation.INSTANCE);
    }

    protected static Object binaryArithmeticOperation(Class c, Object l, Object r, BinaryArithmeticOperation o) {
        if (l instanceof Character) {
            l = new Integer(((Character)l).charValue());
        }
        if (r instanceof Character) {
            r = new Integer(((Character)r).charValue());
        }
        if (c == Integer.TYPE) {
            return new Integer(o.invoke(((Number)l).intValue(), ((Number)r).intValue()));
        }
        if (c == Long.TYPE) {
            return new Long(o.invoke(((Number)l).longValue(), ((Number)r).longValue()));
        }
        if (c == Float.TYPE) {
            return new Float(o.invoke(((Number)l).floatValue(), ((Number)r).floatValue()));
        }
        return new Double(o.invoke(((Number)l).doubleValue(), ((Number)r).doubleValue()));
    }

    public static Object lessThan(Object l, Object r) {
        return InterpreterUtilities.relationalOperation(l, r, LessThanOperation.INSTANCE);
    }

    public static Object lessOrEqual(Object l, Object r) {
        return InterpreterUtilities.relationalOperation(l, r, LessOrEqualOperation.INSTANCE);
    }

    public static Object greaterThan(Object l, Object r) {
        return InterpreterUtilities.relationalOperation(l, r, GreaterThanOperation.INSTANCE);
    }

    public static Object greaterOrEqual(Object l, Object r) {
        return InterpreterUtilities.relationalOperation(l, r, GreaterOrEqualOperation.INSTANCE);
    }

    protected static Object relationalOperation(Object l, Object r, RelationalOperation o) {
        if (l instanceof Character) {
            l = new Integer(((Character)l).charValue());
        }
        if (r instanceof Character) {
            r = new Integer(((Character)r).charValue());
        }
        return o.invoke(((Number)l).doubleValue(), ((Number)r).doubleValue()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object bitAnd(Class c, Object l, Object r) {
        return InterpreterUtilities.bitwiseOperation(c, l, r, BitAndOperation.INSTANCE);
    }

    public static Object xOr(Class c, Object l, Object r) {
        return InterpreterUtilities.bitwiseOperation(c, l, r, XOrOperation.INSTANCE);
    }

    public static Object bitOr(Class c, Object l, Object r) {
        return InterpreterUtilities.bitwiseOperation(c, l, r, BitOrOperation.INSTANCE);
    }

    protected static Object bitwiseOperation(Class c, Object l, Object r, BitwiseOperation o) {
        if (c == Boolean.TYPE) {
            return new Boolean(o.invoke((Boolean)l, (Boolean)r));
        }
        if (l instanceof Character) {
            l = new Integer(((Character)l).charValue());
        }
        if (r instanceof Character) {
            r = new Integer(((Character)r).charValue());
        }
        if (c == Integer.TYPE) {
            return new Integer(o.invoke(((Number)l).intValue(), ((Number)r).intValue()));
        }
        return new Long(o.invoke(((Number)l).longValue(), ((Number)r).longValue()));
    }

    public static Object shiftLeft(Class c, Object l, Object r) {
        return InterpreterUtilities.shiftOperation(c, l, r, ShiftLeftOperation.INSTANCE);
    }

    public static Object shiftRight(Class c, Object l, Object r) {
        return InterpreterUtilities.shiftOperation(c, l, r, ShiftRightOperation.INSTANCE);
    }

    public static Object unsignedShiftRight(Class c, Object l, Object r) {
        return InterpreterUtilities.shiftOperation(c, l, r, UnsignedShiftRightOperation.INSTANCE);
    }

    protected static Object shiftOperation(Class c, Object l, Object r, ShiftOperation o) {
        if (l instanceof Character) {
            l = new Integer(((Character)l).charValue());
        }
        if (r instanceof Character) {
            r = new Integer(((Character)r).charValue());
        }
        if (c == Integer.TYPE) {
            return new Integer(o.invoke(((Number)l).intValue(), ((Number)r).intValue()));
        }
        return new Long(o.invoke(((Number)l).longValue(), ((Number)r).intValue()));
    }

    public static Object plus(Class c, Object o) {
        return InterpreterUtilities.unaryOperation(c, o, PlusOperation.INSTANCE);
    }

    public static Object minus(Class c, Object o) {
        return InterpreterUtilities.unaryOperation(c, o, MinusOperation.INSTANCE);
    }

    public static Object unaryOperation(Class c, Object o, UnaryOperation u) {
        if (o instanceof Character) {
            o = new Integer(((Character)o).charValue());
        }
        if (c == Integer.TYPE) {
            return new Integer(u.invoke(((Number)o).intValue()));
        }
        if (c == Long.TYPE) {
            return new Long(u.invoke(((Number)o).longValue()));
        }
        if (c == Float.TYPE) {
            return new Float(u.invoke(((Number)o).floatValue()));
        }
        return new Double(u.invoke(((Number)o).doubleValue()));
    }

    public static Class getDeclaringClass(Class c) {
        Class result;
        block2: {
            result = c.getDeclaringClass();
            if (result != null) break block2;
            try {
                Field f = c.getField("declaring$Class$Reference$0");
                result = (Class)f.get(null);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static Field getOuterField(Class cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        boolean sc = Modifier.isStatic(cl.getModifiers());
        Class c = cl != null ? InterpreterUtilities.getDeclaringClass(cl) : null;
        while (c != null) {
            try {
                Field f = ReflectionUtilities.getField(c, name);
                if (!sc || Modifier.isStatic(f.getModifiers())) {
                    return f;
                }
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            sc |= Modifier.isStatic(c.getModifiers());
            c = InterpreterUtilities.getDeclaringClass(c);
        }
        throw new NoSuchFieldException(name);
    }

    public static Method lookupOuterMethod(Class cl, String name, Class[] ac) throws NoSuchMethodException {
        boolean sc = Modifier.isStatic(cl.getModifiers());
        Class c = cl != null ? InterpreterUtilities.getDeclaringClass(cl) : null;
        while (c != null) {
            try {
                Method m = ReflectionUtilities.lookupMethod(c, name, ac);
                if (!sc || Modifier.isStatic(m.getModifiers())) {
                    return m;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            sc |= Modifier.isStatic(c.getModifiers());
            c = InterpreterUtilities.getDeclaringClass(c);
        }
        throw new NoSuchMethodException(name);
    }

    public static boolean isValidAssignment(Class lc, Object val) {
        Class<?> rc;
        Class<?> clazz = rc = val == null ? null : val.getClass();
        if (lc != null) {
            if (lc.isPrimitive()) {
                if (lc == Boolean.TYPE && rc != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = InterpreterUtilities.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return false;
                }
                if (lc == Byte.TYPE && rc != (class$java$lang$Byte == null ? (class$java$lang$Byte = InterpreterUtilities.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    if (rc == (class$java$lang$Integer == null ? (class$java$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        Number n = (Number)val;
                        return n.intValue() == n.byteValue();
                    }
                    return false;
                }
                if ((lc == Short.TYPE || rc == (class$java$lang$Character == null ? (class$java$lang$Character = InterpreterUtilities.class$("java.lang.Character")) : class$java$lang$Character)) && rc != (class$java$lang$Byte == null ? (class$java$lang$Byte = InterpreterUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) && rc != (class$java$lang$Short == null ? (class$java$lang$Short = InterpreterUtilities.class$("java.lang.Short")) : class$java$lang$Short) && rc != (class$java$lang$Character == null ? (class$java$lang$Character = InterpreterUtilities.class$("java.lang.Character")) : class$java$lang$Character)) {
                    if (rc == (class$java$lang$Integer == null ? (class$java$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        Number n = (Number)val;
                        return n.intValue() == n.shortValue();
                    }
                    return false;
                }
                if (lc == Integer.TYPE && rc != (class$java$lang$Byte == null ? (class$java$lang$Byte = InterpreterUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) && rc != (class$java$lang$Short == null ? (class$java$lang$Short = InterpreterUtilities.class$("java.lang.Short")) : class$java$lang$Short) && rc != (class$java$lang$Character == null ? (class$java$lang$Character = InterpreterUtilities.class$("java.lang.Character")) : class$java$lang$Character) && rc != (class$java$lang$Integer == null ? (class$java$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return false;
                }
                if (lc == Long.TYPE && rc != (class$java$lang$Byte == null ? (class$java$lang$Byte = InterpreterUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) && rc != (class$java$lang$Short == null ? (class$java$lang$Short = InterpreterUtilities.class$("java.lang.Short")) : class$java$lang$Short) && rc != (class$java$lang$Character == null ? (class$java$lang$Character = InterpreterUtilities.class$("java.lang.Character")) : class$java$lang$Character) && rc != (class$java$lang$Integer == null ? (class$java$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")) : class$java$lang$Integer) && rc != (class$java$lang$Long == null ? (class$java$lang$Long = InterpreterUtilities.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return false;
                }
                if (lc == Float.TYPE && rc != (class$java$lang$Byte == null ? (class$java$lang$Byte = InterpreterUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) && rc != (class$java$lang$Short == null ? (class$java$lang$Short = InterpreterUtilities.class$("java.lang.Short")) : class$java$lang$Short) && rc != (class$java$lang$Character == null ? (class$java$lang$Character = InterpreterUtilities.class$("java.lang.Character")) : class$java$lang$Character) && rc != (class$java$lang$Integer == null ? (class$java$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")) : class$java$lang$Integer) && rc != (class$java$lang$Long == null ? (class$java$lang$Long = InterpreterUtilities.class$("java.lang.Long")) : class$java$lang$Long) && rc != (class$java$lang$Float == null ? (class$java$lang$Float = InterpreterUtilities.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return false;
                }
                if (lc == Double.TYPE && rc != (class$java$lang$Byte == null ? (class$java$lang$Byte = InterpreterUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) && rc != (class$java$lang$Short == null ? (class$java$lang$Short = InterpreterUtilities.class$("java.lang.Short")) : class$java$lang$Short) && rc != (class$java$lang$Character == null ? (class$java$lang$Character = InterpreterUtilities.class$("java.lang.Character")) : class$java$lang$Character) && rc != (class$java$lang$Integer == null ? (class$java$lang$Integer = InterpreterUtilities.class$("java.lang.Integer")) : class$java$lang$Integer) && rc != (class$java$lang$Long == null ? (class$java$lang$Long = InterpreterUtilities.class$("java.lang.Long")) : class$java$lang$Long) && rc != (class$java$lang$Float == null ? (class$java$lang$Float = InterpreterUtilities.class$("java.lang.Float")) : class$java$lang$Float) && rc != (class$java$lang$Double == null ? (class$java$lang$Double = InterpreterUtilities.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return false;
                }
            } else if (rc != null && !lc.isAssignableFrom(rc) && !rc.isAssignableFrom(lc)) {
                return false;
            }
        }
        return true;
    }

    protected InterpreterUtilities() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class MinusOperation
    extends UnaryOperation {
        static final MinusOperation INSTANCE = new MinusOperation();

        protected MinusOperation() {
        }

        int invoke(int o) {
            return -o;
        }

        long invoke(long o) {
            return -o;
        }

        float invoke(float o) {
            return -o;
        }

        double invoke(double o) {
            return -o;
        }
    }

    protected static class PlusOperation
    extends UnaryOperation {
        static final PlusOperation INSTANCE = new PlusOperation();

        protected PlusOperation() {
        }

        int invoke(int o) {
            return o;
        }

        long invoke(long o) {
            return o;
        }

        float invoke(float o) {
            return o;
        }

        double invoke(double o) {
            return o;
        }
    }

    protected static abstract class UnaryOperation {
        protected UnaryOperation() {
        }

        abstract int invoke(int var1);

        abstract long invoke(long var1);

        abstract float invoke(float var1);

        abstract double invoke(double var1);
    }

    protected static class UnsignedShiftRightOperation
    extends ShiftOperation {
        static final UnsignedShiftRightOperation INSTANCE = new UnsignedShiftRightOperation();

        protected UnsignedShiftRightOperation() {
        }

        int invoke(int l, int r) {
            return l >>> r;
        }

        long invoke(long l, int r) {
            return l >>> r;
        }
    }

    protected static class ShiftRightOperation
    extends ShiftOperation {
        static final ShiftRightOperation INSTANCE = new ShiftRightOperation();

        protected ShiftRightOperation() {
        }

        int invoke(int l, int r) {
            return l >> r;
        }

        long invoke(long l, int r) {
            return l >> r;
        }
    }

    protected static class ShiftLeftOperation
    extends ShiftOperation {
        static final ShiftLeftOperation INSTANCE = new ShiftLeftOperation();

        protected ShiftLeftOperation() {
        }

        int invoke(int l, int r) {
            return l << r;
        }

        long invoke(long l, int r) {
            return l << r;
        }
    }

    protected static abstract class ShiftOperation {
        protected ShiftOperation() {
        }

        abstract int invoke(int var1, int var2);

        abstract long invoke(long var1, int var3);
    }

    protected static class XOrOperation
    extends BitwiseOperation {
        static final XOrOperation INSTANCE = new XOrOperation();

        protected XOrOperation() {
        }

        boolean invoke(boolean l, boolean r) {
            return l ^ r;
        }

        int invoke(int l, int r) {
            return l ^ r;
        }

        long invoke(long l, long r) {
            return l ^ r;
        }
    }

    protected static class BitOrOperation
    extends BitwiseOperation {
        static final BitOrOperation INSTANCE = new BitOrOperation();

        protected BitOrOperation() {
        }

        boolean invoke(boolean l, boolean r) {
            return l | r;
        }

        int invoke(int l, int r) {
            return l | r;
        }

        long invoke(long l, long r) {
            return l | r;
        }
    }

    protected static class BitAndOperation
    extends BitwiseOperation {
        static final BitAndOperation INSTANCE = new BitAndOperation();

        protected BitAndOperation() {
        }

        boolean invoke(boolean l, boolean r) {
            return l & r;
        }

        int invoke(int l, int r) {
            return l & r;
        }

        long invoke(long l, long r) {
            return l & r;
        }
    }

    protected static abstract class BitwiseOperation {
        protected BitwiseOperation() {
        }

        abstract boolean invoke(boolean var1, boolean var2);

        abstract int invoke(int var1, int var2);

        abstract long invoke(long var1, long var3);
    }

    protected static class GreaterOrEqualOperation
    extends RelationalOperation {
        static final GreaterOrEqualOperation INSTANCE = new GreaterOrEqualOperation();

        protected GreaterOrEqualOperation() {
        }

        boolean invoke(double l, double r) {
            return l >= r;
        }
    }

    protected static class GreaterThanOperation
    extends RelationalOperation {
        static final GreaterThanOperation INSTANCE = new GreaterThanOperation();

        protected GreaterThanOperation() {
        }

        boolean invoke(double l, double r) {
            return l > r;
        }
    }

    protected static class LessOrEqualOperation
    extends RelationalOperation {
        static final LessOrEqualOperation INSTANCE = new LessOrEqualOperation();

        protected LessOrEqualOperation() {
        }

        boolean invoke(double l, double r) {
            return l <= r;
        }
    }

    protected static class LessThanOperation
    extends RelationalOperation {
        static final LessThanOperation INSTANCE = new LessThanOperation();

        protected LessThanOperation() {
        }

        boolean invoke(double l, double r) {
            return l < r;
        }
    }

    protected static abstract class RelationalOperation {
        protected RelationalOperation() {
        }

        abstract boolean invoke(double var1, double var3);
    }

    protected static class RemainderOperation
    extends BinaryArithmeticOperation {
        static final RemainderOperation INSTANCE = new RemainderOperation();

        protected RemainderOperation() {
        }

        int invoke(int l, int r) {
            return l % r;
        }

        long invoke(long l, long r) {
            return l % r;
        }

        float invoke(float l, float r) {
            return l % r;
        }

        double invoke(double l, double r) {
            return l % r;
        }
    }

    protected static class DivideOperation
    extends BinaryArithmeticOperation {
        static final DivideOperation INSTANCE = new DivideOperation();

        protected DivideOperation() {
        }

        int invoke(int l, int r) {
            return l / r;
        }

        long invoke(long l, long r) {
            return l / r;
        }

        float invoke(float l, float r) {
            return l / r;
        }

        double invoke(double l, double r) {
            return l / r;
        }
    }

    protected static class MultiplyOperation
    extends BinaryArithmeticOperation {
        static final MultiplyOperation INSTANCE = new MultiplyOperation();

        protected MultiplyOperation() {
        }

        int invoke(int l, int r) {
            return l * r;
        }

        long invoke(long l, long r) {
            return l * r;
        }

        float invoke(float l, float r) {
            return l * r;
        }

        double invoke(double l, double r) {
            return l * r;
        }
    }

    protected static class SubtractOperation
    extends BinaryArithmeticOperation {
        static final SubtractOperation INSTANCE = new SubtractOperation();

        protected SubtractOperation() {
        }

        int invoke(int l, int r) {
            return l - r;
        }

        long invoke(long l, long r) {
            return l - r;
        }

        float invoke(float l, float r) {
            return l - r;
        }

        double invoke(double l, double r) {
            return l - r;
        }
    }

    protected static class AddOperation
    extends BinaryArithmeticOperation {
        static final AddOperation INSTANCE = new AddOperation();

        protected AddOperation() {
        }

        int invoke(int l, int r) {
            return l + r;
        }

        long invoke(long l, long r) {
            return l + r;
        }

        float invoke(float l, float r) {
            return l + r;
        }

        double invoke(double l, double r) {
            return l + r;
        }
    }

    protected static abstract class BinaryArithmeticOperation {
        protected BinaryArithmeticOperation() {
        }

        abstract int invoke(int var1, int var2);

        abstract long invoke(long var1, long var3);

        abstract float invoke(float var1, float var2);

        abstract double invoke(double var1, double var3);
    }

    protected static class NotEqualToPredicate
    extends BinaryPredicate {
        static final NotEqualToPredicate INSTANCE = new NotEqualToPredicate();

        protected NotEqualToPredicate() {
        }

        boolean invoke(boolean l, boolean r) {
            return l != r;
        }

        boolean invoke(double l, double r) {
            return l != r;
        }

        boolean invoke(Object l, Object r) {
            return l != r;
        }
    }

    protected static class EqualToPredicate
    extends BinaryPredicate {
        static final EqualToPredicate INSTANCE = new EqualToPredicate();

        protected EqualToPredicate() {
        }

        boolean invoke(boolean l, boolean r) {
            return l == r;
        }

        boolean invoke(double l, double r) {
            return l == r;
        }

        boolean invoke(Object l, Object r) {
            return l == r;
        }
    }

    protected static abstract class BinaryPredicate {
        protected BinaryPredicate() {
        }

        abstract boolean invoke(boolean var1, boolean var2);

        abstract boolean invoke(double var1, double var3);

        abstract boolean invoke(Object var1, Object var2);
    }
}

