/*
 * Decompiled with CFR 0.152.
 */
package base;

import java.io.IOException;
import java.io.Reader;

public class EscapeReader
extends Reader {
    static final String alnum = "0123456789abcdef";
    char[] buffer = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', 'u'};
    int offset = 0;
    Reader isr;

    public void close() throws IOException {
        this.isr.close();
    }

    public EscapeReader(Reader r) {
        this.isr = r;
    }

    public boolean ready() throws IOException {
        return this.offset != 0 || this.isr.ready();
    }

    public int read() throws IOException {
        if (this.offset != 0) {
            return this.buffer[--this.offset];
        }
        int c = this.isr.read();
        if (c < 127) {
            return c;
        }
        this.buffer[0] = alnum.charAt(c & 0xF);
        this.buffer[1] = alnum.charAt(c >> 4 & 0xF);
        this.buffer[2] = alnum.charAt(c >> 8 & 0xF);
        this.buffer[3] = alnum.charAt(c >> 12 & 0xF);
        this.offset = 5;
        return 92;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i != 0 ? i : c;
            }
            cbuf[off++] = (char)c;
        }
        return len;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public long skip(long len) throws IOException {
        int i = 0;
        while ((long)i < len) {
            if (this.read() == -1) {
                return i != 0 ? (long)i : -1L;
            }
            ++i;
        }
        return len;
    }
}

