/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.SelectorItem;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class SelectorRun
implements Runnable {
    public static Logger logger = Logger.getLogger("base.selectorrun");
    Selector selector = Selector.open();

    public void setCheckThreadInfo() {
    }

    public synchronized void MyWait(long t) {
        try {
            this.wait(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void MyNotify() {
        this.notify();
    }

    public Throwable check() {
        try {
            if (this.selector.keys().isEmpty()) {
                this.MyWait(1000L);
            } else {
                this.selector.select(900L);
                SwingUtilities.invokeAndWait(this);
            }
        }
        catch (InterruptedException e) {
        }
        catch (NullPointerException e) {
        }
        catch (InvocationTargetException e) {
            return e.getCause();
        }
        catch (Throwable e) {
            return e;
        }
        return null;
    }

    public SelectionKey register(SelectorItem item, SelectableChannel channel) throws IOException, ClosedChannelException {
        SelectionKey key = channel.register(this.selector.wakeup(), channel.validOps(), item);
        return key;
    }

    public void wakeup() {
        this.selector.wakeup();
        if (this.selector.keys().isEmpty()) {
            this.MyNotify();
        }
    }

    public void timer() {
        this.selector.wakeup();
        this.run();
        Iterator<SelectionKey> it = this.selector.keys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            SelectorItem item = (SelectorItem)key.attachment();
            SelectableChannel channel = key.channel();
            try {
                if (channel == null) continue;
                item.onTimer(channel);
            }
            catch (CancelledKeyException e) {
            }
            catch (ConcurrentModificationException e) {
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "timer", e);
            }
        }
    }

    public void run() {
        try {
            this.selector.selectNow();
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                SelectorItem item = (SelectorItem)key.attachment();
                SelectableChannel channel = key.channel();
                try {
                    if (key.isAcceptable() && item.onAcceptable(channel)) {
                        it.remove();
                        continue;
                    }
                    if (key.isConnectable() && item.onConnectable(channel)) {
                        it.remove();
                        continue;
                    }
                    if (key.isReadable() && item.onReadable(channel)) {
                        it.remove();
                        continue;
                    }
                    if (!key.isWritable() || !item.onWritable(channel)) continue;
                    it.remove();
                }
                catch (CancelledKeyException e) {
                }
                catch (ConcurrentModificationException e) {
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "run", e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "run(2)", e);
        }
    }

    public boolean closeAll() {
        this.wakeup();
        this.run();
        if (this.selector.keys().isEmpty()) {
            logger.fine("all selector keys are closed.");
            return true;
        }
        Iterator<SelectionKey> it = this.selector.keys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            SelectorItem item = (SelectorItem)key.attachment();
            SelectableChannel channel = key.channel();
            try {
                if (channel == null) continue;
                logger.fine("wait for " + item.getClass().getName() + " " + (channel instanceof SocketChannel ? ((SocketChannel)channel).socket().getRemoteSocketAddress().toString() : ""));
                item.onSelectorExit(channel);
                item.onTimer(channel);
            }
            catch (NullPointerException e) {
            }
            catch (CancelledKeyException e) {
            }
            catch (ConcurrentModificationException e) {
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "closeAll", e);
            }
        }
        return false;
    }

    static {
        logger.setLevel(null);
    }
}

