/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.ConnTreeNode;
import buffer.LogDocument;
import buffer.LogView;
import buffer.TextSpanInfo;
import irc.IRCChannelMember;
import irc.IRCConnection;
import irc.IRCUser;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.JMenuItem;

public class ActionUtility {
    public static String getStringParamater() {
        Object o = App.action_manager.getStackParameter();
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static String StringToArg(String src, int index) {
        if (src != null) {
            int i = 0;
            while (true) {
                if (i < src.length() && " \t\n".indexOf(src.charAt(i)) != -1) {
                    ++i;
                    continue;
                }
                int start = i;
                while (i < src.length() && " \t\n".indexOf(src.charAt(i)) == -1) {
                    ++i;
                }
                if (i > start && index == 0) {
                    return src.substring(start, i);
                }
                --index;
            }
        }
        return null;
    }

    public static CTN_Conn createConn(String name) {
        CTN_Conn r = new CTN_Conn(App.getApp(), name);
        return r;
    }

    public static void setUsersMode(String modeStr) {
        LinkedList users = App.main_window.user_view.getSelectedMulti();
        if (users != null) {
            CTN_Chan ctn = App.main_window.user_view.getChannelNode();
            IRCConnection conn = ctn.getConnNode().conn;
            while (0 != users.size()) {
                LinkedList<Object> v = new LinkedList<Object>();
                while (0 != users.size() && v.size() < 3) {
                    IRCChannelMember member = (IRCChannelMember)users.removeFirst();
                    IRCUser user = member.getUser();
                    if (user == conn.myself) continue;
                    v.add(user.getNickBytes());
                }
                if (v.size() == 0) continue;
                v.addFirst(modeStr.substring(0, v.size() + 1));
                v.addFirst(ctn.chan.getRawBytes());
                v.addFirst("MODE");
                conn.SendToServer(v);
            }
        }
    }

    public static String readHoverOrSelected(ActionEvent e) {
        TextSpanInfo info = ActionUtility.getLastHover(e);
        Object o = e.getSource();
        if (!(o instanceof JMenuItem)) {
            return null;
        }
        o = App.getFocusComponent();
        if (!(o instanceof LogView)) {
            return null;
        }
        LogView view = (LogView)o;
        LogDocument doc = view.getDocument();
        if (doc == null) {
            return null;
        }
        doc.getLastHover();
        if (info == null) {
            App.Log("readHoverOrSelected: getLastHover is null");
            return null;
        }
        return info.text;
    }

    public static TextSpanInfo getLastHover(ActionEvent e) {
        Object o = e.getSource();
        if (!(o instanceof JMenuItem)) {
            App.Log("getLastHover: \u30e1\u30cb\u30e5\u30fc\u304b\u3089\u547c\u3070\u308c\u305f\u306e\u3067\u306f\u306a\u3044\uff1f");
            return null;
        }
        o = App.getFocusComponent();
        if (!(o instanceof LogView)) {
            App.Log("getLastHover: FocusComponent is not LogView");
            return null;
        }
        LogView view = (LogView)o;
        LogDocument doc = view.getDocument();
        if (doc == null) {
            App.Log("getLastHover: getDocument is null");
            return null;
        }
        TextSpanInfo info = doc.getLastHover();
        if (info == null) {
            App.Log("getLastHover: doc.getLastHover is null");
            return null;
        }
        return info;
    }

    public static ConnTreeNode getContextNode(TextSpanInfo info) {
        if (info != null && info.main_context != null && info.main_context instanceof ConnTreeNode) {
            return (ConnTreeNode)info.main_context;
        }
        Object o = App.getFocusComponent();
        if (o instanceof LogView && o == App.log_all.log_view) {
            return null;
        }
        return App.getSelected();
    }

    public static CTN_Conn getConnectionNode(TextSpanInfo info) {
        ConnTreeNode node = ActionUtility.getContextNode(info);
        return node == null ? null : node.getConnNode();
    }

    public static CTN_Chan getChannelNode(TextSpanInfo info) {
        ConnTreeNode node = ActionUtility.getContextNode(info);
        return node == null ? null : node.getChannelNode();
    }
}

