/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import bluntirc.App;
import bluntirc.BufferListTransferHandler;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.CTN_Priv;
import bluntirc.ConnTreeNode;
import gui.FontInfo;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class BufferList
extends JComponent
implements Scrollable,
Transferable {
    private static Logger logger = Logger.getLogger("bluntirc.bufferlist");
    protected int line_height = 16;
    static DataFlavor[] my_DataFlavor;
    public LinkedList list = new LinkedList();
    protected int selected = -1;
    int drug_from = -1;
    int drug_to;
    FontInfo fiL1;
    FontInfo fiL2;
    FontInfo fiNum;
    FontMetrics fmL1;
    FontMetrics fmL2;
    FontMetrics fmNum;
    int number_width;
    int font_offset;
    int icon_offset;
    static /* synthetic */ Class class$bluntirc$BufferList;

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (orientation == 0 ? visibleRect.width : visibleRect.height) - this.line_height;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.line_height;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return my_DataFlavor;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < my_DataFlavor.length; ++i) {
            if (!my_DataFlavor[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (my_DataFlavor[0].equals(flavor)) {
            return new Integer(this.getSelectedIndex());
        }
        return this.getSelected().getListLabel1();
    }

    public boolean canDrop(DataFlavor flavor) {
        return my_DataFlavor[0].equals(flavor);
    }

    public void exportDone() {
        this.drug_from = -1;
        this.repaint(300L);
    }

    void check_drop(DropTargetDragEvent e) {
        System.out.println("check_drop");
        boolean flag = false;
        if (e != null) {
            DataFlavor[] list = e.getCurrentDataFlavors();
            for (int i = 0; i < list.length; ++i) {
                if (!this.canDrop(list[i])) continue;
                flag = true;
                break;
            }
        }
        if (e == null || !flag) {
            this.drug_to = -1;
            this.repaint(300L);
            return;
        }
        Point p = this.getLocation();
        this.drug_to = this.pointItemAt(p, true);
        this.repaint(300L);
    }

    public int getCount() {
        return this.list.size();
    }

    public ConnTreeNode getItem(int index) {
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return (ConnTreeNode)this.list.get(index);
    }

    public void addItem(ConnTreeNode item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.list.addLast(item);
        this.notifySizeChange();
    }

    public void addItem(ConnTreeNode item, ConnTreeNode parent, boolean select) {
        this.addItem(item, this.list.indexOf(parent) + 1, select);
    }

    public void addItem(ConnTreeNode item, int index, boolean selectNewNode) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.list.add(index, item);
        if (selectNewNode) {
            this.select(index);
        } else if (this.selected >= index) {
            this.select(this.selected + 1);
        }
        this.notifySizeChange();
    }

    public void removeItem(int index) {
        if (index < 0 || index >= this.list.size()) {
            return;
        }
        int old_selected = this.selected;
        this.selected = -1;
        this.list.remove(index);
        if (old_selected == index) {
            this.select(index == this.list.size() ? index - 1 : index);
        } else if (old_selected > index) {
            this.select(old_selected - 1);
        }
        this.notifySizeChange();
    }

    public void removeItem(ConnTreeNode item) {
        this.removeItem(this.list.indexOf(item));
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public ConnTreeNode getSelected() {
        return this.getItem(this.selected);
    }

    public void select(ConnTreeNode node) {
        this.select(this.list.indexOf(node));
    }

    public void select(int index) {
        if (this.selected == index || index < 0 || index >= this.list.size()) {
            return;
        }
        this.selected = index;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BufferList.this.sub_scrollRectToVisible();
            }
        });
        ConnTreeNode item = this.getItem(this.selected);
        if (item != null) {
            item.OnSelect();
        }
        App.getApp().updateTopic();
        this.repaint(300L);
    }

    public void StepScroll(int i, boolean loop) {
        int count = App.buf_list.getCount();
        int now = App.buf_list.getSelectedIndex();
        int n = i = now < 0 ? 0 : now + i;
        if (!loop) {
            this.select(i < 0 ? 0 : (i >= count ? count - 1 : i));
            return;
        }
        while (i < 0) {
            i += count;
        }
        this.select(i % count);
    }

    public void sub_scrollRectToVisible() {
        if (this.selected >= 0) {
            this.scrollRectToVisible(new Rectangle(0, this.line_height * this.selected, 1, this.line_height));
        }
    }

    public CTN_Conn getConn() {
        ConnTreeNode c = this.getSelected();
        return c == null ? null : c.getConnNode();
    }

    public CTN_Chan getChannel() {
        ConnTreeNode c = this.getSelected();
        return c == null ? null : c.getChannelNode();
    }

    public CTN_Priv getPrivNode() {
        ConnTreeNode c = this.getSelected();
        return c == null ? null : c.getPrivNode();
    }

    public void redrawItem(ConnTreeNode item) {
        this.repaint(300L, 0, this.line_height * this.list.indexOf(item), this.getWidth(), this.line_height);
    }

    public void notifySizeChange() {
        this.repaint(300L);
        this.invalidate();
        this.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BufferList.this.sub_scrollRectToVisible();
            }
        });
    }

    public void sortItem() {
        if (this.list.size() <= 1) {
            return;
        }
        this.select(1);
        ConnTreeNode.sort_type = 0;
        Collections.sort(this.list);
        this.select(0);
        this.repaint(300L);
    }

    public void sortByOrder() {
        if (this.list.size() <= 1) {
            return;
        }
        this.select(1);
        ConnTreeNode.sort_type = 1;
        Collections.sort(this.list);
        this.select(0);
        this.repaint(300L);
    }

    void saveOrder() {
        int i = 0;
        ListIterator it = this.list.listIterator(0);
        while (it.hasNext()) {
            ConnTreeNode item = (ConnTreeNode)it.next();
            item.property.setInt("order_in_list", ++i);
        }
    }

    public void changeOrder(int from, int to) {
        if (from == to || from < 0 || from >= this.list.size() || to < 0 || to >= this.list.size()) {
            return;
        }
        this.list.add(to, this.list.remove(from));
        if (this.selected == from) {
            this.selected = to;
        }
        this.repaint(300L);
    }

    public BufferList() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                BufferList.this.drug_from = -1;
                int index = BufferList.this.pointItemAt(e, false);
                if (index != -1) {
                    BufferList.this.select(index);
                    ConnTreeNode item = (ConnTreeNode)BufferList.this.list.get(index);
                    item.onClick(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                int index;
                if (e.isPopupTrigger() && (index = BufferList.this.pointItemAt(e, false)) != -1) {
                    BufferList.this.select(index);
                    ConnTreeNode item = (ConnTreeNode)BufferList.this.list.get(index);
                    App.menu_conf.showPopupMenu(e, item.getPopupName());
                }
                BufferList.this.drug_from = BufferList.this.pointItemAt(e, false);
                if (BufferList.this.drug_from != -1) {
                    BufferList.this.select(BufferList.this.drug_from);
                    BufferList.this.drug_to = -2;
                }
            }

            public void mouseReleased(MouseEvent e) {
                int index;
                if (e.isPopupTrigger() && (index = BufferList.this.pointItemAt(e, false)) != -1) {
                    BufferList.this.select(index);
                    ConnTreeNode item = (ConnTreeNode)BufferList.this.list.get(index);
                    String menu = item.getPopupName();
                    App.menu_conf.showPopupMenu(e, menu);
                }
                if (BufferList.this.drug_from != -1) {
                    BufferList.this.changeOrder(BufferList.this.drug_from, BufferList.this.drug_to);
                    BufferList.this.drug_from = -1;
                    BufferList.this.setCursor(Cursor.getPredefinedCursor(0));
                    BufferList.this.repaint(300L);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (BufferList.this.drug_from != -1) {
                    BufferList.this.drug_to = BufferList.this.pointItemAt(e, true);
                    BufferList.this.repaint(300L);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: 
                    case 224: {
                        BufferList.this.StepScroll(-1, true);
                        return;
                    }
                    case 40: 
                    case 225: {
                        BufferList.this.StepScroll(1, true);
                        return;
                    }
                    case 33: {
                        BufferList.this.StepScroll(-BufferList.this.getHeight() / BufferList.this.line_height, false);
                        return;
                    }
                    case 34: {
                        BufferList.this.StepScroll(BufferList.this.getHeight() / BufferList.this.line_height, false);
                        return;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.setTransferHandler(new BufferListTransferHandler(this));
    }

    void setFontInfo(FontInfo fiL1, FontInfo fiL2, FontInfo fiNum) {
        this.fiL1 = fiL1;
        this.fiL2 = fiL2;
        this.fiNum = fiNum;
        this.notifySizeChange();
    }

    public Dimension getPreferredSize() {
        if (this.fiL1 == null) {
            return new Dimension(10, 10);
        }
        this.fmL1 = this.getFontMetrics(this.fiL1.font);
        this.fmL2 = this.getFontMetrics(this.fiL2.font);
        this.fmNum = this.getFontMetrics(this.fiNum.font);
        int ascent = 0;
        int descent = 0;
        int leading = 0;
        FontMetrics[] fm_list = new FontMetrics[]{this.fmL1, this.fmL2, this.fmNum};
        for (int i = 0; i < fm_list.length; ++i) {
            if (ascent < fm_list[i].getAscent()) {
                ascent = fm_list[i].getAscent();
            }
            if (descent < fm_list[i].getDescent()) {
                descent = fm_list[i].getDescent();
            }
            if (leading >= fm_list[i].getLeading()) continue;
            leading = fm_list[i].getLeading();
        }
        int icon_max_height = 0;
        ListIterator it = this.list.listIterator(0);
        while (it.hasNext()) {
            int h;
            ConnTreeNode item = (ConnTreeNode)it.next();
            ImageIcon icon = item.getImageIcon();
            if (icon == null || icon_max_height >= (h = icon.getIconHeight())) continue;
            icon_max_height = h;
        }
        if (ascent + descent + leading < icon_max_height) {
            leading += (icon_max_height - (ascent + descent + leading)) / 2;
            descent = icon_max_height - (ascent + leading);
        }
        this.line_height = ascent + descent + leading;
        this.font_offset = ascent + leading;
        this.icon_offset = ascent + leading - icon_max_height;
        this.number_width = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            int w = this.fmNum.stringWidth(Integer.toString(i));
            if (this.number_width >= w) continue;
            this.number_width = w;
        }
        int xmax = 0;
        ListIterator it2 = this.list.listIterator(0);
        while (it2.hasNext()) {
            int w;
            ConnTreeNode item = (ConnTreeNode)it2.next();
            int x = 0;
            ImageIcon icon = item.getImageIcon();
            if (icon != null && (w = icon.getIconWidth()) > 0) {
                x += w + w / 4 * item.getListOffset();
            }
            if (xmax >= (x += 2 + this.fmL1.stringWidth(item.getListLabel1()) + 4 + this.fmL2.stringWidth(item.getListLabel2()) + 4)) continue;
            xmax = x;
        }
        return new Dimension(this.number_width + 1 + xmax, this.line_height * this.list.size() + 1);
    }

    public void paint(Graphics g) {
        int y;
        ConnTreeNode item;
        Rectangle r = g.getClipBounds();
        int view_end = this.getWidth();
        if (view_end > r.x + r.width) {
            view_end = r.x + r.width;
        }
        if (this.fiL1.bg != null) {
            g.setColor(this.fiL1.bg);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        g.setColor(this.fiNum.fg);
        g.setFont(this.fiNum.font);
        int i = 0;
        ListIterator it = this.list.listIterator(0);
        while (it.hasNext()) {
            item = (ConnTreeNode)it.next();
            y = i * this.line_height;
            if (y >= r.y + r.height) break;
            if (y + this.line_height > r.y) {
                String s = Integer.toString(i);
                g.drawString(s, this.number_width - this.fmNum.stringWidth(s), y + this.font_offset);
            }
            ++i;
        }
        i = 0;
        it = this.list.listIterator(0);
        while (it.hasNext()) {
            item = (ConnTreeNode)it.next();
            y = i * this.line_height;
            if (y >= r.y + r.height) break;
            if (y + this.line_height > r.y) {
                int w;
                ImageIcon icon = item.getImageIcon();
                int x = this.number_width + 1;
                int xstart = this.number_width + 1;
                Image image = null;
                if (icon != null && (w = icon.getIconWidth()) > 0) {
                    xstart = x += w / 4 * item.getListOffset();
                    x += w;
                    image = icon.getImage();
                }
                x += 2;
                w = this.fmL1.stringWidth(item.getListLabel1());
                g.setFont(this.fiL1.font);
                if (this.selected == i) {
                    g.setColor(this.fiL1.bg2);
                    g.fillRect(xstart - 1, y, x + w + 2 - xstart, this.line_height);
                    g.setColor(this.fiL1.fg2);
                } else {
                    g.setColor(this.fiL1.fg);
                }
                g.drawString(item.getListLabel1(), x, y + this.font_offset);
                if (this.drug_from == i && this.drug_to != -2) {
                    g.setColor(this.fiL2.bg);
                    g.drawRect(xstart - 1, y, x + w + 2 - xstart, this.line_height);
                }
                if (image != null) {
                    g.drawImage(image, xstart, y, this);
                }
                x += w;
                w = this.fmL2.stringWidth(item.getListLabel2());
                if (view_end - (x += 4) > w) {
                    x = view_end - w;
                }
                g.setFont(this.fiL2.font);
                g.setColor(this.fiL2.fg);
                g.drawString(item.getListLabel2(), x, y + this.font_offset);
            }
            ++i;
        }
        if (this.drug_from != -1 && this.drug_to >= 0 && this.drug_from != this.drug_to) {
            int line_pos = this.drug_to;
            if (this.drug_to > this.drug_from) {
                ++line_pos;
            }
            int y2 = line_pos * this.line_height;
            g.setColor(this.fiL2.bg);
            g.fillRect(0, y2 - 1, view_end, 2);
        }
    }

    int pointItemAt(MouseEvent e, boolean moveto) {
        return this.pointItemAt(new Point(e.getX(), e.getY()), moveto);
    }

    int pointItemAt(Point e, boolean moveto) {
        int w;
        int x;
        int index = e.y / this.line_height;
        if (index < 0) {
            return moveto ? 0 : -1;
        }
        if (index >= this.list.size()) {
            return moveto ? this.list.size() - 1 : -1;
        }
        if (moveto) {
            return index;
        }
        ConnTreeNode item = (ConnTreeNode)this.list.get(index);
        int xstart = x = this.number_width + 1;
        ImageIcon icon = item.getImageIcon();
        if (icon != null && (w = icon.getIconWidth()) > 0) {
            xstart = x += w / 4 * item.getListOffset();
            x += w;
        }
        x += 2;
        w = this.fmL1.stringWidth(item.getListLabel1());
        x += w;
        if (e.x >= xstart && e.getX() < (double)x) {
            return index;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger.setLevel(null);
        my_DataFlavor = new DataFlavor[]{new DataFlavor(class$bluntirc$BufferList == null ? (class$bluntirc$BufferList = BufferList.class$("bluntirc.BufferList")) : class$bluntirc$BufferList, "\u30d0\u30c3\u30d5\u30a1\u9805\u76ee"), DataFlavor.getTextPlainUnicodeFlavor()};
    }
}

