/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import bluntirc.App;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class DelayLog {
    private HashMap map = new HashMap();
    private long last_cleanup = 0L;
    private static final long SweepInterval = 3600000L;

    public void add(File f, byte[] data) {
        long now = System.currentTimeMillis();
        PerFile pf = (PerFile)this.map.get(f);
        if (pf == null) {
            pf = new PerFile();
            this.map.put(f, pf);
        }
        if (pf.lines.size() == 0) {
            pf.last_used = now;
        }
        pf.lines.addLast(data);
        if (pf.lines.size() > App.root_property.setDefaultInt("DelayLog/MaxLine", 100)) {
            this.flush(f, pf, now);
        }
        if (now - this.last_cleanup >= 3600000L) {
            this.last_cleanup = now;
            this.sweep(now);
        }
    }

    void sweep(long now) {
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            File key = (File)me.getKey();
            PerFile pf = (PerFile)me.getValue();
            if (pf.lines.size() != 0 || now - pf.last_used < 3600000L) continue;
            it.remove();
        }
    }

    public void onTimer() {
        long now = System.currentTimeMillis();
        long max_time = App.root_property.setDefaultInt("DelayLog/MaxTime", 60000);
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            File key = (File)me.getKey();
            PerFile pf = (PerFile)me.getValue();
            if (pf.lines.size() == 0 || now - pf.last_used <= max_time) continue;
            this.flush(key, pf, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(File f, PerFile pf, long now) {
        try {
            FileOutputStream fos = new FileOutputStream(f, true);
            try {
                Iterator it = pf.lines.iterator();
                while (it.hasNext()) {
                    fos.write((byte[])it.next());
                }
            }
            finally {
                fos.close();
            }
        }
        catch (SecurityException e) {
            App.Log(f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306f\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3\u306b\u3088\u3063\u3066\u62d2\u5426\u3055\u308c\u305f\u3002" + e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            App.Log("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u6307\u5b9a\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u540d" + f.getAbsolutePath() + "\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u306a\u3044\u3002" + e.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException e) {
            App.Log("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb" + f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306b\u6307\u5b9a\u3057\u305f\u6587\u5b57\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0" + App.root_property.getString("LogFileEncoding") + "\u306f\u3053\u306e\u30b7\u30b9\u30c6\u30e0\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u3002" + e.getLocalizedMessage());
        }
        catch (IOException e) {
            App.Log("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb" + f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306f\u5931\u6557\u3057\u305f\u3002" + e.getLocalizedMessage());
        }
        catch (Throwable e) {
            App.Log("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb" + f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306f\u5931\u6557\u3057\u305f\u3002" + e.getLocalizedMessage());
        }
        finally {
            pf.lines.clear();
            pf.last_used = now;
        }
    }

    public void flushAll() {
        long now = System.currentTimeMillis();
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            File key = (File)me.getKey();
            PerFile pf = (PerFile)me.getValue();
            this.flush(key, pf, now);
        }
    }

    static class PerFile {
        long last_used;
        LinkedList lines = new LinkedList();

        PerFile() {
        }
    }

    static class PerLine {
        long add_time;
        byte[] line;

        PerLine() {
        }
    }
}

