/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.Util;
import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.ConnTreeNode;
import gui.MyScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputAreaWrap {
    public JTextArea InputArea = new JTextArea();
    JScrollPane InputAreaScroller = new MyScrollPane(this.InputArea, App.root_property.setDefaultBoolean("TransparentScrollBarUI", false));
    JCheckBox cbMultiLine = new JCheckBox();
    Box InputOptionPanel = Box.createHorizontalBox();
    JPanel RightBottomPanel = new JPanel();
    LinkedList rireki = new LinkedList();
    int rireki_lastShow = -1;
    int rireki_max = 20;
    boolean up_pressed;
    boolean down_pressed;

    public JPanel getComponent() {
        return this.RightBottomPanel;
    }

    public void initInputArea() {
        this.InputArea = new JTextArea(){

            public Dimension getPreferredSize() {
                Dimension r = super.getPreferredSize();
                r.width += 100;
                return r;
            }
        };
        this.InputArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                InputAreaWrap.this.checkTreePopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                InputAreaWrap.this.checkTreePopup(e);
            }
        });
        this.InputArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (InputAreaWrap.this.InputArea.getText().indexOf(10) != -1) {
                    InputAreaWrap.this.cbMultiLine.setSelected(true);
                }
            }
        });
        this.InputArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                InputAreaWrap.this.CheckModifiler(e, true);
            }

            public void keyReleased(KeyEvent e) {
                InputAreaWrap.this.CheckModifiler(e, false);
            }
        });
        this.InputArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                InputAreaWrap.this.updateInputAreaScroller();
            }

            public void insertUpdate(DocumentEvent e) {
                InputAreaWrap.this.updateInputAreaScroller();
            }

            public void removeUpdate(DocumentEvent e) {
                InputAreaWrap.this.updateInputAreaScroller();
            }
        });
        this.InputAreaScroller = new MyScrollPane(this.InputArea, App.root_property.setDefaultBoolean("TransparentScrollBarUI", false));
        this.InputArea.setMinimumSize(new Dimension(100, 40));
        this.InputAreaScroller.setMinimumSize(new Dimension(100, 40));
        this.InputArea.setOpaque(false);
        this.InputAreaScroller.setOpaque(false);
        this.InputAreaScroller.getViewport().setOpaque(false);
        this.RightBottomPanel.add((Component)this.InputAreaScroller, "Center");
    }

    public InputAreaWrap() {
        Insets insets = new Insets(0, 0, 0, 0);
        this.cbMultiLine.setOpaque(false);
        this.cbMultiLine.setText("\u8907\u6570\u884c");
        this.cbMultiLine.setRequestFocusEnabled(false);
        this.cbMultiLine.setVerifyInputWhenFocusTarget(false);
        this.cbMultiLine.setMargin(insets);
        this.RightBottomPanel.setLayout(new BorderLayout());
        JComponent[] options = new JComponent[]{this.cbMultiLine, App.main_window.btnTalk, App.main_window.btnNotice, App.main_window.btnAction, App.main_window.btnTopic2, App.main_window.btnSendAll, null, App.main_window.labelBufferInfo, App.main_window.btnURL};
        Box b = Box.createHorizontalBox();
        App.main_window.labelBufferInfo.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        for (int i = 0; i < options.length; ++i) {
            if (options[i] == null) {
                b.add(Box.createHorizontalGlue());
                continue;
            }
            if (i > 0 && options[i - 1] != null) {
                b.add(Box.createHorizontalStrut(2));
            }
            if (options[i] instanceof AbstractButton) {
                ((AbstractButton)options[i]).setMargin(insets);
            }
            b.add(options[i]);
        }
        b.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.InputOptionPanel.add(b);
        this.InputOptionPanel.setOpaque(false);
        this.InputOptionPanel.setBorder(new LineBorder(Color.black));
        this.RightBottomPanel.add((Component)this.InputOptionPanel, "North");
        this.RightBottomPanel.setOpaque(false);
        this.initInputArea();
    }

    public void reloadFontInfo() {
        this.updateInputAreaScroller();
    }

    public void updateInputAreaScroller() {
        Font font = App.style_manager.findFontInfo((String)"InputArea").font;
        this.InputArea.setFont(font);
        this.InputArea.revalidate();
        this.cbMultiLine.setOpaque(false);
        App.main_window.labelBufferInfo.setBorder(null);
        Dimension rv = this.RightBottomPanel.getParent().getSize();
        rv.height -= this.InputOptionPanel.getHeight() + 32;
        this.InputAreaScroller.setMaximumSize(rv);
        int min_height = this.InputAreaScroller.getHorizontalScrollBar().getHeight();
        if (min_height < 16) {
            min_height = 16;
        }
        min_height += this.InputArea.getFontMetrics(font).getHeight();
        Dimension ps = this.InputArea.getPreferredSize();
        if (ps.height > rv.height) {
            ps.height = rv.height;
        }
        if (ps.height < min_height) {
            ps.height = min_height;
        }
        this.InputAreaScroller.setPreferredSize(ps);
        this.RightBottomPanel.getParent().validate();
        this.InputAreaScroller.repaint(10L);
    }

    private void checkTreePopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        App.menu_conf.showPopupMenu(e, "popup-inputarea");
    }

    public void initListeners() {
    }

    void rireki_Append(String s) {
        this.rireki.addFirst(s);
        if (this.rireki.size() > this.rireki_max) {
            this.rireki.removeLast();
        }
        this.rireki_lastShow = -1;
    }

    String rireki_prev() {
        if (this.rireki.size() == 0) {
            return null;
        }
        ++this.rireki_lastShow;
        if (this.rireki_lastShow >= this.rireki.size()) {
            this.rireki_lastShow = 0;
        }
        return (String)this.rireki.get(this.rireki_lastShow);
    }

    String rireki_next() {
        if (this.rireki.size() == 0) {
            return null;
        }
        --this.rireki_lastShow;
        if (this.rireki_lastShow < 0) {
            this.rireki_lastShow = this.rireki.size() - 1;
        }
        return (String)this.rireki.get(this.rireki_lastShow);
    }

    public void OnMenuTalk() {
        this.SendMessage(0);
    }

    public void OnMenuTopic() {
        this.SendMessage(1);
    }

    public void OnMenuNotice() {
        this.SendMessage(2);
    }

    public void OnMenuAction() {
        this.SendMessage(3);
    }

    public void OnMenuSendAll() {
        this.SendMessage(4);
    }

    void SendMessage(int type) {
        String a = this.InputArea.getText();
        if (a.length() == 0) {
            return;
        }
        if (InputAreaWrap.SendMessage(a = Util.fromJIS(Util.toJIS(a)), type)) {
            this.rireki_Append(a);
            this.InputArea.setText("");
            this.cbMultiLine.setSelected(false);
        }
    }

    public static boolean SendMessage(String a, int type) {
        if (a == null || a.length() == 0) {
            return false;
        }
        if (type == 4) {
            CTN_Conn connNode = App.getSelectedConn();
            if (connNode != null) {
                LinkedList l = connNode.getChannelNodes();
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    CTN_Chan c = (CTN_Chan)it.next();
                    if (!c.chan.isInMyself()) continue;
                    c.SendFromUserInput(a, 0);
                }
            }
            return true;
        }
        ConnTreeNode c = App.getSelected();
        if (c == null) {
            return false;
        }
        return c.SendFromUserInput(a, type);
    }

    private void CheckModifiler(KeyEvent e, boolean IsPressed) {
        if (e.getKeyCode() == 10 && IsPressed) {
            if (e.isShiftDown() || e.isAltDown()) {
                this.cbMultiLine.setSelected(true);
            }
            if (this.cbMultiLine.isSelected()) {
                this.InputArea.insert("\n", this.InputArea.getCaretPosition());
                this.updateInputAreaScroller();
            } else {
                this.SendMessage(0);
            }
            e.setKeyCode(65535);
            return;
        }
        JMenuItem menu = App.menu_conf.findMenuItem(KeyStroke.getKeyStrokeForEvent(e));
        if (menu != null) {
            menu.doClick();
            e.setKeyCode(65535);
        }
    }

    public void history_prev() {
        String a = this.rireki_prev();
        if (a != null) {
            this.InputArea.setText(a);
            this.InputArea.setSelectionStart(0);
            this.InputArea.setSelectionEnd(a.length());
        }
    }

    public void history_next() {
        String a = this.rireki_next();
        if (a != null) {
            this.InputArea.setText(a);
            this.InputArea.setSelectionStart(0);
            this.InputArea.setSelectionEnd(a.length());
        }
    }

    public void pasteText(String s) {
        int end;
        int start = this.InputArea.getSelectionStart();
        if (start < (end = this.InputArea.getSelectionEnd())) {
            this.InputArea.replaceRange(s, start, end);
            this.InputArea.setCaretPosition(start + s.length());
        } else {
            this.InputArea.insert(s, this.InputArea.getCaretPosition());
        }
        this.updateInputAreaScroller();
    }

    public void cutText() {
        String s = this.InputArea.getSelectedText();
        if (s == null || s.length() == 0) {
            return;
        }
        App.os_dependence.Copy(s);
        int start = this.InputArea.getSelectionStart();
        int end = this.InputArea.getSelectionEnd();
        if (start < end) {
            this.InputArea.replaceRange("", start, end);
            this.InputArea.setCaretPosition(start);
            this.updateInputAreaScroller();
        }
    }

    public boolean hasSelectedText() {
        int end;
        int start = this.InputArea.getSelectionStart();
        return start < (end = this.InputArea.getSelectionEnd());
    }

    public void repair() {
        this.RightBottomPanel.remove(this.InputAreaScroller);
        this.initInputArea();
        this.updateInputAreaScroller();
    }
}

