/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.Util;
import bluntirc.App;
import gui.FontInfo;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class UserTableCellRenderer
extends JComponent
implements TableCellRenderer {
    FontInfo cf;
    ImageIcon icon_user = Util.GetImageIconFromJAR("images/user1.gif");
    ImageIcon icon_userV = Util.GetImageIconFromJAR("images/user2.gif");
    ImageIcon icon_userO = Util.GetImageIconFromJAR("images/user3.gif");
    Object value;
    boolean isSelected;
    boolean hasFocus;
    int col;

    UserTableCellRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.isSelected = isSelected;
        this.hasFocus = hasFocus;
        this.col = table.convertColumnIndexToModel(column);
        this.value = value;
        return this;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isSelected) {
            g.setColor(this.cf.bg2);
            g.fillRect(1, 1, width - 2, height - 2);
        }
        if (this.hasFocus) {
            g.setColor(this.cf.bg);
            g.drawRect(0, 0, width - 1, height - 1);
        }
        String text = this.value.toString();
        if (this.col == 0 && App.root_property.getBoolean("UseMemberListIcon", false)) {
            ImageIcon icon = text.indexOf(64) != -1 ? this.icon_userO : (text.indexOf(43) != -1 ? this.icon_userV : this.icon_user);
            Image image = icon.getImage();
            if (image != null) {
                g.drawImage(image, width - image.getWidth(this), 0, this);
            }
            return;
        }
        g.setFont(this.cf.font);
        FontMetrics fm = g.getFontMetrics();
        int text_width = fm.stringWidth(text);
        g.setColor(this.isSelected ? this.cf.fg2 : this.cf.fg);
        int align = 0;
        switch (this.col) {
            case 0: {
                align = 1;
                break;
            }
            case 1: {
                align = -1;
                break;
            }
            case 2: {
                align = -1;
                break;
            }
            case 3: {
                align = 0;
                break;
            }
            case 4: {
                align = 0;
                break;
            }
            case 5: {
                align = 1;
                break;
            }
            case 6: {
                align = 1;
                break;
            }
            case 7: {
                align = -1;
            }
        }
        boolean right = false;
        if (align == 1) {
            right = true;
        } else if (align == 0 && text_width > width - 4) {
            right = true;
        }
        g.drawString(text, right ? width - 2 - text_width : 2, fm.getHeight() - fm.getDescent());
    }
}

