/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import bluntirc.App;
import bluntirc.PropertyManager;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WindowPos {
    public static void setWindowsPosToCenter(Frame window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = window.getSize();
        int x = frameSize.width > screenSize.width ? 0 : (screenSize.width - frameSize.width) / 2;
        int y = frameSize.height > screenSize.height ? 0 : (screenSize.height - frameSize.height) / 2;
        window.setLocation(x, y);
    }

    public static void loadWindowPos(Frame window, String name) {
        int state;
        Object o = App.root_property.get(name);
        if (!(o instanceof LinkedList)) {
            return;
        }
        LinkedList list = (LinkedList)o;
        if (list.size() < 6) {
            return;
        }
        int n = state = list.size() >= 6 ? PropertyManager.IntValue(list.get(5)) : 0;
        if (0 == (state & 6)) {
            Rectangle la_rect = new Rectangle();
            la_rect.y = PropertyManager.IntValue(list.get(0));
            la_rect.x = PropertyManager.IntValue(list.get(1));
            la_rect.width = PropertyManager.IntValue(list.get(2));
            la_rect.height = PropertyManager.IntValue(list.get(3));
            window.setBounds(la_rect);
        }
        if (list.size() >= 5 && PropertyManager.BooleanValue(list.get(4))) {
            window.show();
        }
        window.setExtendedState(state);
    }

    public static void saveWindowPos(Frame window, String name) {
        LinkedList<String> list = new LinkedList<String>();
        Rectangle r = window.getBounds();
        list.add("" + r.y);
        list.add("" + r.x);
        list.add("" + r.width);
        list.add("" + r.height);
        list.add("" + window.isShowing());
        list.add("" + window.getExtendedState());
        App.root_property.set(name, list);
    }

    public static void saveSplitterPos(String key, JSplitPane c) {
        App.root_property.setInt(key, c.getDividerLocation());
    }

    public static void loadSplitterPos(String key, JSplitPane c) {
        Object o = App.root_property.get(key);
        if (o instanceof String) {
            try {
                c.setDividerLocation(PropertyManager.IntValue(o));
            }
            catch (Throwable e) {
                App.Log("loadSplitterPos fail" + key + "=" + o);
                c.setDividerLocation(-1);
            }
        }
    }

    public static void loadTableColPos(JTable table, String prop_name) {
        PropertyManager property = App.root_property;
        List list = property.getList(prop_name);
        int[] w = WindowPos.getColWidthAll(table);
        if (list.size() == w.length) {
            for (int i = 0; i < w.length; ++i) {
                w[i] = PropertyManager.IntValue(list.get(i));
            }
            WindowPos.setColWidthAll(table, w);
        }
    }

    public static void saveTableColPos(JTable table, String prop_name) {
        PropertyManager property = App.root_property;
        int[] s = WindowPos.getColWidthAll(table);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < s.length; ++i) {
            list.add("" + s[i]);
        }
        property.set(prop_name, list);
    }

    public static int[] getColWidthAll(JTable table) {
        TableColumnModel tcm = table.getColumnModel();
        int size = tcm.getColumnCount();
        int[] result = new int[size * 2];
        for (int i = 0; i < size; ++i) {
            TableColumn c = tcm.getColumn(i);
            result[i] = c.getWidth();
            result[i + size] = c.getModelIndex();
        }
        return result;
    }

    public static void setColWidthAll(JTable table, int[] w) {
        int i;
        TableColumnModel tcm = table.getColumnModel();
        int size = tcm.getColumnCount();
        for (i = 0; i < size && size + i < w.length; ++i) {
            table.moveColumn(table.convertColumnIndexToView(w[size + i]), i);
        }
        for (i = 0; i < size && i < w.length; ++i) {
            int width = w[i];
            if (width <= 0) {
                width = 16;
            }
            tcm.getColumn(i).setPreferredWidth(width);
        }
    }
}

