/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.BufferClickAdapter;
import buffer.BufferTextBlock;
import buffer.LogDiv;
import buffer.LogSelPos;
import buffer.LogSelectionRange;
import buffer.LogView;
import buffer.PackedLineReader;
import buffer.PackedLineWriter;
import buffer.StyleID;
import buffer.TextSpanInfo;
import gui.FontInfo2;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class LogDocument
implements PopupMenuListener {
    StyleID sid;
    private Dimension size = new Dimension(-1, 0);
    private int scrolly = 0;
    private int linecount;
    private LogView view;
    private LinkedList blocks = new LinkedList();
    public static int config_LogSweepMax = 2000;
    private int viewHeight = 0;
    private TextSpanInfo hover;
    private LogSelPos badpos = new LogSelPos(-1);
    private LogSelPos SelStartPos = new LogSelPos(-1);
    private LogSelPos SelEndPos = new LogSelPos(-1);
    LogSelPos lastPressStart;
    boolean in_area_select = false;
    TextSpanInfo hover_lastpopup;
    boolean isMenuOpen = false;

    public LogDocument(StyleID sid) {
        this.sid = sid;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public int getScrollY() {
        return this.scrolly;
    }

    public int setScrollY(int y) {
        this.scrolly = y;
        return this.scrolly;
    }

    public int lines() {
        return this.linecount;
    }

    public int getLineCount() {
        return this.linecount;
    }

    public void addView_byLogView(LogView lv) {
        this.view = lv;
        this.hover = null;
    }

    public void ReloadSetting(Component c) {
        this.size.height = 0;
        this.linecount = 0;
        Iterator it = this.blocks.iterator();
        while (it.hasNext()) {
            BufferTextBlock node = (BufferTextBlock)it.next();
            this.size.height += node.updateHeight(c, this.size.width, this.sid);
            this.linecount += node.getLineCount();
        }
        if (this.view != null) {
            this.view.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void sweepOld() {
        if (this.linecount < config_LogSweepMax) {
            return;
        }
        int old_lines = this.linecount;
        int old_size = this.blocks.size();
        int old_height = this.size.height;
        this.size.height = 0;
        this.linecount = 0;
        ListIterator i = this.blocks.listIterator(this.blocks.size());
        while (i.hasPrevious()) {
            BufferTextBlock node = (BufferTextBlock)i.previous();
            this.size.height += node.getHeight();
            this.linecount += node.getLineCount();
            if (this.linecount <= config_LogSweepMax) continue;
            break;
        }
        while (i.hasPrevious()) {
            i.previous();
            i.remove();
        }
        if (this.blocks.size() != old_size) {
            if (this.SelStartPos.lineno >= 0) {
                this.SelStartPos.lineno -= old_lines - this.linecount;
            }
            if (this.SelEndPos.lineno >= 0) {
                this.SelEndPos.lineno -= old_lines - this.linecount;
            }
            this.scrolly -= old_height - this.size.height;
            if (this.scrolly < 0) {
                this.scrolly = 0;
            }
        }
        if (this.view != null) {
            this.view.onLogSweep();
        }
    }

    public void addText(Component g, String t) {
        Vector<String> texts = new Vector<String>(1);
        texts.add(t);
        FontInfo2 style = FontInfo2.getDefaultStyle();
        PackedLineWriter tsi = new PackedLineWriter(this.sid, "base");
        tsi.appendText(texts, 0, 0, null);
        this.addText(g, tsi);
    }

    public void addText(Component c, PackedLineWriter tsi) {
        this.addText(c, tsi, null);
    }

    public void addText(Component c, PackedLineWriter tsi, Object o) {
        this.sweepOld();
        int text_length = tsi.text.size();
        int style_count = tsi.style.size();
        if (this.blocks.size() == 0 || !((BufferTextBlock)this.blocks.getLast()).canAppendLine(text_length, style_count)) {
            this.blocks.add(new BufferTextBlock(text_length, style_count));
        }
        BufferTextBlock block = (BufferTextBlock)this.blocks.getLast();
        int add_height = block.appendHeight(c, this.size.width, tsi.text.toCharArray(), tsi.style.toByteArray(), this.sid, o);
        this.size.height += add_height;
        ++this.linecount;
        if (this.view != null) {
            this.view.onAddText(add_height);
        } else {
            int old_size = this.size.height - add_height;
            if (this.size.height <= this.viewHeight) {
                this.scrolly = 0;
            } else if (old_size - this.viewHeight - this.scrolly <= add_height) {
                this.scrolly = this.size.height - this.viewHeight;
            }
        }
    }

    void updateHover(TextSpanInfo neo) {
        LogSelectionRange selected = new LogSelectionRange(this.SelStartPos, this.SelEndPos);
        if (!selected.empty()) {
            neo = null;
        }
        if (neo == null ? this.hover == null : this.hover != null && this.hover.block == neo.block && this.hover.line == neo.line && this.hover.span_index == neo.span_index) {
            return;
        }
        this.hover = neo;
        if (this.view != null) {
            Cursor c = this.hover == null ? null : (Cursor)this.hover.base_style.get(11);
            this.view.setCursor(c != null ? c : Cursor.getDefaultCursor());
            this.view.repaint(100L);
        }
    }

    public void setWidth(Component g, int w, int viewHeight) {
        this.viewHeight = viewHeight;
        if (this.size.width != w) {
            this.size.width = w;
            this.ReloadSetting(g);
        }
    }

    public void clear(Component g) {
        this.SelectionReset();
        this.blocks.clear();
        this.ReloadSetting(g);
        if (this.view != null) {
            this.view.OnResize();
            this.view.repaint(100L);
        }
    }

    public void paint(Graphics g, LogView view, int width) {
        LogSelectionRange selected;
        Composite old_composite = null;
        Stroke old_stroke = null;
        if (g instanceof Graphics2D) {
            old_composite = ((Graphics2D)g).getComposite();
            old_stroke = ((Graphics2D)g).getStroke();
        }
        if (this.size.width != width) {
            this.size.width = width;
            this.ReloadSetting(view);
        }
        if ((selected = new LogSelectionRange(this.SelStartPos, this.SelEndPos)).empty()) {
            selected.clear(-1);
        }
        Rectangle rec = g.getClipBounds();
        int ly_start = rec.y + this.scrolly;
        int ly_end = ly_start + rec.height;
        int linesum = 0;
        int y_start = 0;
        Iterator it = this.blocks.iterator();
        while (it.hasNext()) {
            BufferTextBlock block = (BufferTextBlock)it.next();
            if (y_start >= ly_end) break;
            if (ly_start < y_start + block.getHeight()) {
                int j = 0;
                for (int ys = y_start; j < block.getLineCount() && ys < ly_end; ys += block.getLineHeight(j++)) {
                    if (ly_start >= ys + block.getLineHeight(j)) continue;
                    int lineno = linesum + j;
                    LogDiv div = new LogDiv(block, j, this.sid);
                    div.updateHeight(g, this.size.width);
                    if (div.lines == null || div.lines.length == 0) continue;
                    LogSelectionRange linerange = lineno < selected.start.lineno || lineno > selected.end.lineno ? new LogSelectionRange(div.GetEndPos(), div.GetEndPos()) : new LogSelectionRange(selected, lineno, div.GetEndPos());
                    int hover_span = this.hover != null && this.hover.block == block && this.hover.line == j ? this.hover.span_index : -1;
                    div.draw(g, ys - this.scrolly, j, linerange, hover_span);
                }
            }
            y_start += block.getHeight();
            linesum += block.getLineCount();
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setComposite(old_composite);
            ((Graphics2D)g).setStroke(old_stroke);
        }
    }

    public LogSelPos PointToPos(Object component, int x, int y, boolean severe) {
        if ((y += this.scrolly) < 0 && severe) {
            return null;
        }
        int y_start = 0;
        int lineno = 0;
        Iterator it = this.blocks.iterator();
        while (it.hasNext()) {
            BufferTextBlock block = (BufferTextBlock)it.next();
            if (y < y_start + block.getHeight()) {
                int ys = y_start;
                int j = 0;
                while (j < block.getLineCount()) {
                    if (y < ys + block.getLineHeight(j)) {
                        LogDiv div = new LogDiv(block, j, this.sid);
                        div.updateHeight(component, this.size.width);
                        LogSelPos result = div.PointToPos(component, new Point(x, y - ys), severe);
                        if (result == null) {
                            return null;
                        }
                        result.lineno = lineno + j;
                        return result;
                    }
                    ys += block.getLineHeight(j++);
                }
            }
            y_start += block.getHeight();
            lineno += block.getLineCount();
        }
        return severe ? null : new LogSelPos(lineno);
    }

    public TextSpanInfo PosToSpan(LogSelPos pos) {
        int s = 0;
        Iterator it = this.blocks.iterator();
        while (it.hasNext()) {
            BufferTextBlock block = (BufferTextBlock)it.next();
            if (pos.lineno < s) break;
            if (pos.lineno < s + block.getLineCount()) {
                return new TextSpanInfo(block, pos.lineno - s, pos.span, pos.offset, this.sid);
            }
            s += block.getLineCount();
        }
        return null;
    }

    public void SelectionReset() {
        this.SelStartPos = this.badpos;
        this.SelEndPos = this.badpos;
        if (this.view != null) {
            this.view.repaint(100L);
        }
    }

    public void selectAll() {
        this.SelStartPos = new LogSelPos(0);
        this.SelEndPos = new LogSelPos(this.linecount);
        if (this.view != null) {
            this.view.repaint(100L);
        }
    }

    public String getSelectedText() {
        int last;
        LogSelectionRange range = new LogSelectionRange(this.SelStartPos, this.SelEndPos);
        if (range.empty()) {
            if (this.hover == null) {
                return "";
            }
            return this.hover.text;
        }
        StringBuffer sb = new StringBuffer();
        int lineno = 0;
        Iterator i = this.blocks.iterator();
        while (i.hasNext()) {
            BufferTextBlock block = (BufferTextBlock)i.next();
            if (range.start.lineno <= lineno + block.getLineCount()) {
                if (range.end.lineno < lineno) break;
                for (int j = 0; j < block.getLineCount(); ++j) {
                    int lno = lineno + j;
                    if (range.start.lineno > lno) continue;
                    if (range.end.lineno < lno) break;
                    PackedLineReader tsi = new PackedLineReader(block, j, this.sid, "base");
                    tsi.calcSpanNodes();
                    LogSelectionRange linerange = new LogSelectionRange(range, lno, tsi.span_count - 1, tsi.lastspan_length);
                    int s = 0;
                    while (true) {
                        int text_length = tsi.readSpan();
                        if (s >= linerange.start.span) {
                            if (s > linerange.end.span) break;
                            String spantext = tsi.getSpanText();
                            short start_o = s == linerange.start.span ? linerange.start.offset : (short)0;
                            int end_o = s == linerange.end.span ? (int)linerange.end.offset : text_length;
                            tsi.writeSubstringToStringBuffer(sb, start_o, end_o - start_o);
                        }
                        ++s;
                    }
                    if (lno >= range.end.lineno) continue;
                    sb.append("\n");
                }
            }
            lineno += block.getLineCount();
        }
        for (last = sb.length() - 1; last >= 0 && sb.charAt(last) == '\n'; --last) {
        }
        return last < 0 ? "" : sb.substring(0, last + 1);
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isMenuOpen && !this.in_area_select) {
            LogSelPos pos = this.PointToPos(e.getComponent(), e.getX(), e.getY(), true);
            this.updateHover(pos == null ? null : this.PosToSpan(pos));
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!this.isMenuOpen && !this.in_area_select) {
            this.updateHover(null);
        }
    }

    public void mousePressed(MouseEvent e) {
        LogSelectionRange range;
        LogSelPos pos = this.PointToPos(e.getComponent(), e.getX(), e.getY(), true);
        if (pos != null && (range = new LogSelectionRange(this.SelStartPos, this.SelEndPos)).isIn(pos)) {
            this.view.getTransferHandler().exportAsDrag(this.view, e, 1);
            return;
        }
        this.lastPressStart = this.PointToPos(e.getComponent(), e.getX(), e.getY(), false);
        if (this.lastPressStart == null) {
            this.SelectionReset();
            return;
        }
        System.err.println("selection start? lineno=" + this.lastPressStart.lineno + " span=" + this.lastPressStart.span + " offset=" + this.lastPressStart.offset);
        this.in_area_select = true;
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isMenuOpen) {
            this.updateHover(null);
            if (this.in_area_select) {
                if (this.lastPressStart != null) {
                    this.SelStartPos = this.lastPressStart;
                    this.lastPressStart = null;
                }
                this.SelEndPos = this.PointToPos(e.getComponent(), e.getX(), e.getY(), false);
                if (this.view != null) {
                    this.view.repaint(100L);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.in_area_select = false;
    }

    public boolean mouseClicked(MouseEvent e) {
        LogSelectionRange range;
        if (e.isPopupTrigger()) {
            return false;
        }
        LogSelPos pos = this.PointToPos(e.getComponent(), e.getX(), e.getY(), true);
        if (pos != null && (range = new LogSelectionRange(this.SelStartPos, this.SelEndPos)).isIn(pos)) {
            return false;
        }
        if (e.getButton() == 1) {
            this.SelectionReset();
        }
        if (pos == null) {
            return false;
        }
        TextSpanInfo lsd = this.PosToSpan(pos);
        this.updateHover(lsd);
        if (lsd == null) {
            return false;
        }
        BufferClickAdapter ca = (BufferClickAdapter)lsd.base_style.get(2);
        if (ca != null && ca.ClickEvent(e, this, lsd)) {
            return true;
        }
        if (e.getClickCount() == 2) {
            this.SelStartPos = new LogSelPos(pos.span, 0);
            this.SelEndPos = new LogSelPos(pos.span, lsd.text.length());
            this.SelStartPos.lineno = this.SelEndPos.lineno = pos.lineno;
            if (this.view != null) {
                this.view.repaint(100L);
            }
            return true;
        }
        return true;
    }

    public TextSpanInfo getLastHover() {
        return this.hover_lastpopup;
    }

    public String getMenuListener() {
        this.isMenuOpen = true;
        this.hover_lastpopup = null;
        LogSelectionRange range = new LogSelectionRange(this.SelStartPos, this.SelEndPos);
        if (range.empty() && this.hover != null) {
            this.hover_lastpopup = this.hover;
            FontInfo2 fi = this.hover.base_style;
            String s = (String)fi.get(5);
            if (s != null) {
                return s;
            }
        }
        return "popup-buffer";
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
        this.isMenuOpen = false;
    }
}

