/*
 * Decompiled with CFR 0.152.
 */
package buffer;

public class PackedLineBlock {
    int line_used = 0;
    char[] bulk_text;
    byte[] bulk_style;
    int[] text_start = new int[201];
    int[] style_start = new int[201];
    static final int maxline = 200;
    static int total_line_used = 100;
    static int total_text_used = 8200;
    static int total_style_used = 1200;
    int text_realloc_count = 0;
    int style_realloc_count = 0;

    public int getLineCount() {
        return this.line_used;
    }

    public char[] getTextArray() {
        return this.bulk_text;
    }

    public byte[] getStyleArray() {
        return this.bulk_style;
    }

    public int getTextStart(int line) {
        return this.text_start[line];
    }

    public int getTextEnd(int line) {
        return this.text_start[line + 1];
    }

    public int getStyleStart(int line) {
        return this.style_start[line];
    }

    public int getStyleEnd(int line) {
        return this.style_start[line + 1];
    }

    public PackedLineBlock(int tl, int sc) {
        double k = 1.2 / (double)total_line_used;
        this.bulk_text = new char[tl + (int)(k * (double)total_text_used * 199.0)];
        this.bulk_style = new byte[sc + (int)(k * (double)total_style_used * 199.0)];
        this.text_start[0] = 0;
        this.style_start[0] = 0;
    }

    static char[] reallocCharArray(char[] old, int new_length, int copy_length) {
        char[] neo = new char[new_length];
        for (int i = 0; i < copy_length; ++i) {
            neo[i] = old[i];
        }
        return neo;
    }

    static byte[] reallocByteArray(byte[] old, int new_length, int copy_length) {
        byte[] neo = new byte[new_length];
        for (int i = 0; i < copy_length; ++i) {
            neo[i] = old[i];
        }
        return neo;
    }

    public boolean canAppendLine(int text_length, int style_length) {
        boolean result;
        boolean bl = result = this.line_used < 200;
        if (result) {
            int new_length;
            double k = ((double)(this.line_used + 1) * 0.00125 + 1.2) / (double)total_line_used;
            int old_used = this.text_start[this.line_used];
            if (this.bulk_text.length < old_used + text_length) {
                ++this.text_realloc_count;
                new_length = old_used + text_length + (200 - this.line_used - 1) * (int)((double)total_text_used * k);
                this.bulk_text = PackedLineBlock.reallocCharArray(this.bulk_text, new_length, old_used);
            }
            if (this.bulk_style.length < (old_used = this.style_start[this.line_used]) + style_length) {
                ++this.style_realloc_count;
                new_length = old_used + style_length + (200 - this.line_used - 1) * (int)((double)total_style_used * k);
                this.bulk_style = PackedLineBlock.reallocByteArray(this.bulk_style, new_length, old_used);
            }
        }
        if (!result) {
            this.close_block();
        }
        return result;
    }

    public int appendLine(char[] text, byte[] style) {
        int i;
        ++total_line_used;
        total_text_used += text.length;
        total_style_used += style.length;
        int p = this.text_start[this.line_used];
        for (i = 0; i < text.length; ++i) {
            this.bulk_text[p++] = text[i];
        }
        this.text_start[this.line_used + 1] = p;
        p = this.style_start[this.line_used];
        for (i = 0; i < style.length; ++i) {
            this.bulk_style[p++] = style[i];
        }
        this.style_start[this.line_used + 1] = p;
        return this.line_used++;
    }

    int close_block() {
        int used = this.text_start[this.line_used];
        if (this.bulk_text.length > used) {
            this.bulk_text = PackedLineBlock.reallocCharArray(this.bulk_text, used, used);
        }
        if (this.bulk_style.length > (used = this.style_start[this.line_used])) {
            this.bulk_style = PackedLineBlock.reallocByteArray(this.bulk_style, used, used);
        }
        int blocksize = 64;
        blocksize += this.text_start.length * 4 + 12;
        int per_line = (blocksize += this.style_start.length * 4 + 12) / this.line_used;
        return per_line;
    }
}

