/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.PackedLineBlock;
import buffer.PackedStyle;
import buffer.StyleID;

public class PackedLineReader
extends PackedStyle {
    PackedLineBlock block;
    public int line;
    public char[] text_bulk;
    public byte[] style_bulk;
    public int style_end;
    public int style_offset;
    public int text_offset;
    public int text_span_length;
    public int span_count = 0;
    public int lastspan_length = 0;

    public PackedLineReader(PackedLineBlock block, int line, StyleID sid, String basestyle) {
        super(sid, basestyle);
        this.block = block;
        this.line = line;
        this.style_bulk = block.getStyleArray();
        this.style_offset = block.getStyleStart(line);
        this.style_end = block.getStyleEnd(line);
        this.text_bulk = block.getTextArray();
        this.text_offset = block.getTextStart(line);
        this.text_span_length = 0;
    }

    public boolean hasNextSpan() {
        return this.style_offset < this.style_end;
    }

    public int readSpan() {
        this.text_offset += this.text_span_length;
        this.text_span_length = 0;
        int long_text_flag = 0;
        while (this.style_offset < this.style_end) {
            int flag;
            if ((flag = 0xFF & this.style_bulk[this.style_offset++]) < 128) {
                this.text_span_length = flag + long_text_flag * 128;
                break;
            }
            if (flag == 128) {
                ++long_text_flag;
                continue;
            }
            if (flag < 192) {
                this.baseid = flag & 0x3F;
                continue;
            }
            if (flag == 207) break;
            if (flag < 224) {
                this.optionid[flag & 0xF] = 0xFF & this.style_bulk[this.style_offset++];
                continue;
            }
            this.optionid[flag & 0xF] = -1;
        }
        return this.text_span_length;
    }

    public String getSpanText() {
        return new String(this.text_bulk, this.text_offset, this.text_span_length);
    }

    public void writeSubstringToStringBuffer(StringBuffer sb, int start, int length) {
        sb.append(this.text_bulk, this.text_offset + start, length);
    }

    public void calcSpanNodes() {
        this.span_count = 0;
        this.lastspan_length = 0;
        int long_text_flag = 0;
        int bs = this.block.getStyleStart(this.line);
        while (bs < this.style_end) {
            int flag;
            if ((flag = 0xFF & this.style_bulk[bs++]) < 128) {
                ++this.span_count;
                this.lastspan_length = flag + long_text_flag * 128;
                long_text_flag = 0;
                continue;
            }
            if (flag == 128) {
                ++long_text_flag;
                continue;
            }
            if (flag < 192) continue;
            if (flag == 207) {
                ++this.span_count;
                this.lastspan_length = 0;
                continue;
            }
            if (flag >= 224) continue;
            ++bs;
        }
    }
}

