/*
 * Decompiled with CFR 0.152.
 */
package compiledplugin;

import base.SelectorItem;
import base.Util;
import bluntirc.App;
import compiledplugin.DCCReceiveManager;
import dialog.DialogEditItem_FilePath;
import irc.CTCPQuote;
import irc.IRCConnection;
import irc.IRCMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class DCCReceiveItem
implements SelectorItem {
    static final String[] scale = new String[]{"B", "KB", "MB", "GB", "TB"};
    static JFileChooser fc;
    static NumberFormat nf;
    DateFormat date_format;
    DateFormat time_format;
    Date _sendtime;
    String text_sendtime;
    IRCConnection conn;
    String from_nick;
    InetAddress src_host;
    int src_port;
    String text_sendaddr;
    File saveto;
    long src_size;
    String src_name;
    String text_srcsize;
    String text_srcfile;
    String text_saveto;
    String text_saveto_dir;
    String text_state;
    String text_speed;
    public static final int ST_PRESTART = 0;
    public static final int ST_PROGRESS = 1;
    public static final int ST_END = 2;
    public static final int ST_RESUME_WAIT = 3;
    int now_state = -1;
    DCCReceiveManager owner;
    int sec_read;
    long pre_time;
    long total_offset;
    SocketChannel channel;
    ByteBuffer read_buffer;
    ByteBuffer write_buffer;
    FileChannel fo;
    ByteBuffer fo_buffer;
    SelectionKey key;
    File resume_file;
    boolean read_end;
    protected int interest_ops_for_write;
    LinkedList ack = new LinkedList();

    public static void unloadStatic() {
        fc = null;
        nf = null;
    }

    String cropSize(double size) {
        if (size < 0.0) {
            return "\u4e0d\u660e";
        }
        if (nf == null) {
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
        }
        for (int i = 0; i < scale.length; ++i) {
            if (size < 1000.0 || i == scale.length - 1) {
                return nf.format(size) + scale[i];
            }
            size /= 1000.0;
        }
        return "?";
    }

    static int parseInt(String text, String desc) throws ParseException {
        if (text == null) {
            throw new ParseException(desc + "\u306e\u6307\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093", 0);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            throw new ParseException(desc + "\u306e\u5024" + text + "+\u3092\u6574\u6570\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093", 0);
        }
    }

    void setSaveTo(File file) {
        this.saveto = file;
        this.text_saveto = this.saveto.getName();
        this.text_saveto_dir = this.saveto.getParentFile().getAbsolutePath();
        if (this.owner != null) {
            this.owner.updateDisplay(this);
        }
    }

    public Object getCellValue(int col) {
        switch (col) {
            case 0: {
                return this.text_sendtime;
            }
            case 1: {
                return this.from_nick + "@" + this.conn.getListener().getConnectionName(this.conn);
            }
            case 2: {
                return this.text_sendaddr;
            }
            case 3: {
                return this.text_srcsize;
            }
            case 4: {
                return this.text_srcfile;
            }
            case 5: {
                return this.text_saveto_dir;
            }
            case 6: {
                return this.text_saveto;
            }
            case 7: {
                return this.text_state;
            }
            case 8: {
                return this.text_speed;
            }
        }
        return "?";
    }

    void setState(int state, String text, String detail) {
        this.now_state = state;
        this.text_state = text;
        if (detail != null) {
            this.text_speed = detail;
        }
        if (this.owner != null) {
            this.owner.updateDisplay(this);
        }
    }

    void clearStats(long start_pos) {
        this.pre_time = System.currentTimeMillis();
        this.total_offset = start_pos;
        this.sec_read = 0;
    }

    void updateSpeed(int plus) {
        this.total_offset += (long)plus;
        this.sec_read += plus;
        long now = System.currentTimeMillis();
        if (now - this.pre_time < 1000L) {
            return;
        }
        this.text_speed = this.cropSize((double)this.sec_read * 1000.0 / (double)(now - this.pre_time)) + "/s";
        this.text_state = this.cropSize(this.total_offset) + "/" + this.cropSize(this.src_size) + "\u53d7\u4fe1";
        this.pre_time = now;
        this.sec_read = 0;
        if (this.owner != null) {
            this.owner.updateDisplay(this);
        }
    }

    public void init(DCCReceiveManager owner, TimeZone tz, IRCConnection conn, String from_nick, String a_sendname, String a_address, String a_port, String a_size) throws ParseException {
        int i;
        int i2;
        this.resume_file = null;
        this.owner = owner;
        this.date_format = DateFormat.getDateInstance(1);
        this.time_format = DateFormat.getTimeInstance(1);
        this.date_format.setCalendar(new GregorianCalendar(tz));
        this.time_format.setCalendar(new GregorianCalendar(tz));
        this._sendtime = new Date();
        StringBuffer sb = new StringBuffer();
        for (i2 = 0; i2 < a_sendname.length(); ++i2) {
            char c = a_sendname.charAt(i2);
            if (-1 != "\\/:;".indexOf(c)) {
                sb = new StringBuffer();
                continue;
            }
            if (c < ' ' || c == '%' || c == '\u007f' || -1 != "?*,<>|\"".indexOf(c)) {
                sb.append('%');
                String Hex = Integer.toHexString(256 + c);
                sb.append(Hex.substring(Hex.length() - 2));
                continue;
            }
            sb.append(c);
        }
        this.src_name = sb.toString();
        if (a_address == null) {
            throw new ParseException("\u30a2\u30c9\u30ec\u30b9\u306e\u6307\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093", 0);
        }
        boolean nonDigit = false;
        for (i2 = 0; i2 < a_address.length(); ++i2) {
            if (Util.isURIDigit(a_address.charAt(i2))) continue;
            nonDigit = true;
            break;
        }
        if (!nonDigit) {
            long l = Long.parseLong(a_address);
            int[] a = new int[]{(int)(l >> 24) & 0xFF, (int)(l >> 16) & 0xFF, (int)(l >> 8) & 0xFF, (int)(l >> 0) & 0xFF};
            StringBuffer sb2 = new StringBuffer();
            for (i = 0; i < 4; ++i) {
                if (i != 0) {
                    sb2.append('.');
                }
                sb2.append(Integer.toString(a[i]));
            }
            a_address = new String(sb2);
        }
        try {
            this.src_host = InetAddress.getByName(a_address);
        }
        catch (UnknownHostException e) {
            throw new ParseException(a_address + "\u3092InetAddress\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093", 0);
        }
        this.src_port = DCCReceiveItem.parseInt(a_port, "\u9001\u4fe1\u5074\u30dd\u30fc\u30c8\u756a\u53f7");
        if (this.src_port < 1) {
            throw new ParseException("\u9001\u4fe1\u5074\u30dd\u30fc\u30c8\u756a\u53f7\u304c1\u3088\u308a\u5c0f\u3055\u3044", 0);
        }
        if (a_size == null) {
            this.src_size = -1L;
        } else {
            this.src_size = DCCReceiveItem.parseInt(a_size, "\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba");
            if (this.src_size < 1L) {
                throw new ParseException("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u304c1\u3088\u308a\u5c0f\u3055\u3044", 0);
            }
        }
        int dot = this.src_name.lastIndexOf(46);
        if (dot == -1) {
            dot = this.src_name.length();
        }
        String src_base = this.src_name.substring(0, dot);
        String src_ext = dot == this.src_name.length() ? "" : this.src_name.substring(dot);
        String path = DialogEditItem_FilePath.getPath(App.root_property.getString("DCCReceiver/DefaultSaveDirectory"));
        File savedir = new File(path != null ? path : "");
        if (!savedir.exists()) {
            try {
                savedir.mkdirs();
            }
            catch (SecurityException e) {
                throw new ParseException("\u4fdd\u5b58\u5148" + savedir.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306f\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3\u306b\u3088\u3063\u3066\u62d2\u5426\u3055\u308c\u305f\u3002" + e.getLocalizedMessage(), 0);
            }
        }
        i = 1;
        while (true) {
            String name = src_base + (i == 1 ? "" : "." + i) + src_ext;
            this.saveto = new File(savedir, name);
            if (!this.saveto.exists()) break;
            ++i;
        }
        this.text_sendtime = this.date_format.format(this._sendtime) + "_" + this.time_format.format(this._sendtime);
        this.conn = conn;
        this.from_nick = from_nick;
        this.text_sendaddr = this.src_host.getHostAddress() + " p#" + this.src_port;
        this.text_srcsize = this.cropSize(this.src_size);
        this.text_srcfile = this.src_name;
        this.setSaveTo(this.saveto);
        this.setState(0, "\u5f85\u6a5f\u4e2d", "\u53d7\u4fe1\u30dc\u30bf\u30f3\u304b\u518d\u958b\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044");
    }

    boolean canStopReceive() {
        return this.now_state == 1;
    }

    void stopReceive() {
        this.close("\u4e2d\u6b62", "\u30e6\u30fc\u30b6\u306b\u3088\u308b\u4e2d\u6b62");
    }

    boolean canRemove() {
        return this.now_state == 0 || this.now_state == 2;
    }

    void unload() {
        this.close("\u4e2d\u6b62", "\u30a2\u30f3\u30ed\u30fc\u30c9\u306e\u6e96\u5099");
        this.owner = null;
    }

    public void openFolder() {
        App.os_dependence.openFolder(this.saveto.getParentFile());
    }

    boolean canRename() {
        return this.now_state == 0;
    }

    void renameDialog() {
        if (fc == null) {
            fc = new JFileChooser();
        }
        fc.updateUI();
        fc.setSelectedFile(this.saveto);
        fc.setDialogType(1);
        fc.setDialogTitle("\u540d\u524d\u3092\u3064\u3051\u3066\u4fdd\u5b58");
        if (0 != fc.showSaveDialog(this.owner)) {
            return;
        }
        this.setSaveTo(fc.getSelectedFile());
    }

    public boolean canResume() {
        return this.now_state == 0;
    }

    void resume() {
        if (fc == null) {
            fc = new JFileChooser();
        }
        fc.updateUI();
        fc.setSelectedFile(this.saveto);
        fc.setDialogType(0);
        fc.setDialogTitle("\u3069\u306e\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u518d\u958b\u3057\u307e\u3059\u304b\uff1f");
        if (0 != fc.showSaveDialog(this.owner)) {
            return;
        }
        this.resume_file = fc.getSelectedFile();
        long pos = this.resume_file.length();
        if (pos >= this.src_size) {
            JOptionPane.showMessageDialog(this.owner, this.resume_file.getName() + "\u306b\u306f\u9001\u4fe1\u3055\u308c\u308b\u30d5\u30a1\u30a4\u30eb\u4ee5\u4e0a\u306e\u30b5\u30a4\u30ba\u304c\u3042\u308a\u307e\u3059\u3002\n\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u306f\u518d\u958b\u3067\u304d\u306a\u3044\u304b\u3001\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        Vector<String> v = new Vector<String>(5);
        v.add("DCC");
        v.add("RESUME");
        v.add("file.ext");
        v.add("" + this.src_port);
        v.add("" + pos);
        this.conn.SendToServer(this.conn.encodeCTCP(Util.toJIS(this.from_nick), v, "PRIVMSG"));
        this.setState(3, "\u4ea4\u6e09\u4e2d", "\u518d\u958b\u3092\u4ea4\u6e09\u3057\u3066\u3044\u307e\u3059");
    }

    public boolean onResumeAccept(IRCMessage m, int port, long pos, byte[] name) {
        if (port != this.src_port || m.conn != this.conn || !m.from.equals(Util.toJIS(this.from_nick))) {
            return false;
        }
        this.start(this.resume_file, pos);
        return true;
    }

    boolean canStart() {
        return this.now_state == 0;
    }

    void startReceive() {
        this.start(this.saveto, 0L);
    }

    void start(File savefile, long pos) {
        this.setSaveTo(savefile);
        try {
            InetSocketAddress remote = new InetSocketAddress(this.src_host, this.src_port);
            SocketAddress local = null;
            if (pos == 0L) {
                this.fo = new FileOutputStream(savefile).getChannel();
            } else {
                this.fo = new RandomAccessFile(savefile, "rw").getChannel();
                long oldsize = this.fo.size();
                if (oldsize > pos) {
                    this.fo.truncate(pos);
                } else if (pos > oldsize) {
                    JOptionPane.showMessageDialog(this.owner, savefile.getName() + "\u306e" + pos + "\u304b\u3089\u518d\u958b\u3059\u308b\u3088\u3046\u306b\u6307\u793a\u3055\u308c\u307e\u3057\u305f\u304c\u3001\u518d\u958b\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u304c\u305d\u308c\u3088\u308a\u5c0f\u3055\u3044\u3067\u3059\u3002");
                    this.close("\u30a8\u30e9\u30fc", "\u9001\u4fe1\u5074\u306e\u6307\u5b9a\u3057\u305f\u518d\u958b\u4f4d\u7f6e\u304c\u5909\u3067\u3059");
                    return;
                }
                this.fo.position(pos);
            }
            this.read_buffer = ByteBuffer.allocate(16384);
            this.write_buffer = ByteBuffer.allocate(4096);
            this.fo_buffer = ByteBuffer.allocate(16384);
            this.read_buffer.clear();
            this.write_buffer.flip();
            this.fo_buffer.flip();
            this.channel = SocketChannel.open();
            if (local != null) {
                this.channel.socket().bind(local);
            }
            this.channel.socket().setSoTimeout(180000);
            this.channel.socket().setTcpNoDelay(true);
            this.channel.socket().setReuseAddress(true);
            this.channel.configureBlocking(false);
            this.interest_ops_for_write = 0;
            this.key = App.selector.register(this, this.channel);
            this.channel.connect(remote);
            if (pos > 0L) {
                this.setState(1, "\u518d\u958b", "\u63a5\u7d9a\u3057\u307e\u3059\u2026");
            } else {
                this.setState(1, "\u63a5\u7d9a", "\u63a5\u7d9a\u3057\u307e\u3059\u2026");
            }
        }
        catch (IOException e) {
            this.closeByError(e, "\u63a5\u7d9a");
        }
    }

    public void onTimer(SelectableChannel which) {
    }

    public boolean onAcceptable(SelectableChannel which) {
        return true;
    }

    public boolean onConnectable(SelectableChannel which) {
        try {
            if (this.channel.finishConnect()) {
                this.interest_ops_for_write = 5;
                this.key.interestOps(this.interest_ops_for_write);
                this.clearStats(this.fo.position());
                this.setState(1, "\u63a5\u7d9a", "\u63a5\u7d9a\u3057\u307e\u3057\u305f");
                return false;
            }
            return false;
        }
        catch (IOException e) {
            return this.closeByError(e, "\u63a5\u7d9a");
        }
    }

    public boolean onReadable(SelectableChannel which) {
        int r = 0;
        try {
            r = this.channel.read(this.read_buffer);
        }
        catch (IOException e) {
            return this.closeByError(e, "\u53d7\u4fe1");
        }
        if (r > 0) {
            this.updateSpeed(r);
            this.ack.add(new Integer((int)this.total_offset));
            if (!this.write_buffer.hasRemaining()) {
                this.charge_write_buffer();
            }
            try {
                this.channel.write(this.write_buffer);
            }
            catch (IOException e) {
                return this.closeByError(e, "\u9001\u4fe1");
            }
            if (this.write_buffer.hasRemaining()) {
                this.key.interestOps(this.interest_ops_for_write);
            }
        }
        if (r == -1) {
            this.text_state = "save...";
            if (this.owner != null) {
                this.owner.updateDisplay(this);
            }
        }
        while (true) {
            if (this.fo_buffer.hasRemaining()) {
                try {
                    this.fo.write(this.fo_buffer);
                }
                catch (IOException e) {
                    return this.closeByError(e, "\u4fdd\u5b58");
                }
                if (this.fo_buffer.hasRemaining()) {
                    if (r == -1) continue;
                    return false;
                }
            }
            if (this.read_buffer.position() <= 0) break;
            ByteBuffer tmp = this.read_buffer;
            this.read_buffer = this.fo_buffer;
            this.fo_buffer = tmp;
            this.read_buffer.clear();
            this.fo_buffer.flip();
        }
        if (r != -1) {
            return false;
        }
        this.text_state = "Flushed";
        if (this.owner != null) {
            this.owner.updateDisplay(this);
        }
        this.read_end = true;
        if (this.ack.size() == 0 && !this.write_buffer.hasRemaining()) {
            App.Log("DCC\u53d7\u4fe1\u5b8c\u4e86 " + this.saveto.getPath());
            return this.close("\u5b8c\u4e86", "\u53d7\u4fe1\u304c\u7d42\u308f\u308a\u307e\u3057\u305f");
        }
        this.key.interestOps(4);
        return true;
    }

    public boolean onWritable(SelectableChannel which) {
        do {
            if (this.write_buffer.hasRemaining()) {
                try {
                    this.channel.write(this.write_buffer);
                }
                catch (IOException e) {
                    return this.closeByError(e, "\u9001\u4fe1");
                }
                if (this.write_buffer.hasRemaining()) {
                    return false;
                }
            }
            this.charge_write_buffer();
        } while (this.write_buffer.hasRemaining());
        if (this.read_end) {
            App.Log("DCC\u53d7\u4fe1\u5b8c\u4e86: " + this.saveto.getPath());
            return this.close("\u5b8c\u4e86", "\u53d7\u4fe1\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        }
        this.key.interestOps(1);
        return true;
    }

    public void onSelectorExit(SelectableChannel which) {
    }

    protected boolean closeByError(Throwable e, String desc) {
        String message = e.getLocalizedMessage();
        if (message == null || message.length() == 0) {
            message = e.getMessage();
        }
        if (message == null || message.length() == 0) {
            message = e.toString();
        }
        App.Log("DCC\u53d7\u4fe1 " + desc + "\u6642\u306b\u30a8\u30e9\u30fc:" + message);
        return this.close("\u30a8\u30e9\u30fc", desc + "\u6642\u306b\u30a8\u30e9\u30fc:" + message);
    }

    public boolean close(String text, String detail) {
        if (this.fo != null) {
            try {
                this.fo.close();
                this.fo = null;
            }
            catch (IOException e) {
                this.fo = null;
                return this.closeByError(e, "\u30d5\u30a1\u30a4\u30eb\u4fdd\u5b58");
            }
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel = null;
        }
        this.setState(2, text, detail);
        return true;
    }

    public void charge_write_buffer() {
        this.write_buffer.clear();
        Iterator it = this.ack.iterator();
        while (it.hasNext()) {
            this.write_buffer.putInt((Integer)it.next());
        }
        this.ack.clear();
        this.write_buffer.flip();
    }

    public DCCReceiveItem(DCCReceiveManager owner, TimeZone tz, IRCConnection conn, String from_nick, byte[] param, int i) throws ParseException {
        String[] desc = new String[]{"\u30d5\u30a1\u30a4\u30eb\u540d", "\u9001\u4fe1\u30a2\u30c9\u30ec\u30b9", "\u9001\u4fe1\u30dd\u30fc\u30c8", "\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba"};
        String[] value = new String[desc.length];
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        for (int j = 0; j < desc.length; ++j) {
            while (i < param.length && param[i] == 32) {
                ++i;
            }
            int start = i;
            while (i < param.length && param[i] != 32) {
                ++i;
            }
            if (i > start) {
                bao.reset();
                CTCPQuote.decodeParam(bao, param, start, i);
                value[j] = Util.fromJIS(bao.toByteArray());
                continue;
            }
            if (j == desc.length - 1) continue;
            throw new ParseException("DCC SEND\u306b" + desc[j] + "\u306e\u6307\u5b9a\u304c\u306a\u3044", 0);
        }
        this.init(owner, tz, conn, from_nick, value[0], value[1], value[2], value[3]);
    }

    public DCCReceiveItem(DCCReceiveManager owner, TimeZone tz, IRCConnection conn, String from_nick, String a_sendname, String a_address, String a_port, String a_size) throws ParseException {
        this.init(owner, tz, conn, from_nick, a_sendname, a_address, a_port, a_size);
    }
}

