/*
 * Decompiled with CFR 0.152.
 */
package compiledplugin;

import base.SelectorItem;
import base.Util;
import bluntirc.App;
import compiledplugin.DCCSendManager;
import irc.IRCConnection;
import irc.IRCMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;

class DCCSendItem
implements SelectorItem {
    static final String[] scale = new String[]{"B", "KB", "MB", "GB", "TB"};
    static NumberFormat nf;
    IRCConnection conn;
    String to_nick;
    String text_to;
    File sendfile;
    String text_srcfile;
    String text_srcfile_dir;
    String text_srcsize;
    TimeZone tz;
    DateFormat date_format;
    DateFormat time_format;
    Date _sendtime;
    String text_sendtime = "";
    String text_remote = "";
    String text_listen = "";
    String text_notify = "";
    boolean now_progress = false;
    String text_state;
    String text_speed;
    DCCSendManager owner;
    int sec_read = 0;
    long pre_time;
    long total_offset = 0L;
    ServerSocketChannel server;
    SocketChannel channel;
    SelectionKey key;
    FileChannel fi;
    ByteBuffer read_buffer;
    ByteBuffer write_buffer;
    boolean file_end;
    long last_ack = -1L;
    long resume_start_pos = 0L;

    public static void unloadStatic() {
        nf = null;
    }

    static String cropSize(double size) {
        if (size < 0.0) {
            return "\u4e0d\u660e";
        }
        if (nf == null) {
            nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
        }
        for (int i = 0; i < scale.length; ++i) {
            if (size < 1000.0 || i == scale.length - 1) {
                return nf.format(size) + scale[i];
            }
            size /= 1000.0;
        }
        return "?";
    }

    static int parseInt(String text, String desc) throws ParseException {
        if (text == null) {
            throw new ParseException(desc + "\u306e\u6307\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093", 0);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            throw new ParseException(desc + "\u306e\u5024" + text + "+\u3092\u6574\u6570\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093", 0);
        }
    }

    static String createSendName(String src) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c <= ' ') {
                c = '_';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String toNumber(String src) {
        if (-1 == src.indexOf(46)) {
            return src;
        }
        int[] i4 = new int[4];
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            int start = i;
            if ((i = src.indexOf(46, start)) == -1) {
                i = src.length();
            }
            i4[j] = Integer.parseInt(src.substring(start, i));
            ++i;
        }
        return Long.toString(((long)i4[0] << 24) + ((long)i4[1] << 16) + ((long)i4[2] << 8) + (long)i4[3]);
    }

    static ServerSocketChannel getServerSocket() throws Exception {
        InetAddress addr = null;
        String host = App.root_property.getString("DCCSender/IPAddressListen");
        if (host != null && host.length() > 0) {
            try {
                addr = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new Exception("\u8a2d\u5b9a\u306eListen\u30a2\u30c9\u30ec\u30b9\u306b\u66f8\u304b\u308c\u305f[" + host + "]\u3092InetAddress\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093");
            }
        } else {
            addr = InetAddress.getLocalHost();
        }
        int port_first = App.root_property.getInt("DCCSender/PortFirst", 1096);
        int port_last = App.root_property.getInt("DCCSender/PortLast", 1154);
        ServerSocketChannel server = ServerSocketChannel.open();
        for (int port = port_first; port <= port_last; ++port) {
            InetSocketAddress isa = null;
            try {
                isa = addr != null ? new InetSocketAddress(addr, port) : new InetSocketAddress(port);
            }
            catch (IllegalArgumentException e) {
                throw new Exception("\u30dd\u30fc\u30c8\u756a\u53f7\u306e\u8a2d\u5b9a\u304c\u5909\u3067\u3059\u3002");
            }
            try {
                server.socket().bind(isa);
                return server;
            }
            catch (Throwable e) {
                App.logger.log(Level.FINER, "DCCSend:getServerSocket", e);
                continue;
            }
        }
        server.close();
        throw new Exception("\u30dd\u30fc\u30c8\u306e\u7a7a\u304d\u304c\u3042\u308a\u307e\u305b\u3093");
    }

    void setState(boolean progress, String text, String detail) {
        this.now_progress = progress;
        this.text_state = text;
        if (detail != null) {
            this.text_speed = detail;
        }
        if (this.owner != null) {
            this.owner.updateDisplay(this);
        }
    }

    public Object getCellValue(int col) {
        switch (col) {
            case 0: {
                return this.text_sendtime;
            }
            case 1: {
                return this.text_listen;
            }
            case 2: {
                return this.text_to;
            }
            case 3: {
                return this.text_remote;
            }
            case 4: {
                return this.text_srcfile_dir;
            }
            case 5: {
                return this.text_srcfile;
            }
            case 6: {
                return this.text_srcsize;
            }
            case 7: {
                return this.text_state;
            }
            case 8: {
                return this.text_speed;
            }
            case 9: {
                return this.text_notify;
            }
        }
        return "?";
    }

    void clearStats(long start_pos) {
        this.pre_time = System.currentTimeMillis();
        this.sec_read = 0;
        this.total_offset = start_pos;
    }

    void updateSpeed(int plus) {
        this.total_offset += (long)plus;
        this.sec_read += plus;
        long now = System.currentTimeMillis();
        if (now - this.pre_time < 1000L) {
            return;
        }
        this.text_speed = DCCSendItem.cropSize((double)this.sec_read * 1000.0 / (double)(now - this.pre_time)) + "/s";
        this.text_state = DCCSendItem.cropSize(this.total_offset) + " \u9001\u4fe1";
        this.pre_time = now;
        this.sec_read = 0;
        if (this.owner != null) {
            this.owner.updateDisplay(this);
        }
    }

    boolean canStart() {
        return !this.now_progress;
    }

    void start() {
        this.last_ack = -1L;
        this.file_end = false;
        try {
            try {
                this.server = DCCSendItem.getServerSocket();
                this.server.socket().setReuseAddress(true);
            }
            catch (Throwable e) {
                this.setState(false, "\u30a8\u30e9\u30fc", e.toString());
                return;
            }
            InetSocketAddress s_addr = (InetSocketAddress)this.server.socket().getLocalSocketAddress();
            this.text_listen = s_addr.toString();
            this.fi = new FileInputStream(this.sendfile).getChannel();
            this.text_srcsize = DCCSendItem.cropSize(this.fi.size());
            this.read_buffer = ByteBuffer.allocate(4096);
            this.write_buffer = ByteBuffer.allocate(16384);
            this.write_buffer.flip();
            this.server.configureBlocking(false);
            App.selector.register(this, this.server);
            InetAddress show_addr = s_addr.getAddress();
            String host = null;
            switch (App.root_property.getInt("DCCSender/IPAddressShowType", 0)) {
                case 0: {
                    break;
                }
                case 1: {
                    host = this.conn.host001;
                    break;
                }
                case 2: {
                    host = Util.fromJIS(this.conn.myself.getHostBytes());
                    break;
                }
                case 3: {
                    host = App.root_property.getString("DCCSender/IPAddressShow");
                }
            }
            if (host != null && host.length() > 0) {
                try {
                    show_addr = InetAddress.getByName(host);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            Vector<Object> v = new Vector<Object>(6);
            v.add("DCC");
            v.add("SEND");
            v.add(Util.toJIS(this.text_srcfile));
            v.add(DCCSendItem.toNumber(show_addr.getHostAddress()));
            v.add("" + s_addr.getPort());
            v.add("" + this.fi.size());
            this.conn.SendToServer(this.conn.encodeCTCP(Util.toJIS(this.to_nick), v, "PRIVMSG"));
            this.text_notify = show_addr.toString();
            this.date_format = DateFormat.getDateInstance(1);
            this.time_format = DateFormat.getTimeInstance(1);
            this.date_format.setCalendar(new GregorianCalendar(this.tz));
            this.time_format.setCalendar(new GregorianCalendar(this.tz));
            this._sendtime = new Date();
            this.text_sendtime = this.date_format.format(this._sendtime) + "_" + this.time_format.format(this._sendtime);
            this.setState(true, "\u4ea4\u6e09\u4e2d", "\u76f8\u624b\u306e\u53d7\u4fe1\u958b\u59cb\u3092\u5f85\u3061\u307e\u3059");
        }
        catch (IOException e) {
            this.closeByError(e, "\u9001\u4fe1\u306e\u6e96\u5099");
        }
    }

    public boolean resumeRequest(IRCMessage m, int port, long pos, byte[] name) {
        InetSocketAddress s_addr = (InetSocketAddress)this.server.socket().getLocalSocketAddress();
        if (m.conn != this.conn || port != s_addr.getPort()) {
            return false;
        }
        try {
            App.Log(this.text_srcfile + "\u306e\u9001\u4fe1\u306b\u4f4d\u7f6e" + DCCSendItem.cropSize(pos) + "/" + DCCSendItem.cropSize(this.fi.size()) + "\u304b\u3089\u306e\u518d\u958b\u8981\u6c42\u304c\u304d\u307e\u3057\u305f");
            if (this.server == null) {
                App.Log("\u3057\u304b\u3057\u4ea4\u6e09\u4e2d\u3067\u306f\u306a\u3044\u306e\u3067\u7121\u8996\u3057\u307e\u3059\u3002");
                return true;
            }
            if (pos > this.fi.size()) {
                pos = this.fi.size();
            }
            this.fi.position(pos);
            this.last_ack = this.resume_start_pos = pos;
            this.to_nick = m.from.getName();
            this.text_to = this.to_nick + "@" + this.conn.getListener().getConnectionName(this.conn);
            Vector<Object> v = new Vector<Object>(5);
            v.add("DCC");
            v.add("ACCEPT");
            v.add(Util.toJIS(this.text_srcfile));
            v.add("" + port);
            v.add("" + pos);
            this.conn.SendToServer(this.conn.encodeCTCP(Util.toJIS(this.to_nick), v, "PRIVMSG"));
            this.setState(true, "\u4ea4\u6e09\u4e2d", DCCSendItem.cropSize(pos) + "\u304b\u3089\u306e\u518d\u958b\u8981\u6c42\u3092\u53d7\u3051\u307e\u3057\u305f");
        }
        catch (IOException e) {
            App.Log(this.text_srcfile + " " + e.getMessage());
            App.logger.log(Level.WARNING, this.text_srcfile, e);
        }
        return true;
    }

    public boolean onConnectable(SelectableChannel which) {
        return true;
    }

    public boolean onAcceptable(SelectableChannel which) {
        try {
            this.channel = this.server.accept();
            if (this.channel == null) {
                return false;
            }
            this.server.close();
            this.server = null;
            this.channel.socket().setSoTimeout(180000);
            this.channel.socket().setTcpNoDelay(true);
            this.channel.socket().setReuseAddress(true);
            SocketAddress r_addr = this.channel.socket().getRemoteSocketAddress();
            this.text_remote = r_addr.toString();
            this.channel.configureBlocking(false);
            this.key = App.selector.register(this, this.channel);
            this.key.interestOps(4);
            this.setState(true, "\u9001\u4fe1\u4e2d", "\u63a5\u7d9a\u3055\u308c\u307e\u3057\u305f");
            this.clearStats(this.fi.position());
            if (this.fi.position() >= this.fi.size()) {
                this.file_end = true;
                return this.close(false, "\u5b8c\u4e86", "\u9001\u4fe1\u304c\u7d42\u308f\u308a\u307e\u3057\u305f");
            }
            return true;
        }
        catch (Throwable e) {
            return this.closeByError(e, "\u63a5\u7d9a");
        }
    }

    public boolean onReadable(SelectableChannel which) {
        int r = 0;
        do {
            try {
                r = this.channel.read(this.read_buffer);
                this.parse_read_buffer();
            }
            catch (IOException e) {
                return this.closeByError(e, "\u53d7\u4fe1");
            }
        } while (r > 0);
        if (r == -1 || this.last_ack >= this.sendfile.length()) {
            App.Log("DCC\u9001\u4fe1\u5b8c\u4e86: " + this.text_srcfile);
            return this.close(false, "\u5b8c\u4e86", "\u9001\u4fe1\u304c\u7d42\u308f\u308a\u307e\u3057\u305f");
        }
        return true;
    }

    public boolean onWritable(SelectableChannel which) {
        do {
            if (this.write_buffer.hasRemaining()) {
                try {
                    this.updateSpeed(this.channel.write(this.write_buffer));
                }
                catch (IOException e) {
                    return this.closeByError(e, "\u9001\u4fe1");
                }
                if (this.write_buffer.hasRemaining()) break;
            }
            this.charge_write_buffer();
        } while (this.write_buffer.hasRemaining());
        this.onReadable(which);
        if (!this.file_end || this.write_buffer.hasRemaining()) {
            return false;
        }
        this.key.interestOps(1);
        return true;
    }

    public void onTimer(SelectableChannel which) {
    }

    void charge_write_buffer() {
        int r;
        this.write_buffer.clear();
        if (this.file_end) {
            return;
        }
        try {
            r = this.fi.read(this.write_buffer);
        }
        catch (IOException e) {
            this.closeByError(e, "read error");
            return;
        }
        this.write_buffer.flip();
        if (r == -1) {
            this.file_end = true;
            try {
                this.fi.close();
            }
            catch (IOException e) {
                this.fi = null;
                this.closeByError(e, "read error");
                return;
            }
            this.fi = null;
            this.setState(true, "\u53d7\u4fe1\u5831\u544a\u5f85\u3061", null);
        }
    }

    public void parse_read_buffer() {
        this.read_buffer.flip();
        try {
            while (true) {
                int i;
                if ((long)(i = this.read_buffer.getInt()) < this.last_ack) {
                    i = (int)((long)i + this.resume_start_pos);
                }
                this.last_ack = i;
            }
        }
        catch (Throwable e) {
            if (!this.read_buffer.hasRemaining()) {
                this.read_buffer.clear();
                return;
            }
            byte[] ba = new byte[this.read_buffer.remaining()];
            this.read_buffer.get(ba);
            this.read_buffer.clear();
            this.read_buffer.put(ba);
            return;
        }
    }

    public void onSelectorExit(SelectableChannel which) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean state, String text, String detail) {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
            }
            finally {
                this.channel = null;
            }
        }
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
            }
            finally {
                this.server = null;
            }
        }
        if (this.fi != null) {
            try {
                this.fi.close();
            }
            catch (IOException e) {
                this.fi = null;
                boolean bl = this.closeByError(e, "read error");
                return bl;
            }
            finally {
                this.fi = null;
            }
        }
        this.setState(state, text, detail);
        return true;
    }

    protected boolean closeByError(Throwable e, String desc) {
        App.logger.log(Level.WARNING, "DCCSend:closeByError:" + desc, e);
        String message = e.getLocalizedMessage();
        if (message == null || message.length() == 0) {
            message = e.getMessage();
        }
        if (message == null || message.length() == 0) {
            message = e.toString();
        }
        App.Log("DCC\u9001\u4fe1\u306e" + desc + "\u3067\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3057\u305f\u3002 " + message);
        return this.close(false, "\u30a8\u30e9\u30fc", message);
    }

    public boolean canStop() {
        return this.now_progress;
    }

    public void stop() {
        this.close(false, "\u4e2d\u6b62", "\u30e6\u30fc\u30b6\u306b\u3088\u308b\u4e2d\u6b62");
    }

    public boolean canRemove() {
        return !this.now_progress;
    }

    public void unload() {
        this.close(false, "\u30a2\u30f3\u30ed\u30fc\u30c9", "\u7d42\u4e86\u524d\u306e\u5f8c\u59cb\u672b");
        this.owner = null;
    }

    public void openFolder() {
        App.os_dependence.openFolder(this.sendfile.getParentFile());
    }

    public DCCSendItem(DCCSendManager owner, TimeZone tz, File sendfile, IRCConnection conn, String to_nick) {
        this.owner = owner;
        this.tz = tz;
        this.conn = conn;
        this.to_nick = to_nick;
        this.text_to = to_nick + "@" + conn.getListener().getConnectionName(conn);
        this.sendfile = sendfile;
        this.text_srcfile = DCCSendItem.createSendName(sendfile.getName());
        this.text_srcfile_dir = sendfile.getParentFile().getAbsolutePath();
        this.text_srcsize = DCCSendItem.cropSize(sendfile.length());
        this.setState(false, "\u5f85\u6a5f\u4e2d", "\u9001\u4fe1\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044");
    }
}

