/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import bluntirc.App;
import bluntirc.ConnTreeNode;
import dialog.DialogEditItem;
import dialog.DialogEditItem_TabSeparator;
import gui.StrictFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DialogBase
extends JDialog
implements KeyListener,
ChangeListener,
ActionListener,
ItemListener {
    JFrame parent;
    protected DialogEditItem[] items;
    protected Component[] items_value;
    protected ConnTreeNode node;
    protected Action a_ok;
    protected Action[] buttons = new Action[]{new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            DialogBase.this.ApplyChanges();
            DialogBase.this.hide();
            DialogBase.this.dispose();
        }
    }, new AbstractAction("\u30ad\u30e3\u30f3\u30bb\u30eb"){

        public void actionPerformed(ActionEvent e) {
            DialogBase.this.hide();
            DialogBase.this.dispose();
        }
    }};

    protected DialogBase() {
        this((JFrame)null);
    }

    protected DialogBase(JFrame parent) {
        super((Frame)(parent != null ? parent : App.main_window), false);
    }

    public JDialog getDialog() {
        return this;
    }

    protected void setup(ConnTreeNode node, DialogEditItem[] items) {
        this.node = node;
        this.items = items;
        this.initGUI();
        this.CheckInputs();
    }

    protected void CheckInputs_ok() {
    }

    protected abstract ConnTreeNode createNode();

    public ConnTreeNode getNode() {
        return this.node;
    }

    public void stateChanged(ChangeEvent e) {
        this.CheckInputs();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.CheckInputs();
    }

    public void actionPerformed(ActionEvent e) {
        this.CheckInputs();
    }

    public void itemStateChanged(ItemEvent e) {
        this.CheckInputs();
    }

    public void CheckInputs() {
        try {
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i].checkValue(this.items_value[i]);
            }
        }
        catch (Exception e) {
            this.setTitle("\u5165\u529b\u30a8\u30e9\u30fc: " + e.getMessage());
            this.a_ok.setEnabled(false);
            return;
        }
        this.a_ok.setEnabled(true);
        this.CheckInputs_ok();
    }

    public void ApplyChanges() {
        if (this.node == null) {
            this.node = this.createNode();
        }
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].applyValue(this.node, this.items_value[i]);
        }
    }

    protected void initGUI() {
        this.setResizable(false);
        StrictFocusTraversalPolicy ftp = new StrictFocusTraversalPolicy();
        JPanel RootPane = (JPanel)this.getContentPane();
        RootPane.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setTabLayoutPolicy(1);
        RootPane.add((Component)tabbedPane, "Center");
        tabbedPane.setFont(DialogEditItem.textFont);
        Container tfPanel = null;
        GridBagLayout gbl = null;
        GridBagConstraints c = null;
        this.items_value = new Component[this.items.length];
        String TabCaption = null;
        for (int i = 0; i < this.items.length; ++i) {
            this.items_value[i] = this.items[i].createControl(this.node);
            if (this.items[i] instanceof DialogEditItem_TabSeparator) {
                if (tfPanel != null) {
                    tabbedPane.addTab(TabCaption, tfPanel);
                }
                TabCaption = this.items[i].getCaption();
                tfPanel = new JPanel();
                ((JComponent)tfPanel).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                gbl = new GridBagLayout();
                tfPanel.setLayout(gbl);
                c = new GridBagConstraints();
                c.insets = new Insets(1, 2, 1, 2);
                continue;
            }
            ftp.components.addLast(this.items_value[i]);
            this.items[i].layout(this.items_value[i], gbl, c, tfPanel, this);
        }
        if (tfPanel.getComponentCount() != 0) {
            tabbedPane.addTab(TabCaption, tfPanel);
        }
        JPanel btnPannel = new JPanel();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].getValue("Name").equals("OK")) {
                this.a_ok = this.buttons[i];
            }
            JButton b = new JButton(this.buttons[i]);
            b.setFont(DialogEditItem.textFont);
            btnPannel.add(b);
            ftp.components.addLast(b);
        }
        this.setFocusTraversalPolicy(ftp);
        RootPane.add((Component)btnPannel, "South");
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
    }
}

