/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.Util;
import irc.IRCUser;

public class IRCChannelMember {
    private IRCUser user;
    private String mode;

    public IRCChannelMember(IRCUser _user, String _mode) {
        this.user = _user;
        this.setOp(_mode);
    }

    public IRCUser getUser() {
        return this.user;
    }

    public String getName() {
        return this.user.getName();
    }

    public void setOp(String _mode) {
        this.mode = Util.RecycleString(_mode);
    }

    public String OpString() {
        return this.mode;
    }

    private int findOp(char key) {
        return this.mode.indexOf(key);
    }

    public boolean hasOp(char key) {
        return -1 != this.findOp(key);
    }

    public boolean addOp(char key) {
        if (-1 != this.findOp(key)) {
            return false;
        }
        this.setOp(this.mode + key);
        return true;
    }

    public boolean removeOp(char key) {
        int j = this.findOp(key);
        if (j == -1) {
            return false;
        }
        StringBuffer after = new StringBuffer();
        for (int i = 0; i < this.mode.length(); ++i) {
            if (i == j) continue;
            after.append(this.mode.charAt(i));
        }
        this.setOp(after.toString());
        return true;
    }
}

