/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.Util;
import irc.IRCChannelNameOrPrefix;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Adler32;

public class IRCChannelName
implements Comparable,
IRCChannelNameOrPrefix {
    public static char config_EscapedNameStart = (char)8756;
    protected byte[] RawBytes;
    protected byte[] LowBytes;
    protected String PrintableName;
    protected String ShortName;
    static byte[] cvt_buf = new byte[5];
    static String alnum = "0123456789ABCDEFabcdef";
    private int hashcode;
    static String ary_from = "ABCDEFGHIJKLMNOPQRSTUVWXYZ[]\\";
    static String ary_to = "abcdefghijklmnopqrstuvwxyz{}|";

    public boolean isChannelName() {
        return IRCChannelName.isChannelName(this.RawBytes[0]);
    }

    public static boolean isChannelName(String s) {
        return IRCChannelName.isChannelName(s.charAt(0));
    }

    public static boolean isChannelName(byte[] s) {
        return IRCChannelName.isChannelName(s[0]);
    }

    public static boolean isChannelName(int c) {
        return -1 != "#!+&".indexOf(c);
    }

    public IRCChannelName(byte[] a) {
        this.set(a);
    }

    public IRCChannelName(String a) {
        this.set(a);
    }

    public void set(byte[] src) {
        int s;
        for (s = 0; s < src.length && Character.isWhitespace((char)src[s]); ++s) {
        }
        int start = s;
        while (s < src.length && IRCChannelName.isValidChannelChar((char)src[s])) {
            ++s;
        }
        if (start == 0 && s == src.length) {
            this.RawBytes = src;
        } else {
            this.RawBytes = new byte[s - start];
            for (s = 0; s < this.RawBytes.length; ++s) {
                this.RawBytes[s] = src[start + s];
            }
        }
        this.LowBytes = IRCChannelName.RawToLow(this.RawBytes);
        this.updateHashCode();
        this.PrintableName = IRCChannelName.RawToPrintable(this.RawBytes);
        this.ShortName = IRCChannelName.PrintableToShort(this.PrintableName);
    }

    public void set(String src) {
        this.RawBytes = IRCChannelName.unescape(IRCChannelName.TrimSpace(src));
        this.LowBytes = IRCChannelName.RawToLow(this.RawBytes);
        this.updateHashCode();
        this.PrintableName = IRCChannelName.RawToPrintable(this.RawBytes);
        this.ShortName = IRCChannelName.PrintableToShort(this.PrintableName);
    }

    public byte[] getRawBytes() {
        return this.RawBytes;
    }

    public byte[] getLowBytes() {
        return this.LowBytes;
    }

    public String getPrintableName() {
        return this.PrintableName;
    }

    public String getShortName() {
        return this.ShortName;
    }

    public String getName() {
        return this.getPrintableName();
    }

    public String getPrefix() {
        return this.getPrintableName();
    }

    public byte[] getJoinNameBytes() {
        if (this.RawBytes.length <= 6 || this.RawBytes[0] != 33) {
            return this.getRawBytes();
        }
        for (int i = 1; i <= 5; ++i) {
            if (-1 != "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".indexOf((char)this.RawBytes[i])) continue;
            return this.getRawBytes();
        }
        byte[] r = new byte[this.RawBytes.length - 5];
        r[0] = 33;
        for (int i = 6; i < this.RawBytes.length; ++i) {
            r[i - 5] = this.RawBytes[i];
        }
        return r;
    }

    public String getEscapedName() {
        StringBuffer sb = new StringBuffer();
        sb.append(config_EscapedNameStart);
        boolean escaped = false;
        boolean isInJIS = false;
        IRCChannelName.cvt_buf[0] = 27;
        IRCChannelName.cvt_buf[1] = 36;
        IRCChannelName.cvt_buf[2] = 66;
        for (int i = 0; i < this.RawBytes.length; ++i) {
            byte c = this.RawBytes[i];
            if (c > 32 && c < 127) {
                if (i >= 3 && this.RawBytes[i - 3] == 27 && this.RawBytes[i - 2] == 36 && this.RawBytes[i - 1] == 66) {
                    isInJIS = true;
                }
                if (isInJIS) {
                    if (i + 1 < this.RawBytes.length && this.RawBytes[i + 1] > 32 && this.RawBytes[i + 1] < 127) {
                        byte[] rev;
                        IRCChannelName.cvt_buf[3] = c;
                        IRCChannelName.cvt_buf[4] = this.RawBytes[i + 1];
                        String s = Util.fromJIS(cvt_buf);
                        if (s.length() > 0 && (rev = Util.toJIS(s)).length >= 5 && rev[3] == cvt_buf[3] && rev[4] == cvt_buf[4]) {
                            sb.append(s.charAt(0));
                            ++i;
                            continue;
                        }
                    } else {
                        isInJIS = false;
                    }
                }
                sb.append((char)c);
                continue;
            }
            isInJIS = false;
            escaped = true;
            sb.append('%');
            String Hex = Integer.toHexString(c + 256);
            sb.append(Hex.substring(Hex.length() - 2));
        }
        if (!escaped) {
            return Util.fromJIS(this.RawBytes);
        }
        return new String(sb);
    }

    public static byte[] unescape(String s) {
        int i = 0;
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        while (i < s.length()) {
            int start = i;
            while (i < s.length() && s.charAt(i) != config_EscapedNameStart) {
                ++i;
            }
            if (i > start) {
                try {
                    ba.write(Util.toJIS(s, start, i));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (++i >= s.length()) break;
            start = i;
            while (i < s.length() && s.charAt(i) != ' ') {
                ++i;
            }
            for (int pos = start; pos < i; ++pos) {
                byte[] rev;
                char c = s.charAt(pos);
                if (c > '\u007f' && (rev = Util.toJIS("" + c)).length >= 5) {
                    ba.write(rev[3]);
                    ba.write(rev[4]);
                    continue;
                }
                if (c == '%' && i - pos >= 3) {
                    int h = alnum.indexOf(s.charAt(pos + 1));
                    int l = alnum.indexOf(s.charAt(pos + 2));
                    if (h != -1 && l != -1) {
                        if (h > 16) {
                            h -= 6;
                        }
                        if (l > 16) {
                            l -= 6;
                        }
                        ba.write(h * 16 + l);
                        pos += 2;
                        continue;
                    }
                }
                ba.write(c);
            }
        }
        return ba.toByteArray();
    }

    private static String RawToPrintable(byte[] src) {
        String a = Util.fromJIS(src);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length(); ++i) {
            char c = a.charAt(i);
            if (c <= ' ' || c == '\u007f') {
                String hex = Integer.toHexString(256 + c);
                sb.append('%');
                sb.append(hex.substring(hex.length() - 2));
                continue;
            }
            sb.append(c);
        }
        return new String(sb);
    }

    public static String PrintableToShort(String src) {
        if (src.charAt(0) != '!') {
            return src;
        }
        return "!" + src.substring(6, src.length());
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        byte[] a = ((IRCChannelName)o1).LowBytes;
        byte[] b = ((IRCChannelName)o2).LowBytes;
        int i = 0;
        while (i < a.length && i < b.length) {
            int r = a[i] - b[i];
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return a.length - b.length;
    }

    public int compareTo(Object b) {
        return this == b ? 0 : this.compare(this, b);
    }

    public boolean equals(Object b) {
        return this.hashCode() != b.hashCode() ? false : (this == b ? true : 0 == this.compare(this, b));
    }

    public int hashCode() {
        return this.hashcode;
    }

    private void updateHashCode() {
        Adler32 check = new Adler32();
        check.update(this.LowBytes);
        long value = check.getValue();
        if (value > Integer.MAX_VALUE) {
            value -= 0x100000000L;
        }
        this.hashcode = (int)value;
    }

    public static byte[] RawToLow(byte[] src) {
        byte[] dst = new byte[src.length];
        for (int i = 0; i < dst.length; ++i) {
            int offset;
            byte c = src[i];
            dst[i] = c >= 32 && c <= 127 && (offset = ary_from.indexOf(c)) != -1 ? (byte)ary_to.charAt(offset) : c;
        }
        return dst;
    }

    public static boolean isValidChannelChar(char ch) {
        switch (ch) {
            case '\u0007': {
                return false;
            }
        }
        return true;
    }

    public static String TrimSpace(String src) {
        int s;
        for (s = 0; s < src.length() && Character.isWhitespace(src.charAt(s)); ++s) {
        }
        int start = s;
        while (s < src.length() && IRCChannelName.isValidChannelChar(src.charAt(s))) {
            ++s;
        }
        return src.substring(start, s);
    }
}

