/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.SelectorItem;
import base.SelectorRun;
import irc.IRCSocketReaderListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.logging.Logger;

class IRCSocketReader
implements SelectorItem {
    public static Logger logger = Logger.getLogger("irc.ircsocketreader");
    protected ByteBuffer read_buffer = ByteBuffer.allocate(4096);
    protected ByteBuffer write_buffer = ByteBuffer.allocate(4096);
    protected IRCSocketReaderListener listener;
    protected SelectionKey key;
    protected SocketChannel channel;
    protected static final byte[] byte_crlf;
    LinkedList[] cue = new LinkedList[]{new LinkedList(), new LinkedList()};
    String disconnect_reason;
    protected int interest_ops_for_write;
    long block_end = 0L;
    protected ByteArrayOutputStream line = new ByteArrayOutputStream(1000);

    public Socket getSocket() {
        return this.channel == null ? null : this.channel.socket();
    }

    public IRCSocketReader(SelectorRun selector, String r_host, int r_port, String l_host, int l_port, int timeout, IRCSocketReaderListener _listener) throws IOException {
        this.write_buffer.flip();
        this.listener = _listener;
        InetSocketAddress remote = new InetSocketAddress(InetAddress.getByName(r_host), r_port);
        InetSocketAddress local = null;
        local = null != l_host && 0 != l_host.length() ? new InetSocketAddress(InetAddress.getByName(l_host), l_port) : new InetSocketAddress(0);
        this.channel = SocketChannel.open();
        if (local != null) {
            this.channel.socket().bind(local);
        }
        this.channel.socket().setSoTimeout(timeout);
        this.channel.socket().setTcpNoDelay(true);
        this.channel.socket().setReuseAddress(true);
        this.channel.configureBlocking(false);
        this.interest_ops_for_write = 13;
        this.key = selector.register(this, this.channel);
        this.channel.connect(remote);
    }

    public boolean onAcceptable(SelectableChannel which) {
        return true;
    }

    public boolean onConnectable(SelectableChannel which) {
        try {
            if (this.channel.finishConnect()) {
                this.interest_ops_for_write = 5;
                try {
                    this.key.interestOps(this.interest_ops_for_write);
                }
                catch (CancelledKeyException e) {
                    // empty catch block
                }
                try {
                    this.listener.onConnect();
                }
                catch (Throwable e) {
                    this.listener.onMessageError(e);
                }
                return true;
            }
            return true;
        }
        catch (IOException e) {
            return this.closeByError(e, "connectionError");
        }
    }

    public boolean onWritable(SelectableChannel which) {
        block7: {
            do {
                if (!this.write_buffer.hasRemaining()) {
                    this.charge_write_buffer();
                    if (!this.write_buffer.hasRemaining()) break block7;
                }
                try {
                    this.channel.write(this.write_buffer);
                }
                catch (IOException e) {
                    return this.closeByError(e, "writeError");
                }
            } while (!this.write_buffer.hasRemaining());
            logger.finer("onWritable: wait next writable");
            return false;
        }
        if (this.cue[0].isEmpty() && this.cue[1].isEmpty() && this.disconnect_reason != null) {
            return this.close(this.disconnect_reason);
        }
        try {
            this.key.interestOps(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
        return true;
    }

    public void onTimer(SelectableChannel which) {
        try {
            this.key.interestOps(this.interest_ops_for_write);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public boolean onReadable(SelectableChannel which) {
        boolean full;
        do {
            this.read_buffer.clear();
            try {
                int r = this.channel.read(this.read_buffer);
                if (r == -1) {
                    return this.close("end of input stream");
                }
                if (r <= 0) {
                    return false;
                }
            }
            catch (IOException e) {
                return this.closeByError(e, "readError");
            }
            full = !this.read_buffer.hasRemaining();
            this.read_buffer.flip();
            this.flush_read_buffer();
        } while (full);
        return false;
    }

    public void onSelectorExit(SelectableChannel which) {
        this.close("onSelectorExit");
    }

    protected boolean closeByError(Throwable e, String reason) {
        this.listener.onConnectionError(e);
        return this.close(reason);
    }

    protected boolean close(String reason) {
        if (this.channel != null) {
            block5: {
                try {
                    this.channel.close();
                }
                catch (Throwable e) {
                    if (e.toString().indexOf("Descriptor not a socket") != -1 || e.toString().indexOf("socket was closed") != -1) break block5;
                    this.listener.onConnectionError(e);
                }
            }
            this.channel = null;
            try {
                this.listener.onDisconnect(reason);
            }
            catch (Throwable e) {
                this.listener.onMessageError(e);
            }
        }
        return true;
    }

    protected void addCue(byte[] ba, int type) {
        this.cue[type].addLast(ba);
        try {
            this.key.interestOps(this.interest_ops_for_write);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void WriteFast(byte[] ba) {
        this.addCue(ba, 0);
    }

    public void Write(byte[] ba) {
        this.addCue(ba, 1);
    }

    public void WriteQuit(byte[] ba, String reason) {
        this.disconnect_reason = reason;
        this.addCue(ba, 0);
    }

    void charge_write_buffer() {
        this.write_buffer.clear();
        long now = System.currentTimeMillis();
        if (this.block_end < now) {
            this.block_end = now;
        }
        block0: for (int type = 0; type < 2; ++type) {
            while (this.cue[type].size() > 0) {
                byte[] ba = (byte[])this.cue[type].getFirst();
                if (ba.length + 2 > this.write_buffer.limit()) {
                    if (this.write_buffer.position() != 0) continue block0;
                    this.write_buffer = ByteBuffer.allocate(ba.length + 20);
                    this.write_buffer.clear();
                }
                if (type == 1 && this.disconnect_reason == null && now + 10L < this.block_end || ba.length + 2 > this.write_buffer.remaining()) break block0;
                this.write_buffer.put(ba);
                this.write_buffer.put(byte_crlf);
                this.cue[type].removeFirst();
                this.block_end += (long)(1000 + ba.length * 33);
            }
        }
        this.write_buffer.flip();
    }

    public void flush_read_buffer() {
        while (this.read_buffer.hasRemaining()) {
            byte b = this.read_buffer.get();
            if (b == 13 || b == 10) {
                if (this.line.size() <= 0) continue;
                try {
                    this.listener.onRecvLine(this.line.toByteArray());
                }
                catch (Throwable e) {
                    this.listener.onMessageError(e);
                }
                this.line.reset();
                continue;
            }
            this.line.write(b);
        }
    }

    static {
        logger.setLevel(null);
        byte_crlf = new byte[]{13, 10};
    }
}

