/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.JVMUtilities;

public class ExceptionsAttribute
extends AttributeInfo {
    private List exceptionIndexTable;

    public ExceptionsAttribute(ConstantPool cp) {
        super(cp, "Exceptions");
        this.length = 2;
        this.exceptionIndexTable = new LinkedList();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.nameIndex);
        out.writeInt(this.length);
        out.writeShort(this.exceptionIndexTable.size());
        Iterator it = this.exceptionIndexTable.iterator();
        while (it.hasNext()) {
            out.writeShort(((Short)it.next()).shortValue());
        }
    }

    public void addException(String name) {
        String n = JVMUtilities.getName(name);
        this.exceptionIndexTable.add(new Short(this.constantPool.put(new ClassIdentifier(n))));
        this.length += 2;
    }
}

