/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.TreeClassInfo;
import koala.dynamicjava.interpreter.ClassInfoCompiler;
import koala.dynamicjava.interpreter.ClassPool;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.TreeClassFinder;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;

public class TreeCompiler {
    protected Interpreter interpreter;
    protected TreeClassLoader classLoader;
    protected ClassInfoLoader classInfoLoader;
    protected ClassPool classPool = new ClassPool();

    public TreeCompiler(Interpreter i) {
        this.interpreter = i;
        this.classLoader = (TreeClassLoader)this.interpreter.getClassLoader();
        this.classInfoLoader = new ClassInfoLoader();
    }

    public Class compile(String name) throws ClassNotFoundException {
        this.loadClass(name);
        return this.compileClasses(name);
    }

    /*
     * WARNING - void declaration
     */
    public Class compileClasses(String name) throws ClassNotFoundException {
        Class result = null;
        if (this.classPool.contains(name)) {
            ClassInfo ci;
            while ((ci = this.classPool.getFirstCompilable()) != null) {
                void var3_3;
                if (!this.classExists(var3_3.getName())) {
                    Class c = this.compileClass((ClassInfo)var3_3, name);
                    if (c == null) continue;
                    result = c;
                    continue;
                }
                var3_3.setCompilable(false);
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    public Class compileTree(Context ctx, TypeDeclaration td) {
        TreeClassFinder cf = new TreeClassFinder(ctx, this.interpreter, this.classPool);
        TreeClassInfo ci = new TreeClassInfo(td, cf);
        this.classPool.add(ci.getName(), ci);
        try {
            return this.compileClasses(ci.getName());
        }
        catch (ClassNotFoundException e) {
            td.setProperty("errorStrings", new String[]{td.getName()});
            throw new ExecutionError("undefined.or.defined.class", td);
        }
    }

    protected Class compileClass(ClassInfo ci, String name) {
        Class c;
        Class c2;
        Class result = null;
        ClassInfo t = ci.getSuperclass();
        if (t.isCompilable() && !this.classExists(t.getName()) && (c2 = this.compileClass(t, name)) != null) {
            result = c2;
        }
        ClassInfo[] ti = ci.getInterfaces();
        int i = 0;
        while (i < ti.length) {
            t = ti[i];
            if (t.isCompilable() && !this.classExists(t.getName()) && (c = this.compileClass(t, name)) != null) {
                result = c;
            }
            ++i;
        }
        c = new ClassInfoCompiler(ci).compile();
        ci.setCompilable(false);
        if (name.equals(c.getName())) {
            result = c;
        }
        return result;
    }

    protected boolean classExists(String name) {
        return this.classLoader.hasDefined(name);
    }

    protected void loadClass(String name) throws ClassNotFoundException {
        if (this.classPool.contains(name)) {
            return;
        }
        TypeDeclaration td = this.classLoader.getTree(name);
        if (td != null) {
            ImportationManager im = (ImportationManager)td.getProperty("importationManager");
            GlobalContext ctx = new GlobalContext(this.interpreter, this.classInfoLoader);
            im.setClassLoader(this.classInfoLoader);
            ctx.setImportationManager(im);
            TreeClassFinder cfinder = new TreeClassFinder(ctx, this.interpreter, this.classPool);
            this.classPool.add(name, new TreeClassInfo(td, cfinder));
            return;
        }
        LibraryFinder lf = this.interpreter.getLibraryFinder();
        try {
            String cun = lf.findCompilationUnitName(name);
            td = this.classLoader.getTree(cun);
            if (td != null) {
                ImportationManager im = (ImportationManager)td.getProperty("importationManager");
                GlobalContext ctx = new GlobalContext(this.interpreter, this.classInfoLoader);
                im.setClassLoader(this.classInfoLoader);
                ctx.setImportationManager(im);
                TreeClassFinder cfinder = new TreeClassFinder(ctx, this.interpreter, this.classPool);
                this.classPool.add(cun, new TreeClassInfo(td, cfinder));
                return;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            File f = lf.findCompilationUnit(name);
            FileInputStream fis = new FileInputStream(f);
            ParserFactory pf = this.interpreter.getParserFactory();
            SourceCodeParser p = pf.createParser(fis, f.getCanonicalPath());
            List stmts = p.parseCompilationUnit();
            Iterator it = stmts.iterator();
            CompilationUnitVisitor v = new CompilationUnitVisitor();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(v);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
    }

    public class PseudoError
    extends Error {
        protected ClassInfo classInfo;

        PseudoError(ClassInfo ci) {
            this.classInfo = ci;
        }

        public ClassInfo getClassInfo() {
            return this.classInfo;
        }
    }

    protected class ClassInfoLoader
    extends ClassLoader {
        protected ClassInfoLoader() {
            super(TreeCompiler.this.interpreter.getClass().getClassLoader());
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            TreeCompiler.this.loadClass(name);
            if (TreeCompiler.this.classPool.contains(name)) {
                throw new PseudoError(TreeCompiler.this.classPool.get(name));
            }
            throw new ClassNotFoundException(name);
        }
    }

    protected class CompilationUnitVisitor
    extends VisitorObject {
        protected Context context;
        protected ClassFinder classFinder;

        protected CompilationUnitVisitor() {
            this.context = new GlobalContext(TreeCompiler.this.interpreter, TreeCompiler.this.classInfoLoader);
            this.classFinder = new TreeClassFinder(this.context, TreeCompiler.this.interpreter, TreeCompiler.this.classPool);
        }

        public Object visit(PackageDeclaration node) {
            this.context.setCurrentPackage(node.getName());
            return null;
        }

        public Object visit(ImportDeclaration node) {
            if (node.isPackage()) {
                this.context.declarePackageImport(node.getName());
            } else {
                try {
                    this.context.declareClassImport(node.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                catch (PseudoError e) {
                }
            }
            return null;
        }

        public Object visit(ClassDeclaration node) {
            return this.visitType(node);
        }

        public Object visit(InterfaceDeclaration node) {
            return this.visitType(node);
        }

        protected Object visitType(TypeDeclaration node) {
            String cname = this.classFinder.getCurrentPackage();
            cname = (cname.equals("") ? "" : cname + ".") + node.getName();
            TreeCompiler.this.classPool.add(cname, new TreeClassInfo(node, this.classFinder));
            return null;
        }
    }
}

