/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.modifier;

import koala.dynamicjava.interpreter.UninitializedObject;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.VariableModifier;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.QualifiedName;

public class FinalVariableModifier
extends VariableModifier {
    public FinalVariableModifier(QualifiedName name, Class type) {
        super(name, type);
    }

    public void modify(Context ctx, Object value) {
        if (this.type.isPrimitive() || value == null || this.type.isAssignableFrom(value.getClass())) {
            if (ctx.get(this.representation) != UninitializedObject.INSTANCE) {
                throw new ExecutionError("cannot.modify", this.name);
            }
        } else {
            ClassCastException e = new ClassCastException(this.name.getRepresentation());
            throw new CatchedExceptionError(e, (Node)this.name);
        }
        ctx.setConstant(this.representation, value);
    }
}

