/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

public class ArrayInitializer
extends Expression {
    public static final String CELLS = "cells";
    public static final String ELEMENT_TYPE = "elementType";
    private List cells;
    private Type elementType;

    public ArrayInitializer(List cells) {
        this(cells, null, 0, 0, 0, 0);
    }

    public ArrayInitializer(List cells, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (cells == null) {
            throw new IllegalArgumentException("cells == null");
        }
        this.cells = cells;
    }

    public List getCells() {
        return this.cells;
    }

    public void setCells(List l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.cells = l;
        this.firePropertyChange(CELLS, this.cells, this.cells);
    }

    public Type getElementType() {
        if (this.elementType == null) {
            throw new IllegalStateException("elementType == null");
        }
        return this.elementType;
    }

    public void setElementType(Type t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.elementType = t;
        this.firePropertyChange(ELEMENT_TYPE, this.elementType, this.elementType);
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            Iterator it = this.cells.iterator();
            while (it.hasNext()) {
                Object init = it.next();
                if (!(init instanceof ArrayInitializer)) continue;
                ((ArrayInitializer)init).setElementType(at.getElementType());
            }
        }
    }

    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }
}

