/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.ContinueTarget;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.Statement;
import koala.dynamicjava.tree.visitor.Visitor;

public class DoStatement
extends Statement
implements ContinueTarget {
    public static final String CONDITION = "condition";
    public static final String BODY = "body";
    private Expression condition;
    private Node body;
    private List labels;

    public DoStatement(Expression cond, Node body) {
        this(cond, body, null, 0, 0, 0, 0);
    }

    public DoStatement(Expression cond, Node body, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (cond == null) {
            throw new IllegalArgumentException("cond == null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body == null");
        }
        this.condition = cond;
        this.body = body;
        this.labels = new LinkedList();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression e) {
        if (e == null) {
            throw new IllegalArgumentException("e == null");
        }
        this.condition = e;
        this.firePropertyChange(CONDITION, this.condition, this.condition);
    }

    public Node getBody() {
        return this.body;
    }

    public void setBody(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        this.body = node;
        this.firePropertyChange(BODY, this.body, this.body);
    }

    public void addLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        this.labels.add(label);
    }

    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }
}

