/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Literal;

public class LongLiteral
extends Literal {
    public LongLiteral(String rep) {
        this(rep, null, 0, 0, 0, 0);
    }

    public LongLiteral(String rep, String fn, int bl, int bc, int el, int ec) {
        super(rep, LongLiteral.parse(rep.substring(0, rep.length() - 1)), Long.TYPE, fn, bl, bc, el, ec);
    }

    private static Long parse(String s) {
        if (s.startsWith("0x")) {
            return LongLiteral.parseHexadecimal(s.substring(2, s.length()));
        }
        if (s.startsWith("0")) {
            return LongLiteral.parseOctal(s);
        }
        return Long.valueOf(s);
    }

    private static Long parseHexadecimal(String s) {
        long value = 0L;
        int i = 0;
        while (i < s.length()) {
            char c = Character.toLowerCase(s.charAt(i));
            if (value >>> 60 != 0L) {
                throw new NumberFormatException(s);
            }
            value = (value << 4) + (long)c + (long)(c >= 'a' && c <= 'f' ? -87 : -48);
            ++i;
        }
        return new Long(value);
    }

    private static Long parseOctal(String s) {
        int value = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (value >>> 61 != 0) {
                throw new NumberFormatException(s);
            }
            value = (value << 3) + c - 48;
            ++i;
        }
        return new Long(value);
    }
}

