// UTF-8 ☀☁☂☃
package bluntirc;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.text.ParseException;
import irc.*;
import base.*;
import bluntirc.djava.ScriptItem;

import java.util.regex.Pattern;
import java.util.regex.Matcher;

	class Servers{
		Vector servers;
		int ServerPort;
	}

public class ConnectionListener
implements IRCConnectionListener
{
	public base.SelectorRun getSelector(){ return App.selector; }


	public static File logdir=new File("log");

	public  IRCMessage rewriteIRCMessage1(IRCMessage m){
		for(Iterator it=App.hook_manager.getHookList();it.hasNext();){
			ScriptItem si= (ScriptItem)it.next();
			Object plugin = si.getPlugin();
			if( plugin instanceof hook.IRCMessageRewrite1 ){
			//	App.hook_manager.setScriptItem(si);
				try{
					m= ((hook.IRCMessageRewrite1)plugin).rewriteIRCMessage1(m);
					if(m==null) break;
				}catch(Throwable e){
					App.hook_manager.parseScriptError(si.getName(),e);
				}
			}
		}
		return m;
	}

	public  IRCMessage rewriteIRCMessage2(IRCMessage m){
		for(Iterator it=App.hook_manager.getHookList();it.hasNext();){
			ScriptItem si= (ScriptItem)it.next();
			Object plugin = si.getPlugin();
			if( plugin instanceof hook.IRCMessageRewrite2 ){
			//	App.hook_manager.setScriptItem(si);
				try{
					m= ((hook.IRCMessageRewrite2)plugin).rewriteIRCMessage2(m);
					if(m==null) break;
				}catch(Throwable e){
					App.hook_manager.parseScriptError(si.getName(),e);
				}
			}
		}
		return m;
	}
/*
		if(cmd.equals("INVITE")
		&& config_InviteAutoJoin
		){
			String value =params[1];
			if(value == null
			|| value.length() == 0
			|| value.charAt(0) == ' '
			) return;

			IRCChannel chan = cs.GetConn().FindChannel(IRCConnection.MakeLowerName(value),value,true);
			if(chan!=null){
				if(chan.Extra ==null){
					IRCBufferInfo b = new IRCBufferInfo(LogBufferFont,cs.GetConn(),chan,UserListListener);
					chan.Extra  = b;
					ChannelList_Select(ChannelList_Add(b));
					return;
				}
				ChannelList_Select(chan.GetName());
				Log(t,conn,chan,10,"※ "+params[0] + " に招待されました。");
				if(chan.isChannel()) chan.Join(m.conn);
			}
		}
*/

	// パラメータの指定
	public TimeZone getTimeZone(IRCConnection conn){
		Object o = ((CTN_Conn)conn.Extra).property.get("TimeZoneObject");
		if(o instanceof TimeZone) return (TimeZone)o;
		TimeZone tz = TimeZone.getTimeZone( 
			((CTN_Conn)conn.Extra).property.setDefaultString("TimeZone","JST")
		);
		((CTN_Conn)conn.Extra).property.set("TimeZoneObject",tz);
		return tz;
	}

	static int rand(int size){ return (int) (Math.random()*size); }


	public int    getServerPort(IRCConnection conn,int connect_try_count){ 
		Servers sv = (Servers)((CTN_Conn)conn.Extra).property.get("__Servers");
		return sv.ServerPort;
	}
	Pattern hostport_ipv6 = Pattern.compile("([^\\s;]+)\\s*;\\s*");
	Pattern hostport_ipv4 = Pattern.compile("([^\\s:]+)\\s*:\\s*");
	Pattern numeric_pattern = Pattern.compile("(\\d+)");
	Pattern range_pattern = Pattern.compile("(\\d+)\\D+(\\d+)");

	public String getServerHost(IRCConnection conn,int connect_try_count){
		Servers sv;
		if(connect_try_count==0){
			((CTN_Conn)conn.Extra).property.put("__Servers",sv = new Servers());
			sv.servers= new Vector();
			sv.servers.add( new String[]{
				((CTN_Conn)conn.Extra).property.getString("Server")
				,""+ ((CTN_Conn)conn.Extra).property.setDefaultInt("Port",6667)
			});
			String src = ((CTN_Conn)conn.Extra).property.setDefaultString("Server2","");
			int lnum=0;
			LINE: for(int i=0;i<src.length();++i){
				int start=i;
				i=src.indexOf('\n',start);
				if(i==-1)i=src.length();
				++lnum;
				String line =src.substring(start,i).trim();
				if(line.length()==0) continue;
				String[] hp = line.split( (-1!=line.indexOf(';')?";":":"),2);
				if(hp.length < 2 ){
					App.Log("サーバ指定2の"+line+"は host;port,port-port ... の形式にマッチしない(1)");
					continue;
				}
				String host = hp[0].trim();
				String[] ports= hp[1].split(",");
				Vector ports_tmp =new Vector();
				for(int j=0;j<ports.length;++j){
					String s = ports[j].trim();
					Matcher m=range_pattern.matcher(s);
					if(m.matches()){
						ports_tmp.add(m.group(1)+"-"+m.group(2));
						continue;
					}
					m=numeric_pattern.matcher(s);
					if(m.matches()){
						ports_tmp.add(m.group(1));
						continue;
					}
					App.Log("サーバ指定2のポート部の"+s+"は port または port-port の形式にマッチしない(2)");
					continue LINE;
				}
				if(ports_tmp.size()==0){
					App.Log("サーバ指定2の"+line+"にはポート番号が指定されていない");
					continue LINE;
				}
				String[] item = new String[ ports_tmp.size() +1];
				item[0]=host;
				for(int j=1;j<item.length;++j) item[j]=(String)ports_tmp.get(j-1);
				sv.servers.add(item);
			}
		}else{
			sv=(Servers)((CTN_Conn)conn.Extra).property.get("__Servers");
		}

		String[] item = (String[])sv.servers.get(connect_try_count%sv.servers.size());
		String host = item[0];
		String port = item[1+rand(item.length-1)];
		int d = port.indexOf('-');
		if(d!=-1){
			int first = Integer.parseInt(port.substring(0,d));
			int last  = Integer.parseInt(port.substring(d+1));
			if(first > last){ int tmp=last;last=first;first=tmp;}
			sv.ServerPort = first+ rand(first-last);
		}else{
			sv.ServerPort =Integer.parseInt(port);
		}
		return host;
	}

	public int    getSoTimeout(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultInt("SoTimeout",0);}

	public String getLocalHost(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultString("SourceHost","");}

	public int    getLocalPort(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultInt("SourcePort",0);}

	public String getNickName(IRCConnection conn,boolean isFirst)
		{ return ((CTN_Conn)conn.Extra).getNickName(isFirst);}

	public String getPassword(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.getString("Password");}

	public String getUserName(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.getString("UserName");}
	public String getRealName(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.getString("RealName");}

	public String getMyUserMode(IRCMessage m)
		{ return ((CTN_Conn)m.conn.Extra).property.setDefaultString("UserMode","");}

	public String getConnectionName(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).getName();}

	public static String system_property(String key){ return key+"="+System.getProperty(key)+" "; }
	public String getCTCPReplyVersion(IRCMessage m){
		return App.config_AppName
			+" http://tate.undef.jp/pub/BluntIRC/BluntIRC.html "
			+":build "+bdate.BuildDate.getVersion()+":"
			+system_property("java.runtime.name")
			+system_property("java.runtime.version")
			+system_property("os.arch")
			+system_property("os.name")
			+system_property("os.version")
			+system_property("sun.os.patch.level")
			+system_property("user.language")
			+system_property("sun.arch.data.model")
			;
	}
	public String getCTCPReplyFinger(IRCMessage m)
		{ return ((CTN_Conn)m.conn.Extra).property.setDefaultString("CTCPReplyFinger","設定なし");}

	public String getCTCPReplyUserInfo(IRCMessage m)
		{ return ((CTN_Conn)m.conn.Extra).property.setDefaultString("CTCPReplyUserInfo","設定なし");}

	public boolean isAutoReconnect(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("AutoReconnect",false);}

	public boolean isDumpRecvLine(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("dumpRecvLine",false);}

	public boolean isDumpRecvCTCP(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("dumpRecvCTCP",true);}

	public boolean isDontParseCTCP(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("DontParseCTCP",false);}
	public boolean isQuoteAllParam(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteAllParam",false);}
	public boolean isQuoteSpace(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteSpace",false);}
	public boolean isQuoteSpaceAtCTCPArg(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteSpaceAtCTCPArg",false);}
	public boolean isQuote001(IRCConnection conn)
		{ return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("Quote001",true);}

	public void onChannelKicked(IRCMessage m){
		CTN_Chan node = (CTN_Chan)((IRCChannel)m.target.get(0)).Extra;
		if( node.property.setDefaultBoolean("RejoinOnKicked",false) ){
			node.OnMenuJoin();
		}
	}

	public int getCTCPSendCueTimeExpire (IRCConnection c)
		{ return ((CTN_Conn)c.Extra).property.setDefaultInt("SendCueTimeExpire",60);}
	public int getCTCPSendCueLimitInTime(IRCConnection c)
		{ return ((CTN_Conn)c.Extra).property.setDefaultInt("CTCPSendCueLimitInTime",20);}
	public int getCTCPSendCueMaxInLine  (IRCConnection c)
		{ return ((CTN_Conn)c.Extra).property.setDefaultInt("CTCPSendCueMaxInLine",4);}

	public  void OnLogEvent(IRCMessage m){
		if(m.target.size()==0) m.addContext(m.conn);
		int t = m.target.size();
		// 関連するコンテキスト
		Object main_context=null;
		for(int i=0;i<t;++i){
			Object to = m.target.get(i);
			if(to instanceof IRCConnection){
				if(main_context==null) main_context = ((IRCConnection)to).Extra;
				OnLogEvent(m,to,IRCLogContext.LB_Conn,main_context);
				OnLogEvent(m,to,IRCLogContext.LF_Conn,main_context);
			}else if(to instanceof IRCChannel){
				IRCChannel chan=(IRCChannel)to;
				if(main_context==null) main_context = ((IRCChannel)to).Extra;
				if(chan.isChannel()){
					OnLogEvent(m,to,IRCLogContext.LB_Chan,main_context);
					OnLogEvent(m,to,IRCLogContext.LF_Chan,main_context);
				}else{
					OnLogEvent(m,to,IRCLogContext.LB_Priv,main_context);
					OnLogEvent(m,to,IRCLogContext.LF_Priv,main_context);
				}
			}
		}
		Object to=m.target.get(0);
		OnLogEvent(m,to,IRCLogContext.LB_Dump,main_context);
		OnLogEvent(m,to,IRCLogContext.LF_Dump,main_context);
		OnLogEvent(m,to,IRCLogContext.LB_All ,main_context);
	}


	public  void OnLogEvent(IRCMessage m,Object to,IRCLogContext buffer_id,Object main_context){
		// ログファイル出力の場合はファイル名を探す
		String fname=null;
		if(buffer_id.isLogFile()){
			if(logdir==null) return;
			PrintFormat pf = App.pfm_manager.findPrintFormat(buffer_id.toString(),"LogFileName");
			// todo: pf を変更するフック
			if(pf==null){
				App.Log("PrintFormat.conf の「"+buffer_id.toString()+"」にLogFileNameの指定がない");
				return;
			}
			fname = PrintFormatToTextSpan.getText(m,to,pf,false);
			if(fname==null) return;
		}

		// メッセージにあわせたPrintFormatを探す
		// todo PrintFormat を書き換えるフック
		PrintFormat pf = App.pfm_manager.findPrintFormat(buffer_id.toString(),m.cmd);
		if(pf==null && 0==m.cmd.indexOf("On"  ) ) pf = App.pfm_manager.findPrintFormat(buffer_id.toString(),"OnOther");
		if(pf==null && 0==m.cmd.indexOf("CTCP") ) pf = App.pfm_manager.findPrintFormat(buffer_id.toString(),"OtherCTCP");
		if(pf==null) pf= App.pfm_manager.findPrintFormat(buffer_id.toString(),"other");
		// todo: pf を変更するフック

		if(pf==null){
			pf = new PrintFormat();
			pf.macro.add("!");
			pf.macro.add(PrintFormatMacro.getNormalName (m.log_from));
			pf.macro.add(" ");
			pf.macro.add(m.cmd);
			pf.macro.add(" ");
			pf.macro.add(m.params_str);
		}
		if(!buffer_id.isLogFile()){
			// バッファに追加
			buffer.PackedLineWriter line = PrintFormatToTextSpan.getTextLine(m,to,pf,true,App.style_manager);
			// todo バッファ表示項目を書き換えるフック
			if(line==null) {/* nothing to do*/}
			else if(buffer_id==IRCLogContext.LB_All ){
				if(App.root_property.getBoolean("AllLog_ChocoaStingy",false)){
					ConnTreeNode node = App.getSelected();
					if(node!=null){
						if( (to instanceof IRCConnection)
						&&  (node instanceof CTN_Conn)
						&&  ((CTN_Conn)node).conn == to
						) return;

						if( (to instanceof IRCChannel)
						&&  (node instanceof CTN_Chan)
						&&  ((CTN_Chan)node).chan == to
						) return;

						if( (to instanceof IRCChannel)
						&&  (node instanceof CTN_Priv)
						&&  ((CTN_Priv)node).chan == to
						) return;
					}
				}
				App.getApp().log_all.doc.addText(App.main_window,line,main_context);
			}
			else if(buffer_id==IRCLogContext.LB_Dump) App.getApp().addMidoku(line,main_context);
			else if(buffer_id==IRCLogContext.LB_Conn) ((CTN_Conn)m.conn.Extra).addMidoku(line,main_context);
			else if(buffer_id==IRCLogContext.LB_Chan) ((CTN_Chan)((IRCChannel)to).Extra).addMidoku(line,pf.NoCountMidoku);
			else if(buffer_id==IRCLogContext.LB_Priv) ((CTN_Priv)((IRCChannel)to).Extra).addMidoku(line,pf.NoCountMidoku);
			return;
		}

		fname= Util.EscapeForFile(fname);
		String line = PrintFormatToTextSpan.getText(m,to,pf,true);
		if(line==null) return;
		// 記録する
		File f=logdir;
		try{
			// 指定した名前のディレクトリを作る
			f= new File(f,fname);
			if(!f.exists()) f.mkdirs();
			// その下に日付とエンコーディング名を指定したファイルをつくる
			f= new File(f,m.getDateStr()+"."+App.root_property.getString("LogFileEncoding")+".txt");
			ByteArrayOutputStream ba = new ByteArrayOutputStream();
			ba.write( line.getBytes(App.root_property.getString("LogFileEncoding")));
			if(App.root_property.getBoolean("LogCRLF",false)) ba.write((byte)'\r');
			ba.write((byte)'\n');
			App.delay_log.add(f,ba.toByteArray());
		}catch(Throwable e){
			App.Log(f.getAbsolutePath()+"への出力に失敗した"+e.toString());
			logdir=null;
		}
	}

	// 接続とチャンネルの状態変化
	public  void OnConnectRequest(IRCConnection conn){ 
		CTN_Conn connNode = (CTN_Conn)conn.Extra;
		App.redrawTreeView(connNode);
	}
	public  void OnConnectAuthorized(IRCMessage m){
		// do nothing 
		CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
		App.redrawTreeView(connNode);
	}
	public  void OnConnectMOTDEnd(IRCMessage m){
		CTN_Conn connNode = (CTN_Conn)m.conn.Extra;

		// ユーザモードの設定
		String mode = m.conn.getListener().getMyUserMode(m);
		if(mode!=null){
			LinkedList v=new LinkedList();
			v.add("MODE");
			v.add(m.conn.myself.getNickBytes() );
			v.add(mode);
			m.conn.SendToServer(v);
		}
		// チャンネルに自動joinするかどうか
		for(Iterator it =connNode.getChannelNodes().iterator();it.hasNext();){
			CTN_Chan node = (CTN_Chan)it.next();
			node.checkAutoJoin();
		}
	}

	public  void OnDisconnect(IRCConnection conn){
		CTN_Conn connNode = (CTN_Conn)conn.Extra;
		App.redrawTreeView(connNode);
	}

	public  void initIRCChannel(IRCConnection conn,IRCChannel chan){
		if(chan.Extra==null){
			chan.Extra = (chan.isChannel()
				?CTN_Chan.createByInitIRCChannel((CTN_Conn)conn.Extra,chan)
				:CTN_Priv.createByInitIRCChannel((CTN_Conn)conn.Extra,chan)
			);
		}
	}

	public  void RemoveChannel(IRCConnection conn,IRCChannel chan){
		CTN_Conn connNode = (CTN_Conn)conn.Extra;
		// たぶん呼ばれない
		App.logger.warning("CTN_Conn.RemoveChannel");
	}

	// ユーザ自身のチャンネルの出入り
	public  void ChangeChannelJoin(IRCConnection conn,IRCChannel c,boolean is_in){
		CTN_Conn connNode = (CTN_Conn)conn.Extra;
		initIRCChannel(conn,c);
		CTN_Chan node = (CTN_Chan)c.Extra;
		App.redrawTreeView(node);
		if(!is_in){
			if(c.isChannel()) c.setChannelModeString("-");
			// todo: 自分でpartしたんならautojoinを外したいかもな
			// しかしここでは partかquitかkickか切断かわからない
		}else{
			if(c.isChannel() ){
				if(node.property.getBoolean("AutoWho",true) ){
					LinkedList v=new LinkedList();
					v.add("WHO");
					v.add(c.getCName().getRawBytes());
					conn.SendToServer(v);
				}
				// モードを取得する
				if(node.property.getBoolean("AutoModeQuery",true) ){
					LinkedList v=new LinkedList();
					v.add("MODE");
					v.add(c.getCName().getRawBytes());
					conn.SendToServer(v);
				}
			}
		}
		// アイコンの再描画を要求する
		if(App.getSelected()==connNode) App.getApp().updateTopic();
		App.redrawTreeView(connNode);
	}
	public  void SetChannelMode(IRCMessage m,IRCChannel c){
		App.getApp().updateTopic();
	}
	public  void ChangeNickMyself (IRCMessage m){
		CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
		// トピックの再描画を要求する
		App.getApp().updateTopic();
	}

	// チャンネル内のユーザリストの変化
	public  void ChangeUserInfo
	(IRCConnection conn,IRCChannel c,byte[] fromNick,IRCChannelMember to)
	{
		// fromNickがnullだと追加
		initIRCChannel(conn,c);
		if(c.isChannel()){
			((CTN_Chan)c.Extra).userlist.ChangeUserInfo( fromNick,to);
		}else{
			// プリブ窓の名称変更
			App.updateBufferListItem(((CTN_Priv)c.Extra));
		}
	}
	public  void RemoveUserList(IRCConnection conn,IRCChannel c,IRCChannelMember who){
		initIRCChannel(conn,c);
		((CTN_Chan)c.Extra).userlist.RemoveUserList( who );
		if(App.getSelected()==c.Extra) App.getApp().updateTopic();
	}

	public  void OnWhoReply(IRCMessage m,IRCChannel c,IRCUser who){
		if(c!=null){
			// ユーザリストの再描画
			initIRCChannel(m.conn,c);
			((CTN_Chan)c.Extra).userlist.setWhoReply(who);
		}
	}
	public void onChangePrefix(IRCConnection conn,IRCUser who,int type){
		// 選択中のバッファにユーザがいるなら再描画が必要そうだ
		CTN_Chan node = App.getSelectedChannel();
		if(node!=null) node.userlist.setWhoReply(who);
		if(type>=2) App.Log(who.getPrefixStr()+" のprefixは今までと異なります "+type);
	}

	// チャンネルのトピック設定
	public  void ChangeTopic(IRCMessage m,IRCChannel c){
		if(App.getSelectedChannel()==c.Extra) App.getApp().updateTopic();
	}
	//CTCP PING 対応
	public void checkCTCPPingReply(IRCMessage ctcp){
		try{
			long old_time=Long.parseLong(ctcp.log_msg,10);
			long now = ctcp.time.getTime().getTime();
			long diff = now-old_time;
			if(diff>=0){
				String low= Long.toString((diff%1000)+1000);
				String s = Long.toString(diff/1000)+"."+low.substring(low.length()-3);
				ctcp.log_msg= ctcp.from.getShortName()+" のラグタイムは "+s+" 秒です。";
			}
		}catch(NumberFormatException e){
		}
	}


	public void invokeLater(int second,Runnable method){App.addDelayProc(second,method);}
}
