package buffer;
import gui.*;

// 選択位置にある区間の情報
public class TextSpanInfo{
	public BufferTextBlock block;
	public int line;
	public int span_index;
	public int span_offset; //区間の中でクリックされた文字の位置
	public FontInfo2 base_style; // 上書きされた装飾は含まない
	public String text;
	public Object main_context;

	public TextSpanInfo(
		BufferTextBlock block
		,int line
		,int span_index
		,int span_offset
		,StyleID sid
	){
		this.block = block;
		this.line  = line;
		this.span_index=span_index;
		this.span_offset=span_offset;
		this.main_context = (block.extra==null?null:block.extra[line]);

		PackedLineReader tsi = new PackedLineReader(block,line,sid,"base");
		// indexが0でも1回はreadSpanを読む
		for(int i=-1;i<span_index;++i) tsi.readSpan();
		text          = tsi.getSpanText();
		base_style = sid.getBaseStyle(tsi.baseid);
	}
}
