/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.processor;

import jp.bitmeister.asn1.type.ASN1Type;

/**
 * Interface for classes which apply some process to ASN.1 data.
 * 
 * <p>
 * This interface provides the common method for making processors which apply
 * some process to ASN.1 data. A class that implements this interface is a
 * processor that receives an ASN.1 data and returns an instance of {@code T} as
 * the result. {@code E} indicates an exception that may be thrown while the
 * process.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
public interface ASN1Processor<T, E extends Throwable> {

	/**
	 * Processing method.
	 * 
	 * @param data
	 *            The ASN.1 data.
	 * @return The result of this process.
	 * @throws E
	 *             Thrown when an error occurred while the process.
	 */
	public T process(ASN1Type data) throws E;

}
