/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.SEQUENCE_OF;
import jp.bitmeister.asn1.type.builtin.SET_OF;

/**
 * A class implements this interface indicates that the type has size that can
 * be mearuserd.
 * 
 * <p>
 * If a class implements this interface, it means that the ASN.1 type has size.
 * {@code BIT_STRING}, {@code OCTET_STRING}, {@code SEQUENCE_OF}, {@code SET_OF}
 * and sub classes of {@code StringType} implements this interface.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see BIT_STRING
 * @see OCTET_STRING
 * @see SEQUENCE_OF
 * @see SET_OF
 * @see StringType
 */
public interface SizeCountable {

	/**
	 * Returns the measured size of this instance.
	 * 
	 * @return The size.
	 */
	public int size();

}
