/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type.useful;

import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;

/**
 * Represents ASN.1 'CHARACTER STRING' type.
 * 
 * <p>
 * An instance of this class represents a 'CHARACTER STRING' type data.
 * 'CHARACTER STRING' type is defined as implicit tagged 'EMBEDDED PDV' type.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@ASN1BuiltIn
@ASN1Identifier("CHARACTER STRING")
@ASN1Tag(tagClass = ASN1TagClass.UNIVERSAL, value = 29, tagMode = ASN1TagMode.IMPLICIT)
public class CHARACTER_STRING extends EMBEDDED_PDV {

	public CHARACTER_STRING() {
		super();
	}

	public CHARACTER_STRING(Identification identification,
			OCTET_STRING data_value) {
		super(identification, data_value);
	}

}
