/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.codec.ber;

import java.io.IOException;
import java.io.OutputStream;

import jp.bitmeister.asn1.type.ASN1TagClass;

/**
 * Interface for encoded octets.
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
interface EncodedOctets {

	/**
	 * Sets identifier and length octets to fix this octets.
	 * 
	 * @param tagClass
	 *            The ASN.1 tag class for this data.
	 * @param tagNumber
	 *            The tag number for this data.
	 */
	public void fix(ASN1TagClass tagClass, int tagNumber);

	/**
	 * Writes all encoded octets to the {@code OutputStream}
	 * 
	 * @param out
	 *            The stream to be written.
	 * @throws IOException
	 *             when {@code IOException} thrown by {@code OutputStream}.
	 */
	public int write(OutputStream out) throws IOException;

	/**
	 * Returns encoded octets length includes prefix and contents.
	 * 
	 * @return Total length of BER encoded octets.
	 */
	public int totalLength();

	/**
	 * Returns this instance is constructed or not.
	 * 
	 * @return {@code true} if this instance is constructed.
	 */
	public boolean isConstructed();

	/**
	 * Returns length of contents octets.
	 * 
	 * @return contents octets length.
	 */
	public int contentsLength();

}

/**
 * Interface for constructed encoded octets.
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
interface ConstructedOctets extends EncodedOctets {

	/**
	 * Appends an element to this octets.
	 * 
	 * @param element
	 *            The element to be added.
	 */
	public void addElement(EncodedOctets element);

}
