/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.sample;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import jp.bitmeister.asn1.codec.ber.BerDecoder;
import jp.bitmeister.asn1.codec.ber.BerEncoder;
import jp.bitmeister.asn1.codec.ber.DerEncoder;
import jp.bitmeister.asn1.exception.ASN1DecodingException;
import jp.bitmeister.asn1.exception.ASN1EncodingException;
import jp.bitmeister.asn1.sample.FrightStatusTypes.Airport;
import jp.bitmeister.asn1.sample.FrightStatusTypes.FrightNumber;
import jp.bitmeister.asn1.sample.FrightStatusTypes.Information;
import jp.bitmeister.asn1.sample.FrightStatusTypes.Status;
import jp.bitmeister.asn1.type.ASN1Modules;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.useful.UTCTime;

public class FrightStatusMain {
	
	public static void main(String[] args) {
		
		ASN1Modules.using(new FrightStatusTypes());
		
		FrightStatus ontime = new FrightStatus(
				new FrightNumber("JP041"),
				new Information(
						new Airport(Airport.tokyo),
						new UTCTime("110627073000"),
						new UTCTime("110627073000")
						),
				new Information(
						new Airport(Airport.osaka),
						new UTCTime("110627090000"),
						null
						)
				);
		
		derEncAndDec(ontime);

		FrightStatus delay = new FrightStatus(
				new FrightNumber("NI022"),
				new Information(
						new Airport(Airport.fukuoka),
						new UTCTime("110627080000"),
						new UTCTime("110627081000")
						),
				new Information(
						new Airport(Airport.nagoya),
						new UTCTime("110627093000"),
						null
						),
				new Status(ASN1TagClass.CONTEXT_SPECIFIC, 1, new INTEGER(10))
				);
		
		derEncAndDec(delay);

	}
	
	static void derEncAndDec(ASN1Type data) {
		
		System.out.println(data);
		ByteArrayOutputStream bo = new ByteArrayOutputStream();
		BerEncoder enc = new DerEncoder(bo);
		try {
			enc.encode(data);
		}
		catch (ASN1EncodingException e) {
			e.printStackTrace();
		}
		
		System.out.println(new OCTET_STRING(bo.toByteArray()));
		
		ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
		BerDecoder dec = new BerDecoder(bi);
		try {
			ASN1Type result = dec.decode();
			System.out.println(result);
		}
		catch (ASN1DecodingException e) {
			e.printStackTrace();
		}
		
	}
	
}

