package jp.bitmeister.asn1.sample;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import jp.bitmeister.asn1.codec.ber.BerDecoder;
import jp.bitmeister.asn1.codec.ber.DerEncoder;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.BOOLEAN;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.OBJECT_IDENTIFIER;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.REAL;
import jp.bitmeister.asn1.type.useful.GeneralizedTime;
import jp.bitmeister.asn1.type.useful.PrintableString;
import jp.bitmeister.asn1.value.BinString;
import jp.bitmeister.asn1.value.HexString;

public class Main {

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		encAndDec(new BOOLEAN(true));
		encAndDec(new INTEGER(12345));
		encAndDec(new BIT_STRING(1,3,8,12));
		encAndDec(new OCTET_STRING(new HexString("0102030405060708090A0B0C0D0E0F")));
		encAndDec(new REAL(123.4567));
		encAndDec(new OBJECT_IDENTIFIER(1, 2, 3, 1221, 443));
		encAndDec(new NULL());
		encAndDec(new GeneralizedTime("20110707150000.123"));
		encAndDec(new PrintableString("abcdeABCDE"));
		
		BIT_STRING b = new BIT_STRING();
		b.contract();
		b.clear();
		b.set(new BinString("011101101110110"));
		System.out.println(b);
		b.unset(20);
		System.out.println(b);
		b.contract();
		System.out.println(b);
		
	}
	
	static void encAndDec(ASN1Type data) {
		
		ByteArrayOutputStream bo = new ByteArrayOutputStream();
		DerEncoder de = new DerEncoder(bo);
		try {
			System.out.println(data);
			de.encode(data);
		} catch (Exception e) {
			e.printStackTrace();
		}
		ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
		BerDecoder bd = new BerDecoder(bi);
		try {
			ASN1Type result = bd.decode();
			System.out.println(result);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
