/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type;

/**
 * The base type for structured types.
 * 
 * <p>
 * This class provides generic interfaces for classes that represents structured
 * types. This class is the parent class of {@code ConstructiveType} and
 * {@code SelectiveType}.
 * </p>
 * 
 * @see ConstructiveType
 * @see SelectiveType
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
public abstract class StructuredType extends ASN1Type {

	/**
	 * Generates tags for elements automatically with automatic tagging rule.
	 * 
	 * @param array
	 *            The elements to be tagged.
	 */
	static void generateAutomaticTags(NamedTypeSpecification[] array) {
		for (NamedTypeSpecification e: array) {
			if (e.tag() != null) {
				return;
			}
		}
		for (int i = 0; i < array.length; i++) {
			array[i].generateAutomaticTag(i);
		}
	}

	/**
	 * Sets the ASN.1 data to the element specified by the
	 * {@code NamedTypeSpecification} of this instance.
	 * 
	 * @param namedType
	 *            Indicates the element that the data to be assigned.
	 * @param component
	 *            The data to be assigned.
	 */
	public abstract void set(NamedTypeSpecification namedType,
			ASN1Type component);

	/**
	 * Sets the ASN.1 data to the element specified by the identifier of this
	 * instance.
	 * 
	 * @param elementName
	 *            The identifier of element.
	 * @param component
	 *            The ASN.1 data to be assigned
	 */
	public abstract void set(String elementName, ASN1Type component);

	/**
	 * Gets the ASN.1 data from the element specified by the identifier of this
	 * instance.
	 * 
	 * @param elementName
	 *            The identifier of element.
	 * @return The ASN.1 data of the element.
	 */
	public abstract ASN1Type get(String elementName);

}
