/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.type.useful;

import java.nio.charset.Charset;
import java.util.regex.Pattern;

import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.StringType;

/**
 * Represents ASN.1 'UTF8String' type.
 * 
 * <p>
 * An instance of this class represents a 'UTF8String' type data. Characters
 * which can appear in the {@code UTF8String} are all UTF-8 characters.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
@ASN1BuiltIn
@ASN1Tag(tagClass = ASN1TagClass.UNIVERSAL, value = 12, tagMode = ASN1TagMode.IMPLICIT)
public class UTF8String extends StringType {

	/**
	 * Instantiates an empty {@code UTF8String}.
	 */
	public UTF8String() {
	}

	/**
	 * Instantiates a {@code UTF8String} and initialize it with the
	 * {@code String} value.
	 * 
	 * @param value
	 *            The value assigned to the instance.
	 */
	public UTF8String(String value) {
		set(value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.bitmeister.asn1.type.StringType#charset()
	 */
	@Override
	public Charset charset() {
		return Charset.forName("UTF-8");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.bitmeister.asn1.type.StringType#pattern()
	 */
	@Override
	protected Pattern pattern() {
		return null;
	}

}
