/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1Type;

/**
 * Indicates ASN.1 types which are included in this module.
 * 
 * <p>
 * {@code ASN1DefinedTypes} annotation indicates ASN.1 types which are included
 * in this module but defined at outside of the ASN.1 module class. ASN.1 types
 * defined as static public member classes of an ASN.1 module class will be
 * registered to the module automatically.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 * 
 * @see ASN1Module
 * @see ASN1Type
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ASN1DefinedTypes {

	/**
	 * Indicates ASN.1 type classes defined at outside of the module class.
	 * 
	 * @return An array of {@code Class} object of {@code ASN1Type}.
	 */
	public Class<? extends ASN1Type>[] value();

}
