/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.bookshelf2;

import java.util.Comparator;
import org.tonouchi.bookshelf2.Book;
import org.tonouchi.bookshelf2.BookSortKeyEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookComparator
implements Comparator<Book> {
    private BookSortKeyEnum key = null;

    public BookComparator(BookSortKeyEnum key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.key = key;
    }

    @Override
    public int compare(Book o1, Book o2) {
        switch (this.key) {
            case AUTHOR: {
                return o1.getAuthor().compareTo(o2.getAuthor());
            }
            case CATEGORY: {
                return o1.getCategory().compareTo(o2.getCategory());
            }
            case PAGENUM: {
                return new Integer(o1.getPageNum()).compareTo(new Integer(o2.getPageNum()));
            }
            case RATE: {
                return new Integer(o1.getRate()).compareTo(new Integer(o2.getRate()));
            }
        }
        return o1.getTitle().compareTo(o2.getTitle());
    }
}

