/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.bookshelf2;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tonouchi.bookshelf2.Book;
import org.tonouchi.bookshelf2.BookDataHolderHolder;
import org.tonouchi.bookshelf2.BookShelfConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BookShelfLibrary {
    private static String fileName = BookShelfConfig.getBaseDirectory() + "bookshelf.xml";

    public static void read() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileName);
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("books")) continue;
                BookShelfLibrary.booksToList(node);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void booksToList(Node node) {
        NodeList books = node.getChildNodes();
        for (int i = 0; i < books.getLength(); ++i) {
            Node book = books.item(i);
            if (!book.getNodeName().equals("book")) continue;
            Book bookEntity = BookShelfLibrary.bookToInstance(book);
            bookEntity.setId(book.getAttributes().getNamedItem("id").getTextContent());
            BookDataHolderHolder.getBookDataHolder().addBook(bookEntity);
        }
    }

    private static Book bookToInstance(Node node) {
        Book book = new Book();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node bookProperties = nodeList.item(i);
            if (bookProperties.getNodeName().equals("author")) {
                book.setAuthor(bookProperties.getTextContent());
                continue;
            }
            if (bookProperties.getNodeName().equals("category")) {
                book.setCategory(bookProperties.getTextContent());
                continue;
            }
            if (bookProperties.getNodeName().equals("outline")) {
                book.setComment(bookProperties.getTextContent());
                continue;
            }
            if (bookProperties.getNodeName().equals("rate")) {
                book.setRate(Integer.parseInt(bookProperties.getTextContent()));
                continue;
            }
            if (bookProperties.getNodeName().equals("tags")) {
                ArrayList<String> tags = new ArrayList<String>();
                NodeList tagList = bookProperties.getChildNodes();
                for (int j = 0; j < tagList.getLength(); ++j) {
                    Node tag = tagList.item(j);
                    if (!tag.getNodeName().equals("tag")) continue;
                    tags.add(tag.getTextContent());
                }
                book.setTags(tags);
                continue;
            }
            if (bookProperties.getNodeName().equals("title")) {
                book.setTitle(bookProperties.getTextContent());
                continue;
            }
            if (bookProperties.getNodeName().equals("file-path")) {
                book.setFilePath(bookProperties.getTextContent());
                continue;
            }
            if (!bookProperties.getNodeName().equals("page")) continue;
            book.setPageNum(Integer.parseInt(bookProperties.getTextContent()));
        }
        return book;
    }

    public static void write() {
        try {
            List<Book> books = BookDataHolderHolder.getBookDataHolder().getBookList();
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element booksNode = document.createElement("books");
            for (Book book : books) {
                booksNode.appendChild(BookShelfLibrary.toBookNode(document, book, true));
            }
            document.appendChild(booksNode);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(fileName));
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Element toBookNode(Document document, Book book, boolean filepathincludes) {
        Element bookNode = document.createElement("book");
        Element authorNode = document.createElement("author");
        Element categoryNode = document.createElement("category");
        Element outlineNode = document.createElement("outline");
        Element rateNode = document.createElement("rate");
        Element tagsNode = document.createElement("tags");
        Element titleNode = document.createElement("title");
        Element pageNode = document.createElement("page");
        bookNode.setAttribute("id", book.getId());
        bookNode.appendChild(authorNode);
        bookNode.appendChild(categoryNode);
        bookNode.appendChild(outlineNode);
        bookNode.appendChild(rateNode);
        bookNode.appendChild(titleNode);
        bookNode.appendChild(tagsNode);
        bookNode.appendChild(pageNode);
        List<String> tags = book.getTags();
        for (String tag : tags) {
            Element tagNode = document.createElement("tag");
            tagNode.setTextContent(tag);
            tagsNode.appendChild(tagNode);
        }
        authorNode.setTextContent(book.getAuthor());
        categoryNode.setTextContent(book.getCategory());
        outlineNode.setTextContent(book.getComment());
        rateNode.setTextContent(Integer.toString(book.getRate()));
        titleNode.setTextContent(book.getTitle());
        pageNode.setTextContent(Integer.toString(book.getPageNum()));
        if (filepathincludes) {
            Element filePathNode = document.createElement("file-path");
            bookNode.appendChild(filePathNode);
            filePathNode.setTextContent(book.getFilePath());
        }
        return bookNode;
    }
}

