/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.bookshelf2;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.table.DefaultTableModel;
import org.tonouchi.bookshelf2.Book;
import org.tonouchi.bookshelf2.BookDataHolder;
import org.tonouchi.bookshelf2.BookDataHolderHolder;

public class BookTableModel
extends DefaultTableModel {
    private static BookDataHolder holder = BookDataHolderHolder.getBookDataHolder();
    private static final String[] columnNames = new String[]{"\u30ab\u30c6\u30b4\u30ea\u30fc", "\u4f5c\u8005", "\u984c\u540d", "\u30da\u30fc\u30b8\u6570", "\u30ec\u30fc\u30c8", "\u30bf\u30b0", "\u30b3\u30e1\u30f3\u30c8"};

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public int getRowCount() {
        return holder.getDataCount();
    }

    public Object getValueAt(int row, int column) {
        Book book = holder.getBook(row);
        switch (column) {
            case 0: {
                return book.getCategory();
            }
            case 1: {
                return book.getAuthor();
            }
            case 2: {
                return book.getTitle();
            }
            case 3: {
                return book.getPageNum();
            }
            case 4: {
                return book.getRate();
            }
            case 5: {
                List<String> tagList = book.getTags();
                if (tagList.isEmpty()) {
                    return "";
                }
                StringBuffer buf = new StringBuffer(tagList.get(0));
                for (int i = 1; i < tagList.size(); ++i) {
                    buf = buf.append(' ').append(tagList.get(i));
                }
                return buf.toString();
            }
            case 6: {
                return book.getComment();
            }
        }
        return super.getValueAt(row, column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        Book book = holder.getBook(row);
        switch (column) {
            case 0: {
                book.setCategory(aValue.toString());
                break;
            }
            case 1: {
                book.setAuthor(aValue.toString());
                break;
            }
            case 2: {
                book.setTitle(aValue.toString());
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                try {
                    int newValue = Integer.parseInt(aValue.toString());
                    if (newValue <= 1) {
                        newValue = 1;
                    } else if (newValue >= 5) {
                        newValue = 5;
                    }
                    book.setRate(newValue);
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 5: {
                System.out.println("TAG\u66f4\u65b0");
                String tags = aValue.toString();
                StringTokenizer tkn = new StringTokenizer(tags, " ");
                ArrayList<String> newTags = new ArrayList<String>();
                while (tkn.hasMoreTokens()) {
                    newTags.add(tkn.nextToken());
                }
                book.setTags(newTags);
                break;
            }
            case 6: {
                System.out.println("\u30b3\u30e1\u30f3\u30c8\u66f4\u65b0");
                book.setComment(aValue.toString());
            }
        }
    }
}

