#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

# path/binary setting
set -eu

pdir=`pwd`	#parent, callsrc dir
cd `dirname $0`
edir=`pwd`

cd "$edir"
PATH="`pwd`:$PATH"
eval "$(shunit_m)"
echo "--- run binary test: $pdir/$0
...">/dev/stderr

{
#init
cd "$edir"
rm -f main.lua

# start test
echo "-kicktest" >/dev/stderr
./bootlj
_fail

echo "print('main_lua_call')" >main.lua
./bootlj
_suc

# PATH test
bootlj
_suc

cd ..
bootlj
_suc
cd "$edir"

# bootlj add glvar test
for s in  package.path package.cpath; do
	echo "print($s)" >"main.lua"
	cd ..
	buf=`bootlj`
	cd "$edir"
	_suc
	_neq "${buf#`pwd`}" "$buf"
	# add fileexist dir to luapath
done
cd "$edir"

for s in FULL_BOOTDIR  FULL_CWD  DIRSEP  BASE_BOOTFILE  FULL_BOOTFILE; do
	echo "print($s)" >main.lua
	buf=`bootlj`
	_suc
	_neq "$buf" ""
done

} 3>&1 >buf.log 2>&1 || (tail buf.log;echo "--- test FAILED"; exit 1) >/dev/stderr
echo "--- success for all tests" >/dev/stderr
_res
