/* Copyright (C) 2021 Momi-g

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
/*SH_doc
title=bootlj section=1 repnl=\040
@name	bootlj
@_brief	portable luajit script bootloader
@_syno
	bootlj [-J passopt... -J] [args...]
@tl;dr
	@(code)
	- dir1 -+- bootlj
	        +- main.lua	( require("myutil") )
	        +- myutil.lua
	---
	dir1 $ ./bootlj -h	#>> luajit -- main.lua -h
	dir1 $ cd ..
	     $ ./dir1/bootlj	#>> run ./dir1/main.lua
	     $ cd dir1
	dir1 $ rm main.lua
	dir1 $ ./bootlj	#>> main.lua not found
	
	(make symbolic link to dir1/bootlj at /usr/bin etc)
	
	home $ bootlj	#>> run main.lua
	@()
@_opt
	@(list_o)
	-J passopt... -J:	pass opt to luajit vm. ~$ luajit '_passopt...'
	@()
@_desc
	bootlj is a wrapper of luajit runner with the following	features:
	@(code)--@
	- exec `main.lua` in the same directory
	- add the bootlj exist dirpath to package.path and cpath
	- add useful global vars
	  * FULL_BOOTFILE	(fullpath filename, /home/abc/bootlj etc)
	  * BASE_BOOTFILE	(filename: bootlj etc, no dirpath)
	  * FULL_BOOTDIR	(fullpath dirname, c:\home\dir etc.)
	  * FULL_CWD	(fullpath cwd, /home/now etc)
	  * DIRSEP		(directory sepstr, win==\, other==/ etc)
	@()--
	
	this feature makes your app package portable, directory == app.
	lua and luajit path/cpath dont have bootfile exist dirpath so causes
	the path search problem. bootlj resolves it.
	@(code)
	- dir1 -+- src.lua ( require("myutil") )
	        +- myutil.lua
	
	dir1$ luajit src.lua	#>> work
	dir1$ cd ../
	    $ luajit ./dir1/src.lua	#>> misses myutil.lua
	@()--
	
	the best practice for making your luajit code portable is:
	@(list)
	-: use require("foo") for import foo.lua. loaded from the appdir or other path
	-: use package.searchpath("myutil", package.cpath) and ffi.load(rtnstr)
		to load libmyutil.so etc.
	-: use ffi.load("directX") to load major library, libdirextX.so etc
	-: use ffi.C.printf() if use standard C-lib funcs
	-: place every related files(*.lua *.so *.dll) in a non-nested one directory.
		@(code)@
		dir1-+- bootlj
		     +- main.lua
		     +- main_impl.lua
		     +- foo.lua
		     +- tool.lua
		     +- libmyutil.so
		     +- xyz.dll
		@()
	@()--

	bootlj holds whole the orig-luajit vm. the below works almost the same.
		@(code)
	~$ ./bootlj -h
	~$ luajit -- main.lua -h
		@()--
	
	luajit vm accepts commandline options.(https://luajit.org/running.html)
	if you want to run luajit with its options, put between optsep str.
	default optsep is "-J".
		@(code) 
	~$ ./bootlj -J -Ohotloop=10 -joff -J -h
	~$ luajit -Ohotloop=10 -joff -- main.lua -h
		@()--
	
	you can change bootfile name `main.lua` and optsep `-J` using libbootlj.a.
	see bootlj.h
		@(code)--
	//basic
	#include "bootlj.h"
	int main(int argc, char** argv){
	  return bootlj_main(argc, argv);
	}
	//~$ cc -Wall -pedantic -static -fPIC src.c libbootlj.a -ldl -lm
	//~$ ./a.out -J -Ohotloop=10 -J -h 

	#include "bootlj.h"
	int main(int argc, char** argv){
	  return bootlj_main(argc, argv, "xyz.txt", "123");
	}
	//~$ cc src.c libbootlj.a -ldl -lm
	//~$ ./a.out 123 -Ohotloop=10 123 -h	#>> search xyz.txt and run
		@()
@return_value
	exit code depends on main.lua script and follows lua@'s method.
	@(code)@
	- rtn 1 if lj rtns nil/false/err at ag1. (lj)return nil >> $?=1
	- rtn int if lj return num at ag1. (lj)return 8.2 >> $?=8
	- rtn 1 if lj return other type at ag1. (lj)return "msg" >> $?=1
	- emsg to stderr if err or str at ag2. (lj)return 0,"hw" >> $?=0 +'hw'
	@()--
	
@notes
	---concept
	@(code)@
	- make luacode/binary/library portable
	- support to the powerful api, require()/ffi.load()
	- files in the same directory *SHOULD* be searched/loaded
	@()

@conforming_to posix-2001+
@copyright Copyright 2020 momi-g, GPLv3+
@_ver 2021-08-21
@_see 
	@(code)@
	https://luajit.org/index.html
	https://www.lua.org/manual/5.1/manual.html
	@()--
	luajit bases lua 5.1(+appropriate extented) syntax. avoid 5.2/5.3/5.4.
	orig-lua frequently changes syntax that ignores backwards compatibility like
	python2 >> 3, win7 >> 10, perl5 >> 6 etc. i recommend you to use luajit
	instead of orig-lua.
//SH_docE*/
