;
; rcsID=$Id: Definitions.lisp,v 1.17 2008/04/29 16:25:15 tmatsugaki Exp $
;
(proclaim '(optimize speed))
#|
(defmacro defstring (name val)
  (if (symbolp name)
    nil
    (let ((special (gensym)))
      `(progn
         (define-symbol-macro ,name ,special)
         (defvar ,name ,val)))))

(defmacro defstring (name val)
  (if (symbolp name)
    nil
   `(progn
       (defconstant ,name ,val))))
|#

(defmacro defstring (name val)
  `(progn
     (defconstant ,name ,val)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 定数の宣言
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defconstant _ECMA-48-0-RESET_                    0)  ;0	すべての属性をデフォルトにリセットする。
(defconstant _ECMA-48-1-BOLD_                     1)  ;1	ボールド(bold)をセット。
(defconstant _ECMA-48-2-HALF-BRIGHT_              2)  ;2	ハーフブライト(half-bright)(カラーディスプレイでは色で代用)をセット。
(defconstant _ECMA-48-4-UNDERSCORE_               4)  ;4	下線(underscore)をセット(カラーディスプレイでは色で代用)。 (ディムや下線を代用するのに使われる色は ESC ] ... によりセット)
(defconstant _ECMA-48-5-BLINK_                    5)  ;5	点滅(blink)をセット。
(defconstant _ECMA-48-7-REVERSE_                  7)  ;7	反転表示(reverce video)をセット。
(defconstant _ECMA-48-10-NULL-MAP0_               10) ;10	選択したマッピング、ディスプレイコントロールフラグ(display control flag)、トグルメタフラグ(toggle meta flag)をリセットする (ECMA-48では"primary font"と呼んでいる)。
(defconstant _ECMA-48-11-NULL-MAP1_               11) ;11	ヌルマッピングを選択、ディスプレイコントロールフラグをセット、 トグルメタフラグをリセットする (ECMA-48 では"first alternate font"と呼んでいる)。
(defconstant _ECMA-48-12-NULL-MAP2_               12) ;12	ヌルマッピングを選択、ディスプレイコントロールフラグ、 トグルメタフラグをセットする (ECMA-48 では "second alternate font" と呼んでいる)。 トグルメタフラグがたっていると、 マッピングテーブルによる変換をする前に、バイトの上位の1ビットが トグルされる。
(defconstant _ECMA-48-21-NORMAL-BRIGHT0_          21) ;21	通常の輝度にセット(ECMA-48 では "doubly underlined" と呼んでいる)。
(defconstant _ECMA-48-22-NORMAL-BRIGHT1_          22) ;22	通常の輝度にセット。
(defconstant _ECMA-48-24-UNDERLINE-OFF_           24) ;24	下線オフ。
(defconstant _ECMA-48-25-BLINK-OFF_               25) ;25	点滅オフ。
(defconstant _ECMA-48-27-REVERSE-OFF_             27) ;27	反転表示オフ。
(defconstant _ECMA-48-30-FORE-BLACK_              30) ;30	フォアグラウンド(foreground)を黒にセット。
(defconstant _ECMA-48-31-FORE-RED_                31) ;31	フォアグラウンドを赤にセット。
(defconstant _ECMA-48-32-FORE-GREEN_              32) ;32	フォアグラウンドを緑にセット。
(defconstant _ECMA-48-33-FORE-BROWN_              33) ;33	フォアグラウンドを茶にセット。
(defconstant _ECMA-48-34-FORE-BLUE_               34) ;34	フォアグラウンドを青にセット。
(defconstant _ECMA-48-35-FORE-MAGENTA_            35) ;35	フォアグラウンドをマゼンダにセット。
(defconstant _ECMA-48-36-FORE-CYAN_               36) ;36	フォアグラウンドをシアンにセット。
(defconstant _ECMA-48-37-FORE-WHITE_              37) ;37	フォアグラウンドを白にセット。
(defconstant _ECMA-48-38-UNDERLINE-FORE-DFLT_     38) ;38	下線表示に設定し、フォアグラウンドをデフォルトにセット。
(defconstant _ECMA-48-39-UNDERLINE-OFF-FORE-DFLT_ 39) ;39	下線表示を解除し、フォアグラウンドをデフォルトにセット。
(defconstant _ECMA-48-40-BACK-BLACK_              40) ;40	バックグラウンド(background)を黒にセット。
(defconstant _ECMA-48-41-BACK-RED_                41) ;41	バックグラウンドを赤にセット。
(defconstant _ECMA-48-42-BACK-GREEN_              42) ;42	バックグラウンドを緑にセット。
(defconstant _ECMA-48-43-BACK-BROWN_              43) ;43	バックグラウンドを茶にセット。
(defconstant _ECMA-48-44-BACK-BLUE_               44) ;44	バックグラウンドを青にセット。
(defconstant _ECMA-48-45-BACK-MAGENTA_            45) ;45	バックグラウンドをマゼンダにセット。
(defconstant _ECMA-48-46-BACK-CYAN_               46) ;46	バックグラウンドをシアンにセット。
(defconstant _ECMA-48-47-BACK-WHITE_              47) ;47	バックグラウンドを白にセット。
(defconstant _ECMA-48-49-BACK-DFLT_               49) ;49	バックグラウンドをデフォルトにセット。

; デバッグ用マスク
(defconstant _dbgHeaderMask_  #b00000001)
(defconstant _dbgContentMask_ #b00000010)

(defconstant _commentMark_ ";;")
(defconstant _fieldSeparator_ "::")

(defstring _NewLine_ "^^^")  ; ハイフネーション時の改行を表す内部的な改行のマーク
(defconstant _genG2Dic_ t)     ; 英語グレード２の辞書エクストラクトファイル作成の要否

(defstring _keyNA_ "N/A")
(defstring _keyNone_ "none")
(defstring _keyNoBraille_ "There's no braille.")
(defstring _keyConvErr_ "An error occures while converting.")
(defstring _keyPartOfNotExist_ "does not exist")
(defstring _keyPartOfNotApplied_ "may not be applied")
(defstring _keyPOS_ " pos: ")

(defconstant _bseRowBytes_ 32)       ; デフォルトの BSE ファイルの一行あたりの文字数
(defconstant _bsePageLines_ 22)      ; デフォルトの BSE ファイルの一頁あたりの行数

(defconstant _idxWordNumber_ 0)      ; シーケンス番号のワードリストでのインデクス
(defconstant _idxMode_ 1)            ; 言語モードのワードリストでのインデクス
(defconstant _idxGrade_ 2)           ; グレードのワードリストでのインデクス
(defconstant _idxText_ 3)            ; 墨字のワードリストでのインデクス
(defconstant _idxBraille_ 4)         ; 点字のワードリストでのインデクス
(defconstant _idxLeaderList_ 5)      ; リーダーリストのワードリストでのインデクス

; ご参考
(defstring _emDash_ "—")           ; EMダッシュ
(defstring _enDash_ "–")           ; ENダッシュ
(defstring _minusSign_ "−")        ; マイナスサイン
(defstring _horizontalBar_ "―")   ; ホリゾンタルバー
(defstring _hyphen_ "-")           ; ハイフンマイナス(半角)
(defstring _chouon_ "ー")          ; 普通の横棒

; 点字の定数
(defstring _dot_brl_ "4")          ; "." の点字コード
(defstring _dollar_brl_ "4#")      ; "$" の点字コード？ (monbas.brf にて検出)
                                     ; $ を表示して、数値モードに遷移させる。
(defstring _backQuote_brl_ ",8")   ; "`" の点字コード

; 64 のベキ乗の演算を省略するための定数表リスト
(defconstant _power_of_64_ '(1 64 4096 262144 16777216 1073741824 68719476736 4398046511104 281474976710656)) ; 

; 英語グレード２辞書データ用定数
;(defconstant _inhibit_brl_list_ '("#" ";" "8" "0" "," "_" "+" ":" "1" "4" "&" "=" "(" ")" "6" "2")) ; 動的な辞書登録時に含まれていないことが望ましい点字コードのリスト
; 動的な辞書登録時に含まれてはいけない点字コードのリスト
(defconstant _inhibit_include_brl_list_  '(
                                   "#" ; Numeral Sign
                                   ";" ; Foreign Language Sign
                                   "2" ; 墨字の ";"    辞書登録用ワード生成で ";" に縮退してしまう。
                                   "," ; Capital Sign
                                   "1" ; 墨字の ","    辞書登録用ワード生成で "," に縮退してしまう。
                                   "4" ; 墨字の "."    辞書登録用ワード生成で "." に縮退してしまう。
                                   "6" ; 墨字の "!"    辞書登録用ワード生成で "!" に縮退してしまう。
                                   "8" ; 墨字の "?"    辞書登録用ワード生成で "?" に縮退してしまう。
                                  )
)
; 動的な辞書登録時に冒頭に含まれてはいけない点字コードのリスト
(defconstant _inhibit_leading_brl_list_  '(
                                   "&"  ; 墨字の "and"  が冒頭だと後続のワードと結合するので、辞書登録用ワード生成不可能。
                                   "="  ; 墨字の "for"  が冒頭だと後続のワードと結合するので、辞書登録用ワード生成不可能。
                                   "("  ; 墨字の "of"   が冒頭だと後続のワードと結合するので、辞書登録用ワード生成不可能。
                                   ")"  ; 墨字の "with" が冒頭だと後続のワードと結合するので、辞書登録用ワード生成不可能。
                                   "6"  ; 墨字の "to"   が冒頭だと後続のワードと結合するので、辞書登録用ワード生成不可能。
                                   "96" ; 墨字の "into" が冒頭だと後続のワードと結合するので、辞書登録用ワード生成不可能。
                                   "0"  ; 墨字の "by"   が冒頭だと後続のワードと結合するので、辞書登録用ワード生成不可能。
                                  )
)

(defconstant _dic_symbol_index_ 0)    ; 辞書データのシンボルへのインデクス
(defconstant _dic_mode_index_ 1)      ; 辞書データのモードへのインデクス
(defconstant _dic_flags_index_ 2)     ; 辞書データのフラグへのインデクス
(defconstant _dic_string_index_ 3)    ; 辞書データの文字列へのインデクス
(defconstant _dic_ref_count_index_ 4) ; 辞書データの参照カウンタへのインデクス

; 墨字の定数
(defstring _blank_s_ " ")                          ; 
(defstring _blank_s2_ "  ")                        ; 
(defstring _dash_s_ "--")                          ; 
(defstring _blank_w_ (string #\IDEOGRAPHIC_SPACE)) ; 
(defstring _blank_w2_                              ; 
              (concatenate 'string (string #\IDEOGRAPHIC_SPACE) (string #\IDEOGRAPHIC_SPACE)))

(defstring _kutenSumiji_                           ; 
              (concatenate 'string "。" (string #\IDEOGRAPHIC_SPACE) (string #\IDEOGRAPHIC_SPACE)))
(defstring _toutenSumiji_                          ; 
              (concatenate 'string "、" (string #\IDEOGRAPHIC_SPACE)))
(defstring _kuten_w_ "。")         ; 
(defstring _touten_w_ "、")        ; 
(defstring _sagari0Sumiji_ "＿０") ; 墨字の下がり数字「０」
(defstring _sagari1Sumiji_ "＿１") ; 墨字の下がり数字「１」
(defstring _sagari2Sumiji_ "＿２") ; 墨字の下がり数字「２」
(defstring _sagari3Sumiji_ "＿３") ; 墨字の下がり数字「３」
(defstring _sagari4Sumiji_ "＿４") ; 墨字の下がり数字「４」
(defstring _sagari5Sumiji_ "＿５") ; 墨字の下がり数字「５」
(defstring _sagari6Sumiji_ "＿６") ; 墨字の下がり数字「６」
(defstring _sagari7Sumiji_ "＿７") ; 墨字の下がり数字「７」
(defstring _sagari8Sumiji_ "＿８") ; 墨字の下がり数字「８」
(defstring _sagari9Sumiji_ "＿９") ; 墨字の下がり数字「９」

; 状態遷移用リテラル
(defstring _numeralSign_s_ "#")               ; 
(defstring _letterSign_s_ ";")                ; 
(defstring _comma_s_ ",")                     ; 
(defstring _capitalSign_s_ ",")               ; 
(defstring _dot_s_ ".")                       ; 
(defstring _question_s_ "?")                 ; 
(defstring _rightRndBrac_s_ ")")             ; 
(defstring _rightSqrBrac_s_ "]")             ; 
(defstring _leftAngBrac_s_ "<")               ; 
(defstring _rightAngBrac_s_ ">")              ; 
(defstring _dblQuote_s_ "\"")                 ; 
(defstring _snglQuote_s_ "'")                 ; 
(defstring _apostrophy_s_ "'")               ; 
(defstring _hyphen_s_ "-")                    ; 
(defstring _backQuote_s_ "`")                ; バッククオート
(defstring _caret_s_ "^")                    ; 
(defstring _foreignQuotationStartSign_s_ "8") ; 
(defstring _foreignQuotationStopSign_s_ "0")  ; 
(defstring _doubleCapitalSign_s_ ",,")        ; 
(defstring _tripleCapitalSign_s_ ",,,")       ; 
(defstring _acbcStartSign_s_ "_+")            ; 
(defstring _acbcStopSign_s_ "_:")             ; 

(defstring _numeralSign_w_ "＃")              ; 
(defstring _letterSign_w_ "；")               ; 
(defstring _colon_w_ "：")                    ; 
(defstring _comma_w_ "，")                     ; 
(defstring _capitalSign_w_ "，")              ; 
(defstring _dot_w_ "．")                      ; 
(defstring _question_w_ "？")                 ; 
(defstring _exclamation_w_ "！")              ; 
(defstring _leftRndBrac_w_ "（")              ; 
(defstring _rightRndBrac_w_ "）")             ; 
(defstring _leftBrace_w_ "｛")                ; 
(defstring _rightBrace_w_ "｝")               ; 
(defstring _leftSqrBrac_w_ "［")              ; 
(defstring _rightSqrBrac_w_ "］")             ; 
(defstring _leftAngBrac_w_ "＜")              ; 
(defstring _rightAngBrac_w_ "＞")             ; 
(defstring _dblQuote_w_ "”")                 ; 
(defstring _apostrophy_w_ "’")               ; 
(defstring _hyphen_w_ "ー")                   ; 
(defstring _dash_w_ "－")                     ; 
(defstring _slash_w_ "／")                    ; 
(defstring _backQuote_w_ "｀")               ; バッククオート
(defstring _caret_w_ "＾")                   ; 
(defstring _doubleCapitalSign_w_ "，，")      ; 
(defstring _tripleCapitalSign_w_ "，，，")    ; 
(defstring _acbcStartSign_w_ "＿＋")          ; 
(defstring _acbcStopSign_w_ "＿：")           ; 

; Lisp のコントロールコード
(defconstant _sym_CR_ #\NewLine)               ; 改行のシンボル
(defconstant _sym_FF_ #\Page)                  ; 改ページのシンボル

; 英語グレード２の省略処理時に使用する結合モード（以下に準拠する）
; 結合なし、全体、先頭結合、中間結合、末端結合
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;system version 35
;BRITISH BRAILLE
;A Restatement of Standard English Braille
;Compiled and Authorised by the
;Braille Authority of the United Kingdom
;
;Royal National Institute for the Blind
;Bakewell Road, Orton Southgate
;Peterborough, Cambridgeshire
;PE2 6XU
;
;2001
;ISBN 0 901797 90 1
;© Braille Authority of the United Kingdom 1992, 2001
;Printed by RNIB, Peterborough 2001
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; 英語グレード２で使用するマスク
(defconstant _wholeWordMask_   #b100000000000000000000000000000000000000000000000)
(defconstant _initialWordMask_ #b010000000000000000000000000000000000000000000000)
(defconstant _medialWordMask_  #b001000000000000000000000000000000000000000000000)
(defconstant _finalWordMask_   #b000100000000000000000000000000000000000000000000)
(defconstant _capitalMask_     #b000010000000000000000000000000000000000000000000)
(defconstant _AllClearBits_    #b000001111111111111111111111111111111111111111111)

; *bracketStats* （後述）で使用するマスク
; 左から N/A、(&)、"&"、[&]、<&>、{&}、[&]、'&' 
(defconstant _bracMask_       #b10000000)
(defconstant _dQMask_         #b01000000)
(defconstant _sQMask_         #b00100000)
(defconstant _phomicBracMask_ #b00010000)
(defconstant _anglBracMask_   #b00001000)
(defconstant _braceBracMask_  #b00000100)
(defconstant _sqrBracMask_    #b00000010)
(defconstant _sngInvCommMask_ #b00000001)

;-------------------------------------------------------------------------------
; キーワードリスト変数の初期化
;-------------------------------------------------------------------------------
(defconstant _atomic-list_
  (list
    (intern "96")            ; intoxxx (03.03.05 Wordsigns sequenced)
    (intern "@7")            ; /xxx
    (intern "^7")            ; [xxx open phonemic bracket
    (intern "_7")            ; <xxx
    (intern ".7")            ; {xxx 左大括弧
    (intern ",7")            ; [xxx 左カギ括弧
    (intern _backQuote_brl_) ; `xxx シングルクォート開始
    (intern "7'")            ; ]
    (intern "j'")            ; '
    (intern "0'")))          ; 

; "。" "、" は、直後に全角スペースを伴うため、半角化しない。
; これらは narrow-string で全部または一部が半角化されるもの。
(defconstant _prohibit-hankaku-jp-list_
  (list
    (intern _kutenSumiji_)    ; "。"
    (intern _toutenSumiji_)   ; "、"
    (intern _hyphen_w_)       ; "ー"
    (intern _dot_w_)          ; "．"
    (intern _question_w_)     ; "？"
    (intern _exclamation_w_)  ; "！"
    (intern _leftRndBrac_w_)  ; "（"
    (intern _rightRndBrac_w_) ; "）"
;    (intern _leftBrace_w_)  ; "｛"
;    (intern _rightBrace_w_) ; "｝"
    (intern _leftSqrBrac_w_)  ; "［"
    (intern _rightSqrBrac_w_) ; "］"
    (intern _leftAngBrac_w_)  ; "＜"
    (intern _rightAngBrac_w_) ; "＞"
    (intern _slash_w_)))      ; "／"

(defconstant _prohibit-hankaku-di-list_
  (list
    (intern _dash_w_)))       ; "－"

;構成符号(モード変更記号)の点字のリスト
(defconstant _formatter-decode-list_
  (list
    (intern "=")                   ; ドットロケータ
    (intern _rightAngBrac_s_)      ; 詩行符
    (intern _numeralSign_s_)       ; 数符
    (intern "@")                   ; アクセント符、行継続符、墨字記号符
    (intern "\"3")                 ; 印刷インジケータ
    (intern _dot_s_)               ; イタリック符
    (intern "..")                  ; 二重イタリック符
    (intern ".'")                  ; イタリック符解除
    (intern _letterSign_s_)        ; 外字符（レターサイン）、字母記号、発音記号符
    (intern ";;")                  ; 二重外字符（レターサイン）
    (intern "_+")                  ; ACBC(American Computer Braille Code)開始
    (intern "_:")                  ; ACBC(American Computer Braille Code)終了
    (intern _capitalSign_s_)       ; 大文字符
    (intern _doubleCapitalSign_s_) ; 連続大文字符
    (intern _tripleCapitalSign_s_) ; 三重連続大文字符
    (intern ",'")                  ; 終止符、第二つなぎ符、大文字符解除
    (intern _hyphen_)              ; ハイフン、第一つなぎ符
    (intern _dash_s_)))            ; ダッシュ

(defconstant _formatter-encode-list_
  (list
    (intern "＝")                   ; ドットロケータ
    (intern _rightAngBrac_w_)       ; 詩行符
    (intern _numeralSign_w_)        ; 数符
    (intern "＠")                   ; アクセント符、行継続符、墨字記号符
    (intern "”３")                  ; 印刷インジケータ
    (intern _dot_w_)                ; イタリック符
    (intern "．．")                  ; 二重イタリック符
    (intern "．’")                  ; イタリック符解除
    (intern _letterSign_w_)         ; 外字符（レターサイン）、字母記号、発音記号符
    (intern "；；")                  ; 二重外字符（レターサイン）
    (intern "＿＋")                  ; ACBC(American Computer Braille Code)開始
    (intern "＿：")                  ; ACBC(American Computer Braille Code)終了
    (intern _capitalSign_w_)        ; 大文字符
    (intern _doubleCapitalSign_w_)  ; 連続大文字符
    (intern _tripleCapitalSign_w_)  ; 三重連続大文字符
    (intern "，’")                  ; 終止符、第二つなぎ符、大文字符解除
    (intern _hyphen_w_)             ; ハイフン、第一つなぎ符
    (intern _dash_w_)))             ; ダッシュ

;文章記号のリスト
(defconstant _punctuation-list_
  (list
    (list (intern _dot_s_)        (intern _dot_brl_))  ; . ピリオド
    (list (intern _dblQuote_s_)   (intern "0"))        ; " ダブルクォート終了
    (list (intern _comma_s_)      (intern "1"))        ; , カンマ
    (list (intern _letterSign_s_) (intern "2"))        ; ; セミコロン
    (list (intern _dblQuote_s_)   (intern "8"))        ; " ダブルクォート開始
    (list (intern _question_s_)   (intern "8"))        ; ? クエスチョンマーク
    (list (intern _hyphen_)       (intern _hyphen_)))) ; - ハイフン

;-------------------------------------------------------------------------------
; 英語グレード２用のアトミックなリスト
;-------------------------------------------------------------------------------
; リーダーとなる1マス略語(and/for/of/with)
(defconstant _ocAbbrWord-leader-encode-s-list_
  (list
    (intern "and")
    (intern "for")
    (intern "of")
    (intern "with")))

(defconstant _ocAbbrWord-leader-encode-w-list_
  (list
    (intern "ａｎｄ")     ; and
    (intern "ｆｏｒ")     ; for
    (intern "ｏｆ")       ; of
    (intern "ｗｉｔｈ"))) ; with

(defconstant _ocAbbrWord-leader-decode-s-list_
  (list
    (intern "&")   ; and
    (intern "=")   ; for
    (intern "(")   ; of
    (intern ")"))) ; with

; フォロワーとなる1マス略語(and/for/of/the/with/a)
(defconstant _ocAbbrWord-member-encode-s-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-encode-s-list_
    (list
      (intern "the")
      (intern "a"))))

; リーダーとなる低下略語(into/to/by)
(defconstant _lwAbbrWord-leader-encode-s-list_
  (list
    (intern "into")
    (intern "to")
    (intern "by")))

(defconstant _lwAbbrWord-leader-encode-w-list_
  (list
    (intern "ｉｎｔｏ") ; into
    (intern "ｔｏ")    ; to
    (intern "ｂｙ")))  ; by

(defconstant _lwAbbrWord-leader-decode-s-list_
  (list
    (intern "96")  ; into
    (intern "6")   ; to
    (intern "0"))) ; by

; フォロワーとなる低下略語(be/enough/were/his/in/was)
(defconstant _lwAbbrWord-member-encode-s-list_
  (list
    (intern "be")
    (intern "enough")
    (intern "were")
    (intern "his ")
    (intern "in")
    (intern "was ")
;
; NFBtrans は into/to/by が連続しているのを許可しているので、
; 取り合えず準拠する。
; 
;    (intern "into")
;    (intern "to")
;    (intern "by")
  ))

;-------------------------------------------------------------------------------
; 英語グレード２用の連結・分割の禁則用リスト
;-------------------------------------------------------------------------------
; 1マス略語で連結が禁止されている文章記号のドットペアのリスト
(defconstant _inhibit-ocAbbrWord-neighbour-dlist_
  '(
    (|.| . |4|) ; . ピリオド
    (|"| . |0|) ; " ダブルクォート終了
    (|,| . |1|) ; , カンマ
    (|;| . |2|) ; ; セミコロン
    (|"| . |8|) ; " ダブルクォート開始
    (?   . |8|) ; ? クエスチョンマーク
    (|!| . |6|) ; ! エクスクラメーション
    (-   . -)   ; - ハイフン
    (|'| . |'|) ; ' アポストロフィー
    (|,| . |,|) ; , 大文字符
    (|.| . |.|) ; , イタリック符
    (|(| . |7|) ; ( 左括弧
    (|)| . |7|) ; ) 右括弧
    ))

;低下略語で連結が禁止されている文章記号のドットペアのリスト
(defconstant _inhibit-lwAbbrWord-neighbour-dlist_
  '(
    (|.| . |4|) ; . ピリオド
    (|"| . |0|) ; " ダブルクォート終了
    (|,| . |1|) ; , カンマ
    (|;| . |2|) ; ; セミコロン
    (|"| . |8|) ; " ダブルクォート開始
    (?   . |8|) ; ? クエスチョンマーク
    (|!| . |6|) ; ! エクスクラメーション
    (-   . -)   ; - ハイフン
    (|'| . |'|) ; ' アポストロフィー
    (|(| . |7|) ; ( 左括弧
    (|)| . |7|) ; ) 右括弧
    ))

;-------------------------------------------------------------------------------
; 英語グレード２の字句解析用リスト
;-------------------------------------------------------------------------------
(defconstant _prep-inf-conj-encode-s-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-encode-s-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-encode-s-list_))

(defconstant _prep-inf-conj-encode-w-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-encode-w-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-encode-w-list_))

(defconstant _prep-inf-conj-decode-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-decode-s-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-decode-s-list_))

(defconstant _effectiveLeft-decode-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-decode-s-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-decode-s-list_
    (list
      (intern _capitalSign_s_) ; ,xxx 大文字符
      (intern "@7")            ; /xxx
      (intern "^7")            ; [xxx open phonemic bracket
      (intern "_7")            ; <xxx
      (intern ".7")            ; {xxx 左大括弧
      (intern ",7")            ; [xxx 左カギ括弧
      (intern "7")             ; (xxx 左括弧
      (intern _backQuote_brl_) ; `xxx シングルクォート開始
      (intern "8")             ; "xxx ダブルクォート開始
      (intern "1")             ; ,xxx カンマ
      (intern "2")             ; ;xxx セミコロン
      (intern "'"))))          ; 'xxx アポストロフィー

(defconstant _effectiveLeft-encode-s-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-encode-s-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-encode-s-list_
    (list
      (intern _capitalSign_s_) ; ,xxx 大文字符
      (intern "/")             ; /xxx
      (intern "{")             ; {xxx 左大括弧
      (intern "[")             ; [xxx open phonemic bracket
      (intern _leftAngBrac_s_) ; <xxx
      (intern "(")             ; (xxx
      (intern _apostrophy_s_)  ; `xxx シングルクォート開始
      (intern _dblQuote_s_)    ; "xxx ダブルクォート開始
      (intern _capitalSign_s_) ; ,xxx カンマ
      (intern _letterSign_s_)  ; ;xxx セミコロン
      (intern "'"))))          ; 'xxx アポストロフィー

(defconstant _effectiveLeft-encode-w-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-encode-w-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-encode-w-list_
    (list
      (intern _capitalSign_w_)      ; ,xxx 大文字符
      (intern _slash_w_)            ; /xxx
      (intern _leftBrace_w_)        ; {xxx 左大括弧
      (intern _leftSqrBrac_w_)      ; [xxx open phonemic bracket
      (intern _leftAngBrac_w_)      ; <xxx
      (intern _leftRndBrac_w_)      ; (xxx
      (intern _backQuote_w_)        ; `xxx シングルクォート開始
      (intern _dblQuote_w_)         ; "xxx ダブルクォート開始
      (intern _capitalSign_w_)      ; ,xxx カンマ
      (intern _letterSign_w_)       ; ;xxx セミコロン
      (intern _apostrophy_w_))))    ; 'xxx アポストロフィー

(defconstant _ignoreableLeft-decode-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-decode-s-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-decode-s-list_
    (list
      (intern _capitalSign_s_) ; ,xxx 大文字符
      (intern "@7")            ; /xxx
      (intern "^7")            ; [xxx open phonemic bracket
      (intern "_7")            ; <xxx
      (intern ".7")            ; {xxx 左大括弧
      (intern ",7")            ; [xxx 左カギ括弧
      (intern "7")             ; (xxx 左括弧
      (intern _backQuote_brl_) ; `xxx シングルクォート開始
      (intern "8")             ; "xxx ダブルクォート開始
      (intern "1")             ; ,xxx カンマ
      (intern "2")             ; ;xxx セミコロン
      (intern _hyphen_)        ; -xxx ハイフン
      (intern "'"))))          ; 'xxx アポストロフィー

(defconstant _ignoreableLeft-encode-s-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-encode-s-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-encode-s-list_
    (list
      (intern _capitalSign_s_)      ; ,xxx 大文字符
      (intern "/")                  ; /xxx
      (intern "{")                  ; {xxx 左大括弧
      (intern "[")                  ; [xxx open phonemic bracket
      (intern _leftAngBrac_s_)      ; <xxx
      (intern "(")                  ; (xxx
      (intern _backQuote_s_)        ; `xxx シングルクォート開始
      (intern _dblQuote_s_)         ; "xxx ダブルクォート開始
      (intern _capitalSign_s_)      ; ,xxx カンマ
      (intern _letterSign_s_)       ; ;xxx セミコロン
      (intern _hyphen_s_)           ; -xxx ハイフン
      (intern "'"))))               ; 'xxx アポストロフィー

(defconstant _ignoreableLeft-encode-w-list_
  (append
    ; 1マス略字【リーダ】
    _ocAbbrWord-leader-encode-w-list_
    ; 低下略語【リーダ】
    _lwAbbrWord-leader-encode-w-list_
    (list
      (intern _capitalSign_w_)      ; ,xxx 大文字符
      (intern _slash_w_)            ; /xxx
      (intern _leftBrace_w_)        ; {xxx 左大括弧
      (intern _leftSqrBrac_w_)      ; [xxx open phonemic bracket
      (intern _leftAngBrac_w_)      ; <xxx
      (intern _leftRndBrac_w_)      ; (xxx
      (intern _backQuote_w_)        ; `xxx シングルクォート開始
      (intern _dblQuote_w_)         ; "xxx ダブルクォート開始
      (intern _capitalSign_w_)      ; ,xxx カンマ
      (intern _letterSign_w_)       ; ;xxx セミコロン
      (intern _hyphen_w_)           ; -xxx ハイフン
      (intern _apostrophy_w_))))    ; 'xxx アポストロフィー

(defconstant _ignoreableRight-decode-list_
  (list
    (intern _blank_s_)   ;   半角空白
    (intern "4")         ; . ピリオド、省略
    (intern "1")         ; , カンマ 
    (intern "0")         ; " ダブルクォート終了
    (intern "8")         ; ? クエスチョンマーク
    (intern "6")         ; ! エクスクラメーション
    (intern "7'")        ; ] 右カギ括弧
    (intern "7")         ; ) 右括弧
    (intern "3")         ; : コロン
    (intern "'")         ; ' アポストロフィー
    (intern "2")         ; ; セミコロン
    (intern _hyphen_)))  ; -xxx ハイフン

(defconstant _ignoreableRight-encode-s-list_
  (list
    (intern _blank_s_)        ;   半角空白
    (intern _dot_s_)          ; . ピリオド、省略
    (intern _capitalSign_s_)  ; , カンマ
    (intern _dblQuote_s_)     ; " ダブルクォート終了
    (intern "?")              ; ? クエスチョンマーク
    (intern "!")              ; ! エクスクラメーション
    (intern _rightSqrBrac_s_) ; ] 右カギ括弧
    (intern _rightRndBrac_s_) ; ) 右括弧
    (intern ":")              ; : コロン
    (intern "'")              ; ' アポストロフィー
    (intern _letterSign_s_)   ; ; セミコロン
    (intern _hyphen_s_)       ; -xxx ハイフン
  )
)

(defconstant _ignoreableRight-encode-w-list_
  (list
;    (intern "　")            ; 
    (intern _blank_s_)        ;   半角空白
    (intern _dot_w_)          ; . ピリオド、省略
    (intern _capitalSign_w_)  ; , カンマ
    (intern _dblQuote_w_)     ; " ダブルクォート終了
    (intern _question_w_)     ; ? クエスチョンマーク
    (intern _exclamation_w_)  ; ! エクスクラメーション
    (intern _rightSqrBrac_w_) ; ] 右カギ括弧
    (intern _rightRndBrac_w_) ; ) 右括弧
    (intern _colon_w_)        ; : コロン
    (intern _apostrophy_w_)   ; ' アポストロフィー
    (intern _letterSign_w_)   ; ; セミコロン
    (intern _dash_w_)         ; - ダッシュ (2007/12/31 11:09) 採用
;    (intern _hyphen_w_)       ; -xxx ハイフン (2007/12/31 11:09) 中止
  )
)

(defconstant _ignoreableTail-decode-list_
  (list
    (intern _blank_s_)  ; 
    (intern "4")        ; . ピリオド
    (intern "1")        ; , カンマ 
    (intern "8")        ; ? クエスチョンマーク
    (intern "0")        ; " ダブルクォート終了
    (intern "6")        ; ! エクスクラメーション
    (intern "2")        ; ; セミコロン
  )
)

(defconstant _ignoreableTail-encode-s-list_
  (list
    (intern _blank_s_)       ; 
    (intern _dot_s_)         ; . ピリオド
    (intern _capitalSign_s_) ; , カンマ 
    (intern "?")             ; ? クエスチョンマーク
    (intern _dblQuote_s_)    ; " ダブルクォート終了
    (intern "!")             ; ! エクスクラメーション
    (intern _letterSign_s_)  ; ; セミコロン
  )
)

(defconstant _ignoreableTail-encode-w-list_
  (list
    (intern _blank_w_)       ; 
    (intern _dot_w_)         ; . ピリオド
    (intern _capitalSign_w_) ; , カンマ 
    (intern _question_w_)    ; ? クエスチョンマーク
    (intern _dblQuote_w_)    ; " ダブルクォート終了
    (intern _exclamation_w_) ; ! エクスクラメーション
    (intern _letterSign_w_)  ; ; セミコロン
  )
)

;-------------------------------------------------------------------------------
; 必須の文字列のリスト（シンボルのリストから作成）
;-------------------------------------------------------------------------------
(defconstant _effectiveLeft-decode-p_
  (mapcar #'string _effectiveLeft-decode-list_))

(defconstant _effectiveLeft-encode-s-p_
  (mapcar #'string _effectiveLeft-encode-s-list_))

(defconstant _effectiveLeft-encode-w-p_
  (mapcar #'string _effectiveLeft-encode-w-list_))

(defconstant _ignoreableLeft-decode-p_
  (mapcar #'string _ignoreableLeft-decode-list_))

(defconstant _ignoreableLeft-encode-s-p_
  (mapcar #'string _ignoreableLeft-encode-s-list_))

(defconstant _ignoreableLeft-encode-w-p_
  (mapcar #'string _ignoreableLeft-encode-w-list_))

(defconstant _ignoreableRight-decode-p_
  (mapcar #'string _ignoreableRight-decode-list_))

(defconstant _ignoreableRight-encode-s-p_
  (mapcar #'string _ignoreableRight-encode-s-list_))

(defconstant _ignoreableRight-encode-w-p_
  (mapcar #'string _ignoreableRight-encode-w-list_))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 変数の宣言
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defparameter *debug* 0)                ; デバッグレベル(0-9)
                                        ; 0:デバッグ文を表示しない。
                                        ; 1:チャンクに特化したデバッグ表示をする。
                                        ; 2:英語グレード２の情報と括弧状態の表示をする。
                                        ; 3:点字と墨字を左右に連結して表示する。
                                        ; 4:辞書の登録・参照状況を表示する。
                                        ; 5:maintainSubstrCount の状況を表示する。
                                        ; 6:wordList2String のフラグを表示する。
                                        ; 7:wordList2String の出力時の内部状態を表示する。
                                        ; 8:decideCombination の状況を表示する。
                                        ; 9:wordList2String の入出力を表示する。
(defparameter *verbose* nil)            ; 英語グレード２の使用の有無
(defparameter *useG2dic* t)             ; 英語グレード２の使用の有無

; 定数的にしたいところだが、プログラムでセットするため変数とする。
(defparameter *nonAlphaList* nil)       ; 大文字符付与に使用する、アルファベット以外の文字リスト

;-------------------------------------------------------------------------------
; 変換用設定（基本）
;-------------------------------------------------------------------------------
(defparameter *dontInOutBackQuote* t)   ; シングルクォートの開始の記号としてバッククォートを外部とインターフェースしない。
(defparameter *defaultMode* nil)        ; デフォルトモード(通常："JP"、グレード２："us")
(defparameter *defaultLang* nil)        ; デフォルト言語(通常：*kana*、グレード２：*us_grade2*)
(defparameter *lastMode* nil)           ; 以前のモード
(defparameter *lastLang* nil)           ; 以前の言語
(defparameter *curMode* nil)            ; 現在のモード
(defparameter *curLang* nil)            ; 現在の言語
(defparameter *langNameList* nil)       ; 言語名リスト
(defparameter *langList* nil)           ; 言語リスト
(defparameter *represent* nil)          ; 表示用言語
(defparameter *common* nil)             ; 共通言語(*us_grade1* + α)
(defparameter *number* nil)             ; 数字言語
(defparameter *mathematics* nil)        ; 数学言語
(defparameter *science* nil)            ; 科学言語
(defparameter *pronunciation* nil)      ; 発音言語
(defparameter *kana* nil)               ; 仮名言語
(defparameter *uk_grade1* nil)          ; 英語グレード１言語
(defparameter *uk_grade2* nil)          ; 英語グレード２言語
(defparameter *uk_grade3* nil)          ; 英語グレード３言語(未実装)
(defparameter *uk_grade4* nil)          ; 英語グレード４言語(未実装)
(defparameter *us_grade1* nil)          ; 英語グレード１言語
(defparameter *us_grade2* nil)          ; 英語グレード２言語
(defparameter *us_grade2_excp_whole* nil)    ; 英語グレード２言語(例外：wholeWordContraction)
(defparameter *us_grade2_excp_initial* nil)  ; 英語グレード２言語(例外：initialWordContraction)
(defparameter *us_grade2_excp_medial* nil)   ; 英語グレード２言語(例外：medialWordContraction)
(defparameter *us_grade2_excp_final* nil)    ; 英語グレード２言語(例外：finalWordContraction)
(defparameter *us_grade2_excp_none* nil)     ; 英語グレード２言語(例外：noContraction)
(defparameter *us_grade3* nil)          ; 英語グレード３言語(未実装)
(defparameter *us_grade4* nil)          ; 英語グレード４言語(未実装)
(defparameter *regist_dict* nil)        ; 辞書登録の有無
(defparameter *lookup_dict* nil)        ; 辞書参照の有無
(defparameter *hyphenate* nil)          ; ハイフネーションの有無(エンコード時のみ)
(defparameter *justificate* nil)        ; ジャスティフィケーションの有無(エンコード時のみ)
(defparameter *grade2_enc_dict* nil)    ; 英語グレード２辞書（エンコードで使用）
(defparameter *grade2_dec_dict* nil)    ; 英語グレード２辞書（デコードで使用）
(defparameter *uk_grade2_enc_dict* nil) ; 英語グレード２（英国）辞書（エンコードで使用）
(defparameter *uk_grade2_dec_dict* nil) ; 英語グレード２（英国）辞書（デコードで使用）
(defparameter *uk_hyphen_dict* nil)     ; 英語ハイフネーション（英国）辞書（エンコードで使用）
(defparameter *us_grade2_enc_dict* nil) ; 英語グレード２（米国）辞書（エンコードで使用）
(defparameter *us_grade2_dec_dict* nil) ; 英語グレード２（米国）辞書（デコードで使用）
(defparameter *us_hyphen_dict* nil)     ; 英語ハイフネーション（米国）辞書（エンコードで使用）
(defparameter *url_suffix_list* nil)    ; URLサフィックスのリスト
(defparameter *cbcSign* nil)            ; Computer Braille Code(記号)
(defparameter *cbcNumber* nil)          ; Computer Braille Code(数字)
(defparameter *cbcKana* nil)            ; Computer Braille Code(仮名)
(defparameter *nabcc* nil)              ; NABCC
(defparameter *grade* 1)                ; グレード(通常：1、グレード２：2)
(defparameter *forceGrade1* nil)        ; 英語グレード２の場合でも省略を許可しないフラグ
(defparameter *defaultEnglish* nil)     ; 英語モード("us","uk")

(defparameter *maxItemLengthList* nil)    ; 言語連想配列に格納された点字の最大長のリスト
(defparameter *maxLangBrailleLength* nil) ; 言語連想配列に格納された点字の最大長
(defparameter *maxLangSumijiLength* nil)  ; 言語連想配列に格納された墨字の最大長
(defparameter *maxDicBrailleLength* nil)  ; 英語グレード２辞書の連想配列に格納された点字の最大長
(defparameter *maxDicSumijiLength* nil)   ; 英語グレード２辞書の連想配列に格納された墨字の最大長

(defparameter *bracketStats* 0)         ; 括弧の状態を全て表すフラグ群
                                        ; ※ネストには対応していない。

(defparameter *g2DicRefCntList* nil)    ; 英語グレード２辞書項目の参照回数の連想配列。
                                        ; saveUsGrade2ExtFile で辞書エクストラクト
                                        ; ファイル作成時に使用する。

(defparameter *gInputLineCnt* 0)        ; 入力行カウンタ
(defparameter *gOutputLineCnt* 0)       ; 出力行カウンタ
(defparameter *gOutputPageNumber* nil)  ; 頁番号の出力

;-------------------------------------------------------------------------------
; 変換用設定（read マクロで使用分）
;-------------------------------------------------------------------------------
(defparameter *hankaku* nil)              ; 出力文字列半角化の要否                  (デコードのみ有効)
(defparameter *rowBytes* _bseRowBytes_)   ; 一行のバイト数                         (エンコードのみ有効)
(defparameter *pageLines* _bsePageLines_) ; 一頁の行数                            (エンコードのみ有効)
(defparameter *separatePrepOrInf* t)      ; 前置詞・不定詞・接続詞を分割の要否        
(defparameter *emitSigns* nil)            ; 数符・外字符・ACBC符・大文字符を出力の要否 (デコードのみ有効)
(defparameter *jpPrep* nil)               ; 濁音・半濁音の前に、” や ， 出力の要否    (デコードのみ有効)
(defparameter *putCapitalSign* nil)       ; 大文字符自動付与の要否                  (エンコードのみ有効)
(defparameter *emitHeader* nil)           ; ヘッダ（含改ページ）出力の要否           (エンコードのみ有効)
(defparameter *encodeIntoBinary* nil)     ; エンコード結果をバイナリで出力する。      (エンコードのみ有効)
(defparameter *decodeFromBinary* nil)     ; デコードの入力形式をバイナリにする。      (デコードのみ有効)
