;
; rcsID=$Id: LiteraryUS.lisp,v 1.17 2008/04/29 16:25:15 tmatsugaki Exp $
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;system version 35
;BRITISH BRAILLE
;A Restatement of Standard English Braille
;Compiled and Authorised by the
;Braille Authority of the United Kingdom
;
;Royal National Institute for the Blind
;Bakewell Road, Orton Southgate
;Peterborough, Cambridgeshire
;PE2 6XU
;
;2001
;ISBN 0 901797 90 1
;© Braille Authority of the United Kingdom 1992, 2001
;Printed by RNIB, Peterborough 2001
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(proclaim '(inline genUsGrade2Dictionary
                   registUsGrade2Dic
                   saveUsGrade2ExtFile
                   loadUsGrade2ExtFile
                   genUsGrade2DicInfo
                   updateUsG2DicAccessInfo
                   setUsDicMaxLength
                   makeUsUrlList
                   us_ignoreableLeft
                   us_ignoreableRight
                   us_ignoreableTail
                   us_wholeWordCandidate
                   us_initialWordCandidate
                   us_medialWordCandidate
                   us_terminalWordCandidate
                   us_prep-inf-conj-p
                   us_url-p))
(proclaim '(optimize speed))

#|
(defparameter *us_grade1* nil)
(defparameter *us_grade2* nil)
(defparameter *us_grade3* nil)
(defparameter *us_grade4* nil)
(defparameter *us_grade2_enc_dict* nil)
(defparameter *us_grade2_dec_dict* nil)
|#

(defun inUsBracket(&optional (val *bracketStats*))             (/= (logand _bracMask_ val) 0))
(defun inUsDoubleQuote(&optional (val *bracketStats*))         (/= (logand _dQMask_ val) 0))
(defun inUsSingleQuote(&optional (val *bracketStats*))         (/= (logand _sQMask_ val) 0))
(defun inUsPhonemicBracket(&optional (val *bracketStats*))     (/= (logand _phomicBracMask_ val) 0))
(defun inUsAngleBracket(&optional (val *bracketStats*))        (/= (logand _anglBracMask_ val) 0))
(defun inUsBraceBracket(&optional (val *bracketStats*))        (/= (logand _braceBracMask_ val) 0))
(defun inUsSquareBracket(&optional (val *bracketStats*))       (/= (logand _sqrBracMask_ val) 0))
(defun inUsSingleInvertedComma(&optional (val *bracketStats*)) (/= (logand _sngInvCommMask_ val) 0))

(defun initLiteraryUS ()
  (setf *us_grade1*
   '(
      (| |    . #b000000000000000000000000000000000000000000000000) ; _

; 構成符号
      (|#|    . #b000000000000000000000000000000000000000000001111) ; #    数符
      (@      . #b000000000000000000000000000000000000000000000100) ; @    アクセント符、行継続符、墨字記号符
      (|.|    . #b000000000000000000000000000000000000000000000101) ; .    イタリック符、仮名フラグ
      (|..|   . #b000000000000000000000000000000000000000101000101) ; ..   二重イタリック符
      (|.'|   . #b000000000000000000000000000000000000000101001000) ; .'   イタリック符解除
      (|;|    . #b000000000000000000000000000000000000000000000011) ; ;    外字符、字母記号、発音記号符
      (_+     . #b000000000000000000000000000000000000000111001101) ; _+   ACBC(American Computer Braille Code)開始
      (|_:|   . #b000000000000000000000000000000000000000111100011) ; _:   ACBC(American Computer Braille Code)終了
      (|,|    . #b000000000000000000000000000000000000000000000001) ; ,    大文字符
      (|,,|   . #b000000000000000000000000000000000000000001000001) ; ,,   連続大文字符
      (|,'|   . #b000000000000000000000000000000000000000001001000) ; ,'   終止符、第二つなぎ符

      (^      . #b000000000000000000000000000000000000000000000110) ; ^    小文字符

; ※外国語引用符開始の { は、以下の理由で宣言しない。
;  1.世界標準の言語が自身であるので宣言が不要、英語以外の言語が具備するべきもの。
;  2." (ダブルクォート終了) と競合する。
; ※外国語引用符終了の } は、例えば母国語への復帰用ワードとして機能するので、ここでの宣言が必須。
;      ({     . #b000000000000000000000000000000000000000000011001) ; 8    外国語引用符開始（cf. *kana*）
      (}      . #b000000000000000000000000000000000000000000001011) ; 0    外国語引用符終了, same as double quote end
;      (|,8|  . #b000000000000000000000000000000000000000001011001) ; ,8   一般の日本語点字中の情報処理用点字挿入開始（cf. *kana*）
      (|,0|   . #b000000000000000000000000000000000000000001001011) ; ,0   一般の日本語点字中の情報処理用点字挿入終了
      (-      . #b000000000000000000000000000000000000000000001001) ; -    ハイフン、第一つなぎ符
      (--     . #b000000000000000000000000000000000000001001001001) ; --   ダッシュ

; 記号
      (|, |   . #b000000000000000000000000000000000000010000000000) ; 1_   カンマ
      (|; |   . #b000000000000000000000000000000000000011000000000) ; 2_   セミコロン
      (|:|    . #b000000000000000000000000000000000000000000010010) ; 3    コロン
      (|.|    . #b000000000000000000000000000000000000000000010011) ; 4    ピリオド
      (|!|    . #b000000000000000000000000000000000000000000011010) ; 6    エクスクラメーション
      (|(|    . #b000000000000000000000000000000000000000000011011) ; 7    左括弧
      (|)|    . #b000000000000000000000000000000000000000000011011) ; 7    右括弧
      (|8|    . #b000000000000000000000000000000000000000000011001) ; 8    ダブルクォート開始
;      (|"|    . #b000000000000000000000000000000000000000000001011) ; 0    ダブルクォート終了
      (|? |   . #b000000000000000000000000000000000000011001000000) ; 8_   クエスチョンマーク
      (|`|    . #b000000000000000000000000000000000000000001011001) ; ,8   シングルクォート開始
      (|' |   . #b000000000000000000000000000000001011001000000000) ; 0'_  シングルクォート終了
      (|'|    . #b000000000000000000000000000000000000000000001000) ; '    アポストロフィー
      (|''' | . #b000000000000000000000000000101000101000101000000) ; ..._ ...
      (/      . #b000000000000000000000000000000000000000000001100) ; /    斜線

      (<      . #b000000000000000000000000000000000000000111011011) ; _7   左角括弧
      (>      . #b000000000000000000000000000000000000000111011011) ; _7   右角括弧
      ({      . #b000000000000000000000000000000000000000101011011) ; .7   左大括弧
      (}      . #b000000000000000000000000000000000000000101011011) ; .7   右大括弧
      ([      . #b000000000000000000000000000000000000000001011011) ; ,7   左カギ括弧
      (]      . #b000000000000000000000000000000000000011011001000) ; 7'   右カギ括弧

      ($      . #b000000000000000000000000000000000000000000110101) ; $    ダラーサイン
      (%      . #b000000000000000000000000000000000000000000100101) ; %    パーセント
      (*      . #b000000000000000000000000000000000000001010001010) ; 99   アスタリスク
      (_      . #b000000000000000000000000000000000000000000001001) ; -    アンダースコア
      (~      . #b000000000000000000000000000000000000000000000110) ; ^    チルダ、第2ストレス符
      (|;2|   . #b000000000000000000000000000000000000000011011000) ; ;2   注意書き
      (|--- | . #b000000000000000000001001001001001001001001000000) ; ---_ ロングダッシュ
;      (\|    . #b000000000000000000000000000000000000000000110100) ; f    

      (€      . #b000000000000000000000000000000000000000100100010) ; @e   euro
      (¥      . #b000000000000000000000000000000000000000100101111) ; @y   yen

; アルファベット(グレード1)
      (|a|    . #b000000000000000000000000000000000000000000100000)
      (|b|    . #b000000000000000000000000000000000000000000110000)
      (|c|    . #b000000000000000000000000000000000000000000100100)
      (|d|    . #b000000000000000000000000000000000000000000100110)
      (|e|    . #b000000000000000000000000000000000000000000100010)
      (|f|    . #b000000000000000000000000000000000000000000110100)
      (|g|    . #b000000000000000000000000000000000000000000110110)
      (|h|    . #b000000000000000000000000000000000000000000110010)
      (|i|    . #b000000000000000000000000000000000000000000010100)
      (|j|    . #b000000000000000000000000000000000000000000010110)
      (|k|    . #b000000000000000000000000000000000000000000101000)
      (|l|    . #b000000000000000000000000000000000000000000111000)
      (|m|    . #b000000000000000000000000000000000000000000101100)
      (|n|    . #b000000000000000000000000000000000000000000101110)
      (|o|    . #b000000000000000000000000000000000000000000101010)
      (|p|    . #b000000000000000000000000000000000000000000111100)
      (|q|    . #b000000000000000000000000000000000000000000111110)
      (|r|    . #b000000000000000000000000000000000000000000111010)
      (|s|    . #b000000000000000000000000000000000000000000011100)
      (|t|    . #b000000000000000000000000000000000000000000011110)
      (|u|    . #b000000000000000000000000000000000000000000101001)
      (|v|    . #b000000000000000000000000000000000000000000111001)
      (|w|    . #b000000000000000000000000000000000000000000010111)
      (|x|    . #b000000000000000000000000000000000000000000101101)
      (|y|    . #b000000000000000000000000000000000000000000101111)
      (|z|    . #b000000000000000000000000000000000000000000101011)
      (A      . #b000000000000000000000000000000000000000000100000)
      (B      . #b000000000000000000000000000000000000000000110000)
      (C      . #b000000000000000000000000000000000000000000100100)
      (D      . #b000000000000000000000000000000000000000000100110)
      (E      . #b000000000000000000000000000000000000000000100010)
      (F      . #b000000000000000000000000000000000000000000110100)
      (G      . #b000000000000000000000000000000000000000000110110)
      (H      . #b000000000000000000000000000000000000000000110010)
      (I      . #b000000000000000000000000000000000000000000010100)
      (J      . #b000000000000000000000000000000000000000000010110)
      (K      . #b000000000000000000000000000000000000000000101000)
      (L      . #b000000000000000000000000000000000000000000111000)
      (M      . #b000000000000000000000000000000000000000000101100)
      (N      . #b000000000000000000000000000000000000000000101110)
      (O      . #b000000000000000000000000000000000000000000101010)
      (P      . #b000000000000000000000000000000000000000000111100)
      (Q      . #b000000000000000000000000000000000000000000111110)
      (R      . #b000000000000000000000000000000000000000000111010)
      (S      . #b000000000000000000000000000000000000000000011100)
      (T      . #b000000000000000000000000000000000000000000011110)
      (U      . #b000000000000000000000000000000000000000000101001)
      (V      . #b000000000000000000000000000000000000000000111001)
      (W      . #b000000000000000000000000000000000000000000010111)
      (X      . #b000000000000000000000000000000000000000000101101)
      (Y      . #b000000000000000000000000000000000000000000101111)
      (Z      . #b000000000000000000000000000000000000000000101011)
    )
  )

  (setf *us_grade2*
   '(
      (| |    . #b000000000000000000000000000000000000000000000000) ; _

; 構成符号 (2.4. COMPOSITION SIGNS)
;      (|=|    . #b000000000000000000000000000000000000000000111111) ;     ドットロケータ
      (|=|    . #b000000000000000000000000000000000000000101101000) ; .k   等号
;      (1      . #b000000000000000000000000000000000000000000010000) ;      非ローマン符
      (>      . #b000000000000000000000000000000000000000000001110) ; >    詩行符

      (|#|    . #b000000000000000000000000000000000000000000001111) ; #    数符
; P#A のような用例に対応するため、先端結合／中間結合を追加を検討した。
;      (|#|    . #b010000000000000000000000000000000000000000001111) ; #    数符 Jan 2, 2008 導入を検討したが、NG (ISSUE-2)
;      (|#|    . #b001000000000000000000000000000000000000000001111) ; #    数符 Jan 2, 2008 導入を検討したが、NG (ISSUE-2)

      (@      . #b000000000000000000000000000000000000000000000100) ; @    アクセント符、行継続符、墨字記号符
      (|"3|   . #b000000000000000000000000000000000000000010010010) ;      印刷インジケータ

      (|.|    . #b010000000000000000000000000000000000000000000101) ; .    イタリック符 cf. ピリオド
      (|..|   . #b000000000000000000000000000000000000000101000101) ; ..   二重イタリック符
      (|.'|   . #b000000000000000000000000000000000000000101001000) ; .'   イタリック符解除
      (|;|    . #b000000000000000000000000000000000000000000000011) ; ;    外字符（レターサイン）、字母記号、発音記号符
      (|;;|   . #b000000000000000000000000000000000000000011000011) ; ;;   二重外字符（レターサイン）
      (_+     . #b000000000000000000000000000000000000000111001101) ; _+   ACBC(American Computer Braille Code)開始
      (|_:|   . #b000000000000000000000000000000000000000111100011) ; _:   ACBC(American Computer Braille Code)終了
      (|,|    . #b000000000000000000000000000000000000000000000001) ; ,    大文字符
      (|,,|   . #b000000000000000000000000000000000000000001000001) ; ,,   連続大文字符
      (|,,,|  . #b000000000000000000000000000000000001000001000001) ; ,,,  三重連続大文字符
      (|,'|   . #b000000000000000000000000000000000000000001001000) ; ,'   終止符、第二つなぎ符、大文字符解除

; 小文字符は未使用だったが、内部的に改行コードとして使用する。2008/01/03 17:55
      (^      . #b000000000000000000000000000000000000000000000110) ;      小文字符
;      (|,0|  . #b000000000000000000000000000000000000000001001011) ;      一般の日本語点字中の情報処理用点字挿入終了
      (-      . #b000000000000000000000000000000000000000000001001) ; -    ハイフン、第一つなぎ符
      (--     . #b000000000000000000000000000000000000001001001001) ; --   ダッシュ

; 記号
      (|,|    . #b100000000000000000000000000000000000000000010000) ; 1    カンマ　cf.WW1(前置詞などに連なる場合)
;      (|,|    . #b001000000000000000000000000000000000000000010000) ; 1    カンマ　(数字中に存在する場合) Jan 2, 2008 導入を検討したが、NG (ISSUE-1)
      (|,|    . #b000100000000000000000000000000000000000000010000) ; 1    カンマ　cf.WW1
      (|;|    . #b000100000000000000000000000000000000000000011000) ; 2    セミコロン
      (|:|    . #b000000000000000000000000000000000000000000010010) ; 3    コロン

;      (|.|    . #b000000000000000000000000000000000000000000010011) ; 4    ピリオド、省略
      (|.|    . #b100000000000000000000000000000000000000000010011) ; 4    （浮いた）ピリオド cf. イタリック符
      (|.|    . #b000100000000000000000000000000000000000000010011) ; 4    ピリオド cf. イタリック符
      (|.|    . #b000000000000000000000000000000000000000000010011) ; 4    URL中のドット cf. イタリック符

      (|!|    . #b000000000000000000000000000000000000000000011010) ; 6    エクスクラメーション
      ; "were" と競合するため、"(" ")" の wholeWord は宣言できない。
      (|(|    . #b010000000000000000000000000000000000000000011011) ; 7    左括弧
      (|)|    . #b000100000000000000000000000000000000000000011011) ; 7    右括弧
      (|"|    . #b010000000000000000000000000000000000000000011001) ; 8    ダブルクォート開始
      (|"|    . #b000000000000000000000000000000000000000000001011) ; 0    ダブルクォート終了(結合なし)
      (|"|    . #b001000000000000000000000000000000000000000001011) ; 0    ダブルクォート終了
      (|"|    . #b000100000000000000000000000000000000000000001011) ; 0    ダブルクォート終了
      (|?|    . #b100000000000000000000000000000000000000000011001) ; 8    クエスチョンマーク
      (|?|    . #b001000000000000000000000000000000000000000011001) ; 8    クエスチョンマーク
      (|?|    . #b000100000000000000000000000000000000000000011001) ; 8    クエスチョンマーク
      ; デコード（内部処理）用
      (|`|    . #b000000000000000000000000000000000000000001011001) ; ,8   シングルクォート開始
; 辞書作成（エンコード）時に括弧の外の ' 等は結合なしの語が使用されるため、シングルクォートを結合ありとする。
      (|'|    . #b010000000000000000000000000000000000000001011001) ; ,8   シングルクォート開始
;   (|'|    . #b000000000000000000000000000000000000001011001000) ; 0'   シングルクォート終了(結合なし)
      (|'|    . #b000100000000000000000000000000000000001011001000) ; 0'   シングルクォート終了

; 辞書作成時に括弧の外の ' 等は結合なしの語が使用されるため、シングルクォートでなくアポストロフィーを結合なしとする。
; assoc で シングルクォート開始が優先されるため、brailleEncoder の前処理でシングルクォートより優先させる。
      (|'|    . #b000000000000000000000000000000000000000000001000) ; '    アポストロフィー
      (|'|    . #b001000000000000000000000000000000000000000001000) ; '    アポストロフィー
      (|... | . #b000000000000000000000000010011010011010011000000) ; ..._ ...
      (/      . #b000000000000000000000000000000000000000000001100) ; /    斜線
; エンコードで不具合がある為、、暫定的に phonemic bracket 使用を停止する。
#|
      ([      . #b010000000000000000000000000000000000000110011011) ; ^7   open phonemic bracket
      (]      . #b000100000000000000000000000000000000000000000110) ; ^    close phonemic bracket
|#
      (|< |   . #b100000000000000000000000000000000111011011000000) ; _7_  左角括弧
      (<      . #b010000000000000000000000000000000000000111011011) ; _7   左角括弧
      (|> |   . #b100000000000000000000000000000000111011011000000) ; _7_  右角括弧
      (>      . #b000100000000000000000000000000000000000111011011) ; _7   右角括弧
      (|{ |   . #b100000000000000000000000000000000101011011000000) ; .7_  左大括弧
      ({      . #b010000000000000000000000000000000000000101011011) ; .7   左大括弧
      (|} |   . #b100000000000000000000000000000000101011011000000) ; .7_  右大括弧
      (}      . #b000100000000000000000000000000000000000101011011) ; .7   右大括弧
      ; "were" と競合するため、"[" の wholeWord は宣言できない。
      ([      . #b010000000000000000000000000000000000000001011011) ; ,7   左カギ括弧
      (|] |   . #b100000000000000000000000000000011011001000000000) ; 7'_  右カギ括弧
      (]      . #b000100000000000000000000000000000000011011001000) ; 7'   右カギ括弧
; エンコード時エンコードで不具合がある為、暫定的に、inverted comma の使用を停止する。
#|
      (|'|    . #b010000000000000000000000000000000000000001011001) ; ,8   open single inverted comma
      (|'|    . #b000100000000000000000000000000000000010110001000) ; j'   close single inverted comma
|#
;      ($      . #b000000000000000000000000000000000000000000110101) ; $    ダラーサイン
      ($      . #b010000000000000000000000000000000000010011001111) ; 4#   ダラーサイン
      (%      . #b000000000000000000000000000000000000000000100101) ; %    パーセント
      (*      . #b000000000000000000000000000000000000001010001010) ; 99   アスタリスク
      (_      . #b000000000000000000000000000000000000000000001001) ; _    アンダースコア
      (~      . #b000000000000000000000000000000000000000000000110) ; ^    チルダ、第2ストレス符
      (|;2|   . #b000000000000000000000000000000000000000011011000) ; ;2   注意書き
      (|--- | . #b000000000000000000001001001001001001001001000000) ; '''_ ロングダッシュ

      (|'''|  . #b100000000000000000000000001000001000001000000000) ; '''  ''' ugly
      (|'''|  . #b000100000000000000000000001000001000001000000000) ; '''  ''' ugly
;
; 本プログラムでは、縦棒はシンボルに付与されたものを取り除いて文字列化している等の理由で使用できない。
; Lisp の性質上やむを得ない。
;      (\|    . #b000000000000000000000000000000000000000000110100) ; f    

      (€      . #b000000000000000000000000000000000000000100100010) ; @e   euro
      (¥      . #b000000000000000000000000000000000000000100101111) ; @y   yen

; アルファベット(グレード1)
      (|a|    . #b000000000000000000000000000000000000000000100000)
      (|b|    . #b000000000000000000000000000000000000000000110000)
      (|c|    . #b000000000000000000000000000000000000000000100100)
      (|d|    . #b000000000000000000000000000000000000000000100110)
      (|e|    . #b000000000000000000000000000000000000000000100010)
      (|f|    . #b000000000000000000000000000000000000000000110100)
      (|g|    . #b000000000000000000000000000000000000000000110110)
      (|h|    . #b000000000000000000000000000000000000000000110010)
      (|i|    . #b000000000000000000000000000000000000000000010100)
      (|j|    . #b000000000000000000000000000000000000000000010110)
      (|k|    . #b000000000000000000000000000000000000000000101000)
      (|l|    . #b000000000000000000000000000000000000000000111000)
      (|m|    . #b000000000000000000000000000000000000000000101100)
      (|n|    . #b000000000000000000000000000000000000000000101110)
      (|o|    . #b000000000000000000000000000000000000000000101010)
      (|p|    . #b000000000000000000000000000000000000000000111100)
      (|q|    . #b000000000000000000000000000000000000000000111110)
      (|r|    . #b000000000000000000000000000000000000000000111010)
      (|s|    . #b000000000000000000000000000000000000000000011100)
      (|t|    . #b000000000000000000000000000000000000000000011110)
      (|u|    . #b000000000000000000000000000000000000000000101001)
      (|v|    . #b000000000000000000000000000000000000000000111001)
      (|w|    . #b000000000000000000000000000000000000000000010111)
      (|x|    . #b000000000000000000000000000000000000000000101101)
      (|y|    . #b000000000000000000000000000000000000000000101111)
      (|z|    . #b000000000000000000000000000000000000000000101011)
      (A      . #b000000000000000000000000000000000000000000100000)
      (B      . #b000000000000000000000000000000000000000000110000)
      (C      . #b000000000000000000000000000000000000000000100100)
      (D      . #b000000000000000000000000000000000000000000100110)
      (E      . #b000000000000000000000000000000000000000000100010)
      (F      . #b000000000000000000000000000000000000000000110100)
      (G      . #b000000000000000000000000000000000000000000110110)
      (H      . #b000000000000000000000000000000000000000000110010)
      (I      . #b000000000000000000000000000000000000000000010100)
      (J      . #b000000000000000000000000000000000000000000010110)
      (K      . #b000000000000000000000000000000000000000000101000)
      (L      . #b000000000000000000000000000000000000000000111000)
      (M      . #b000000000000000000000000000000000000000000101100)
      (N      . #b000000000000000000000000000000000000000000101110)
      (O      . #b000000000000000000000000000000000000000000101010)
      (P      . #b000000000000000000000000000000000000000000111100)
      (Q      . #b000000000000000000000000000000000000000000111110)
      (R      . #b000000000000000000000000000000000000000000111010)
      (S      . #b000000000000000000000000000000000000000000011100)
      (T      . #b000000000000000000000000000000000000000000011110)
      (U      . #b000000000000000000000000000000000000000000101001)
      (V      . #b000000000000000000000000000000000000000000111001)
      (W      . #b000000000000000000000000000000000000000000010111)
      (X      . #b000000000000000000000000000000000000000000101101)
      (Y      . #b000000000000000000000000000000000000000000101111)
      (Z      . #b000000000000000000000000000000000000000000101011)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 【whole word について】
;
; WW1. 不定詞・前置詞・接続詞のように分割・結合の操作をする可能性がある場合は、
;     「空白を従える whole word」を具備する必要がある。
;      eg. (and for of the with to)
;
; WW2. whole word の点字コードで文末に来る可能性がある場合は、".,?!):" を従えるため、
;     「空白を従えない whole word」にする必要がある。
;      eg. l8 → like?
;
; WW3. バッティングを回避するため、「空白を従えない whole word」「空白を従える whole word」
;      を適宜使い分ける必要がある。
;      eg. (his ←→ ")
;
;===============================================================================
; 【注意】このままでは、以下のバグが残存するため、暫定的に【縮語】にて直接期待値を宣言する。
;        WW1 に従う whole word である "to " は、文末に配置しても正しく処理されない。
;        文末への配置を可能にするため、空白を従えない "to" を具備しても、"to" に続く語は
;        一旦独立したものとして扱われるため、点字 "68" は "to?" ではなく "tohis" となる。
;        他にも "and"[&] "for"[=] "of"[(] "with"[)] "to"[6] に続く
;        ","[1] "?"[8] "!"[6] ")"[7] は適切に出力されない。
;-------------------------------------------------------------------------------
;        eg. 点字    期待値     実際の結果
;             &1     "and,"     "and"      カンマが末端結合の場合、正しく変換されない。
;             =8     "for?"     "forhis "
;             (8     "of?"      "ofhis "
;             )8     "with?"    "withhis "
;             68     "to?"      "tohis "
;
; 【エンコード対応】
;                eg. "for his" --> "= 8"
;                wordList2String が参照する *prefer-divide-list* に含まれない for に
;                連なる語は連結を禁止している。
;
; 【デコード対応】
;                eg. "=8" --> "for?"
;                *us_grade2* にて |for?| を宣言している。
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; *Grade2-1【1マス略語】
; One-Cell Whole-Word Signs
; 1st Line
; a-z 1文字のは容易に変な結合をするので、Whole-Word 以外あり得ない。
;
      (|but|         . #b100000000000000000000000000000000000000000110000) ; b   (03.01.01 SIMPLE UPPER WORDSIGNS)
      (|can|         . #b100000000000000000000000000000000000000000100100) ; c   (03.01.02 SIMPLE UPPER WORDSIGNS)
      (|do|          . #b100000000000000000000000000000000000000000100110) ; d   (03.01.03 SIMPLE UPPER WORDSIGNS)
      (|every|       . #b100000000000000000000000000000000000000000100010) ; e   (03.01.04 SIMPLE UPPER WORDSIGNS)
      (|from|        . #b100000000000000000000000000000000000000000110100) ; f   (03.01.05 SIMPLE UPPER WORDSIGNS)
      (|go|          . #b100000000000000000000000000000000000000000110110) ; g   (03.01.06 SIMPLE UPPER WORDSIGNS)
      (|have|        . #b100000000000000000000000000000000000000000110010) ; h   (03.01.07 SIMPLE UPPER WORDSIGNS)
      (|just|        . #b100000000000000000000000000000000000000000010110) ; j   (03.01.08 SIMPLE UPPER WORDSIGNS)
; 2nd Line
      (|knowledge|   . #b100000000000000000000000000000000000000000101000) ; k   (03.01.09 SIMPLE UPPER WORDSIGNS)
      (|like|        . #b100000000000000000000000000000000000000000111000) ; l   (03.01.10 SIMPLE UPPER WORDSIGNS)
      (|more|        . #b100000000000000000000000000000000000000000101100) ; m   (03.01.11 SIMPLE UPPER WORDSIGNS)
      (|not|         . #b100000000000000000000000000000000000000000101110) ; n   (03.01.12 SIMPLE UPPER WORDSIGNS)
      (|people|      . #b100000000000000000000000000000000000000000111100) ; p   (03.01.13 SIMPLE UPPER WORDSIGNS)
; Q. を正しく処理するため、空白を従える whole word のみにする。Mar 20, 2007
      (|quite |      . #b100000000000000000000000000000000000111110000000) ; q_  (03.01.14 SIMPLE UPPER WORDSIGNS)
      (|rather|      . #b100000000000000000000000000000000000000000111010) ; r   (03.01.15 SIMPLE UPPER WORDSIGNS)
      (|so|          . #b100000000000000000000000000000000000000000011100) ; s   (03.01.16 SIMPLE UPPER WORDSIGNS)
      (|that|        . #b100000000000000000000000000000000000000000011110) ; t   (03.01.17 SIMPLE UPPER WORDSIGNS)
; 3rd Line
      (|us|          . #b100000000000000000000000000000000000000000101001) ; u   (03.01.18 SIMPLE UPPER WORDSIGNS)
      (|very|        . #b100000000000000000000000000000000000000000111001) ; v   (03.01.19 SIMPLE UPPER WORDSIGNS)
      (|will|        . #b100000000000000000000000000000000000000000010111) ; w   (03.01.20 SIMPLE UPPER WORDSIGNS)
      (|it|          . #b100000000000000000000000000000000000000000101101) ; x   (03.01.21 SIMPLE UPPER WORDSIGNS)
      (|you|         . #b100000000000000000000000000000000000000000101111) ; y   (03.01.22 SIMPLE UPPER WORDSIGNS)
      (|as|          . #b100000000000000000000000000000000000000000101011) ; z   (03.01.23 SIMPLE UPPER WORDSIGNS)
; 4th Line
      (|child|       . #b100000000000000000000000000000000000000000100001) ; *   (03.01.24 SIMPLE UPPER WORDSIGNS)
      (|shall|       . #b100000000000000000000000000000000000000000100101) ; %   (03.01.25 SIMPLE UPPER WORDSIGNS)
      (|this|        . #b100000000000000000000000000000000000000000100111) ; ?   (03.01.26 SIMPLE UPPER WORDSIGNS)
      (|which|       . #b100000000000000000000000000000000000000000100011) ; |:| (03.01.27 SIMPLE UPPER WORDSIGNS)
      (|out|         . #b100000000000000000000000000000000000000000110011) ; ¥   (03.01.28 SIMPLE UPPER WORDSIGNS)
; 6th Line
      (|still|       . #b100000000000000000000000000000000000000000001100) ; /   (03.01.29 SIMPLE UPPER WORDSIGNS)

      ; The signs for (and, for, of, the, with) may be used also as wordsigns.
      (|and|         . #b100000000000000000000000000000000000000000111101) ; &   (03.02.01 SIMPLE UPPER GROUPSIGNS) cf.WW2
      (|and|         . #b010000000000000000000000000000000000000000111101) ; &   (03.02.01 SIMPLE UPPER GROUPSIGNS)
      (|and|         . #b001000000000000000000000000000000000000000111101) ; &   (03.02.01 SIMPLE UPPER GROUPSIGNS)
      (|and|         . #b000100000000000000000000000000000000000000111101) ; &   (03.02.01 SIMPLE UPPER GROUPSIGNS)
      (|for|         . #b100000000000000000000000000000000000000000111111) ; =   (03.02.02 SIMPLE UPPER GROUPSIGNS) cf.WW2
      (|for|         . #b010000000000000000000000000000000000000000111111) ; =   (03.02.02 SIMPLE UPPER GROUPSIGNS)
      (|for|         . #b001000000000000000000000000000000000000000111111) ; =   (03.02.02 SIMPLE UPPER GROUPSIGNS)
      (|for|         . #b000100000000000000000000000000000000000000111111) ; =   (03.02.02 SIMPLE UPPER GROUPSIGNS)
      (|of|          . #b100000000000000000000000000000000000000000111011) ; |(| (03.02.03 SIMPLE UPPER GROUPSIGNS) cf.WW2
      (|of|          . #b010000000000000000000000000000000000000000111011) ; |(| (03.02.03 SIMPLE UPPER GROUPSIGNS)
      (|of|          . #b001000000000000000000000000000000000000000111011) ; |(| (03.02.03 SIMPLE UPPER GROUPSIGNS)
      (|of|          . #b000100000000000000000000000000000000000000111011) ; |(| (03.02.03 SIMPLE UPPER GROUPSIGNS)
      (|the|         . #b100000000000000000000000000000000000000000011101) ; !   (03.02.04 SIMPLE UPPER GROUPSIGNS) cf.WW1
      (|the|         . #b010000000000000000000000000000000000000000011101) ; !   (03.02.04 SIMPLE UPPER GROUPSIGNS)
      (|the|         . #b001000000000000000000000000000000000000000011101) ; !   (03.02.04 SIMPLE UPPER GROUPSIGNS)
      (|the|         . #b000100000000000000000000000000000000000000011101) ; !   (03.02.04 SIMPLE UPPER GROUPSIGNS)
      (|with|        . #b100000000000000000000000000000000000000000011111) ; |)| (03.02.05 SIMPLE UPPER GROUPSIGNS) cf.WW2
      (|with|        . #b010000000000000000000000000000000000000000011111) ; |)| (03.02.05 SIMPLE UPPER GROUPSIGNS)
      (|with|        . #b001000000000000000000000000000000000000000011111) ; |)| (03.02.05 SIMPLE UPPER GROUPSIGNS)
      (|with|        . #b000100000000000000000000000000000000000000011111) ; |)| (03.02.05 SIMPLE UPPER GROUPSIGNS)

; *Grade2-2【1マス略字】
; One-Cell Whole-Word and Part-Word Signs
; 3rd Line
#|
;;;   (|and|         . #b000000000000000000000000000000000000000000111101) ; &
;;;   (|for|         . #b000000000000000000000000000000000000000000111111) ; =
;;;   (|of|          . #b000000000000000000000000000000000000000000111011) ; |(|
;;;   (|the|         . #b000000000000000000000000000000000000000000011101) ; !
;;;   (|with|        . #b000000000000000000000000000000000000000000011111) ; |)|
|#
; 4th Line
      (|ch|          . #b010000000000000000000000000000000000000000100001) ; *   (03.02.07 SIMPLE UPPER WORDSIGNS)
      (|ch|          . #b001000000000000000000000000000000000000000100001) ; *   (03.02.07 SIMPLE UPPER WORDSIGNS)
      (|ch|          . #b000100000000000000000000000000000000000000100001) ; *   (03.02.07 SIMPLE UPPER WORDSIGNS)
      (|gh|          . #b010000000000000000000000000000000000000000110001) ; <   (03.02.08 SIMPLE UPPER WORDSIGNS)
      (|gh|          . #b001000000000000000000000000000000000000000110001) ; <   (03.02.08 SIMPLE UPPER WORDSIGNS)
      (|gh|          . #b000100000000000000000000000000000000000000110001) ; <   (03.02.08 SIMPLE UPPER WORDSIGNS)
      (|sh|          . #b010000000000000000000000000000000000000000100101) ; %   (03.02.09 SIMPLE UPPER WORDSIGNS)
      (|sh|          . #b001000000000000000000000000000000000000000100101) ; %   (03.02.09 SIMPLE UPPER WORDSIGNS)
      (|sh|          . #b000100000000000000000000000000000000000000100101) ; %   (03.02.09 SIMPLE UPPER WORDSIGNS)
      (|th|          . #b010000000000000000000000000000000000000000100111) ; ?   (03.02.10 SIMPLE UPPER WORDSIGNS)
      (|th|          . #b001000000000000000000000000000000000000000100111) ; ?   (03.02.10 SIMPLE UPPER WORDSIGNS)
      (|th|          . #b000100000000000000000000000000000000000000100111) ; ?   (03.02.10 SIMPLE UPPER WORDSIGNS)
      (|wh|          . #b010000000000000000000000000000000000000000100011) ; |:| (03.02.11 SIMPLE UPPER WORDSIGNS)
      (|wh|          . #b001000000000000000000000000000000000000000100011) ; |:| (03.02.11 SIMPLE UPPER WORDSIGNS)
      (|wh|          . #b000100000000000000000000000000000000000000100011) ; |:| (03.02.11 SIMPLE UPPER WORDSIGNS)
      ; ハイフォネートされた場合（-ed）を処理するために追加した。
      (|ed|          . #b100000000000000000000000000000000000000000110101) ; $   (03.02.12 SIMPLE UPPER WORDSIGNS)
      (|ed|          . #b010000000000000000000000000000000000000000110101) ; $   (03.02.12 SIMPLE UPPER WORDSIGNS)
      (|ed|          . #b001000000000000000000000000000000000000000110101) ; $   (03.02.12 SIMPLE UPPER WORDSIGNS)
      (|ed|          . #b000100000000000000000000000000000000000000110101) ; $   (03.02.12 SIMPLE UPPER WORDSIGNS)
      ; us_ignoreableLeft にアポストロフィーを追加した結果 '] → 'er になるよう、追加した。
      (|er|          . #b100000000000000000000000000000000000000000110111) ; ]   (03.02.13 SIMPLE UPPER WORDSIGNS)
      (|er|          . #b010000000000000000000000000000000000000000110111) ; ]   (03.02.13 SIMPLE UPPER WORDSIGNS)
      (|er|          . #b001000000000000000000000000000000000000000110111) ; ]   (03.02.13 SIMPLE UPPER WORDSIGNS)
      (|er|          . #b000100000000000000000000000000000000000000110111) ; ]   (03.02.13 SIMPLE UPPER WORDSIGNS)
      (|ou|          . #b010000000000000000000000000000000000000000110011) ; ¥   (03.02.14 SIMPLE UPPER WORDSIGNS)
      (|ou|          . #b001000000000000000000000000000000000000000110011) ; ¥   (03.02.14 SIMPLE UPPER WORDSIGNS)
      (|ou|          . #b000100000000000000000000000000000000000000110011) ; ¥   (03.02.14 SIMPLE UPPER WORDSIGNS)
      (|ow|          . #b010000000000000000000000000000000000000000010101) ; [   (03.02.15 SIMPLE UPPER WORDSIGNS)
      (|ow|          . #b001000000000000000000000000000000000000000010101) ; [   (03.02.15 SIMPLE UPPER WORDSIGNS)
      (|ow|          . #b000100000000000000000000000000000000000000010101) ; [   (03.02.15 SIMPLE UPPER WORDSIGNS)
; 6th Line
      (|st|          . #b010000000000000000000000000000000000000000001100) ; /   (03.02.16 SIMPLE UPPER WORDSIGNS)
      (|st|          . #b001000000000000000000000000000000000000000001100) ; /   (03.02.16 SIMPLE UPPER WORDSIGNS)
      (|st|          . #b000100000000000000000000000000000000000000001100) ; /   (03.02.16 SIMPLE UPPER WORDSIGNS)
      (|ing|         . #b001000000000000000000000000000000000000000001101) ; +   (03.02.17 SIMPLE UPPER WORDSIGNS)
      (|ing|         . #b000100000000000000000000000000000000000000001101) ; +   (03.02.17 SIMPLE UPPER WORDSIGNS)
      (|ble|         . #b001000000000000000000000000000000000000000001111) ; |#| (03.02.18 SIMPLE UPPER WORDSIGNS)
      (|ble|         . #b000100000000000000000000000000000000000000001111) ; |#| (03.02.18 SIMPLE UPPER WORDSIGNS)
      (|ar|          . #b010000000000000000000000000000000000000000001110) ; >   (03.02.06 SIMPLE UPPER WORDSIGNS)
      (|ar|          . #b001000000000000000000000000000000000000000001110) ; >   (03.02.06 SIMPLE UPPER WORDSIGNS)
      (|ar|          . #b000100000000000000000000000000000000000000001110) ; >   (03.02.06 SIMPLE UPPER WORDSIGNS)

; *Grade2-3【低下略字】
; Low Sign Part-Word
; 5th Line
      (|ea|          . #b001000000000000000000000000000000000000000010000) ; 1   (03.03.14 Medial Groupsigns)
      (|bb|          . #b001000000000000000000000000000000000000000011000) ; 2   (03.03.15 Medial Groupsigns)
      (|be|          . #b010000000000000000000000000000000000000000011000) ; 2   (03.03.08 Initial Groupsigns)
      (|cc|          . #b001000000000000000000000000000000000000000010010) ; 3   (03.03.16 Medial Groupsigns)
      (|con|         . #b010000000000000000000000000000000000000000010010) ; 3   (03.03.09 Initial Groupsigns)
      (|dd|          . #b001000000000000000000000000000000000000000010011) ; 4   (03.03.17 Medial Groupsigns)
      (|dis|         . #b010000000000000000000000000000000000000000010011) ; 4   (03.03.10 Initial Groupsigns)
      (|en|          . #b010000000000000000000000000000000000000000010001) ; 5   (03.03.12 Initial-Medial-Terminal Groupsigns)
      (|en|          . #b001000000000000000000000000000000000000000010001) ; 5   (03.03.12 Initial-Medial-Terminal Groupsigns)
      (|en|          . #b000100000000000000000000000000000000000000010001) ; 5   (03.03.12 Initial-Medial-Terminal Groupsigns)
      (|ff|          . #b001000000000000000000000000000000000000000011010) ; 6   (03.03.18 Medial Groupsigns)
      (|gg|          . #b001000000000000000000000000000000000000000011011) ; 7   (03.03.19 Medial Groupsigns)
      (|in|          . #b010000000000000000000000000000000000000000001010) ; 9   (03.03.13 Initial-Medial-Terminal Groupsigns)
      (|in|          . #b001000000000000000000000000000000000000000001010) ; 9   (03.03.13 Initial-Medial-Terminal Groupsigns)
      (|in|          . #b000100000000000000000000000000000000000000001010) ; 9   (03.03.13 Initial-Medial-Terminal Groupsigns)
; 6th Line
      (|com|         . #b010000000000000000000000000000000000000000001001) ; -   (03.03.11 Initial Groupsigns)

; Grade2-4【低下略語】
; Low Sign Whole-Word
; 5th Line
      (|be|          . #b100000000000000000000000000000000000000000011000) ; 2   (03.03.08)
      (|enough|      . #b100000000000000000000000000000000000000000010001) ; 5   (03.03.01 Wordsigns)
      (|to|          . #b100000000000000000000000000000000000000000011010) ; 6   (03.03.02 Wordsigns) cf.WW2
      (|to|          . #b010000000000000000000000000000000000000000011010) ; 6   (03.03.02 Wordsigns sequenced)
      (|were|        . #b100000000000000000000000000000000000000000011011) ; 7   (03.03.03 Wordsigns)
;      (|Were|        . #b100000000000000000000000000000000000000001011011) ; ,7  (03.03.03 Wordsigns)
      ; " と区別するため、空白を従えた whole word にする。
      (|his |        . #b100000000000000000000000000000000000011001000000) ; 8_  (03.03.04 Wordsigns) cf.WW3
      ; |`| ,8 に先んじるための宣言している。大文字符を内在させている。
      (|His |        . #b100010000000000000000000000000000001011001000000) ; ,8_ (03.03.04 Wordsigns) cf.WW3
      (|in|          . #b100000000000000000000000000000000000000000001010) ; 9   (03.03.13 Initial-Medial-Terminal Groupsigns)

      (|was |        . #b100000000000000000000000000000000000001011000000) ; 0_   (03.03.07 Wordsigns)
      (|by|          . #b100000000000000000000000000000000000000000001011) ; 0   (03.03.06 Wordsigns)
#|
      (|was|         . #b100000000000000000000000000000000000000000001011) ; 0   (03.03.07 Wordsigns)
;      (|by|          . #b100000000000000000000000000000000000000000001011) ; 0   (03.03.06 Wordsigns)
|#

      (|by|          . #b010000000000000000000000000000000000000000001011) ; 0   (03.03.06 Wordsigns sequenced)
;      (|by|          . #b001000000000000000000000000000000000000000001011) ; 0   (03.03.06 Wordsigns)
; 6th Line
      (|into|        . #b100000000000000000000000000000000000001010011010) ; 96  (03.03.05 Wordsigns) cf.WW2
      (|into|        . #b010000000000000000000000000000000000001010011010) ; 96  (03.03.05 Wordsigns sequenced)

; * Grade2-5【頭字略字】
; Two-Cell Contractions(Dots 5)
; 頭字略字 These wordsigns may be used as parts of words.
      (|day|         . #b100000000000000000000000000000000000000010100110) ; "d  (03.04.12 COMPOSITE WORDSIGNS)
      (|day|         . #b010000000000000000000000000000000000000010100110) ; "d  (03.04.12 COMPOSITE WORDSIGNS)
      (|day|         . #b001000000000000000000000000000000000000010100110) ; "d  (03.04.12 COMPOSITE WORDSIGNS)
      (|day|         . #b000100000000000000000000000000000000000010100110) ; "d  (03.04.12 COMPOSITE WORDSIGNS)
      (|right|       . #b100000000000000000000000000000000000000010111010) ; "r  (03.04.13 COMPOSITE WORDSIGNS)
      (|right|       . #b010000000000000000000000000000000000000010111010) ; "r  (03.04.13 COMPOSITE WORDSIGNS)
      (|right|       . #b001000000000000000000000000000000000000010111010) ; "r  (03.04.13 COMPOSITE WORDSIGNS)
      (|right|       . #b000100000000000000000000000000000000000010111010) ; "r  (03.04.13 COMPOSITE WORDSIGNS)
      (|ever|        . #b100000000000000000000000000000000000000010100010) ; "e  (03.04.14 COMPOSITE WORDSIGNS)
      (|ever|        . #b010000000000000000000000000000000000000010100010) ; "e  (03.04.14 COMPOSITE WORDSIGNS)
      (|ever|        . #b001000000000000000000000000000000000000010100010) ; "e  (03.04.14 COMPOSITE WORDSIGNS)
      (|ever|        . #b000100000000000000000000000000000000000010100010) ; "e  (03.04.14 COMPOSITE WORDSIGNS)
      (|some|        . #b100000000000000000000000000000000000000010011100) ; "s  (03.04.15 COMPOSITE WORDSIGNS)
      (|some|        . #b010000000000000000000000000000000000000010011100) ; "s  (03.04.15 COMPOSITE WORDSIGNS)
      (|some|        . #b001000000000000000000000000000000000000010011100) ; "s  (03.04.15 COMPOSITE WORDSIGNS)
      (|some|        . #b000100000000000000000000000000000000000010011100) ; "s  (03.04.15 COMPOSITE WORDSIGNS)
      (|father|      . #b100000000000000000000000000000000000000010110100) ; "f  (03.04.16 COMPOSITE WORDSIGNS)
      (|father|      . #b010000000000000000000000000000000000000010110100) ; "f  (03.04.16 COMPOSITE WORDSIGNS)
      (|father|      . #b001000000000000000000000000000000000000010110100) ; "f  (03.04.16 COMPOSITE WORDSIGNS)
      (|father|      . #b000100000000000000000000000000000000000010110100) ; "f  (03.04.16 COMPOSITE WORDSIGNS)
      (|time|        . #b100000000000000000000000000000000000000010011110) ; "t  (03.04.17 COMPOSITE WORDSIGNS)
      (|time|        . #b010000000000000000000000000000000000000010011110) ; "t  (03.04.17 COMPOSITE WORDSIGNS)
      (|time|        . #b001000000000000000000000000000000000000010011110) ; "t  (03.04.17 COMPOSITE WORDSIGNS)
      (|time|        . #b000100000000000000000000000000000000000010011110) ; "t  (03.04.17 COMPOSITE WORDSIGNS)
      (|here|        . #b100000000000000000000000000000000000000010110010) ; "h  (03.04.18 COMPOSITE WORDSIGNS)
      (|here|        . #b010000000000000000000000000000000000000010110010) ; "h  (03.04.18 COMPOSITE WORDSIGNS)
      (|here|        . #b001000000000000000000000000000000000000010110010) ; "h  (03.04.18 COMPOSITE WORDSIGNS)
      (|here|        . #b000100000000000000000000000000000000000010110010) ; "h  (03.04.18 COMPOSITE WORDSIGNS)
      (|under|       . #b100000000000000000000000000000000000000010101001) ; "u  (03.04.19 COMPOSITE WORDSIGNS)
      (|under|       . #b010000000000000000000000000000000000000010101001) ; "u  (03.04.19 COMPOSITE WORDSIGNS)
      (|under|       . #b001000000000000000000000000000000000000010101001) ; "u  (03.04.19 COMPOSITE WORDSIGNS)
      (|under|       . #b000100000000000000000000000000000000000010101001) ; "u  (03.04.19 COMPOSITE WORDSIGNS)
      (|know|        . #b100000000000000000000000000000000000000010101000) ; "k  (03.04.20 COMPOSITE WORDSIGNS)
      (|know|        . #b010000000000000000000000000000000000000010101000) ; "k  (03.04.20 COMPOSITE WORDSIGNS)
      (|know|        . #b001000000000000000000000000000000000000010101000) ; "k  (03.04.20 COMPOSITE WORDSIGNS)
      (|know|        . #b000100000000000000000000000000000000000010101000) ; "k  (03.04.20 COMPOSITE WORDSIGNS)
      (|work|        . #b100000000000000000000000000000000000000010010111) ; "w  (03.04.21 COMPOSITE WORDSIGNS)
      (|work|        . #b010000000000000000000000000000000000000010010111) ; "w  (03.04.21 COMPOSITE WORDSIGNS)
      (|work|        . #b001000000000000000000000000000000000000010010111) ; "w  (03.04.21 COMPOSITE WORDSIGNS)
      (|work|        . #b000100000000000000000000000000000000000010010111) ; "w  (03.04.21 COMPOSITE WORDSIGNS)
      (|lord|        . #b100000000000000000000000000000000000000010111000) ; "l  (03.04.22 COMPOSITE WORDSIGNS)
      (|lord|        . #b010000000000000000000000000000000000000010111000) ; "l  (03.04.22 COMPOSITE WORDSIGNS)
      (|lord|        . #b001000000000000000000000000000000000000010111000) ; "l  (03.04.22 COMPOSITE WORDSIGNS)
      (|lord|        . #b000100000000000000000000000000000000000010111000) ; "l  (03.04.22 COMPOSITE WORDSIGNS)
      (|young|       . #b100000000000000000000000000000000000000010101111) ; "y  (03.04.23 COMPOSITE WORDSIGNS)
      (|young|       . #b010000000000000000000000000000000000000010101111) ; "y  (03.04.23 COMPOSITE WORDSIGNS)
      (|young|       . #b001000000000000000000000000000000000000010101111) ; "y  (03.04.23 COMPOSITE WORDSIGNS)
      (|young|       . #b000100000000000000000000000000000000000010101111) ; "y  (03.04.23 COMPOSITE WORDSIGNS)
      (|mother|      . #b100000000000000000000000000000000000000010101100) ; "m  (03.04.24 COMPOSITE WORDSIGNS)
      (|mother|      . #b010000000000000000000000000000000000000010101100) ; "m  (03.04.24 COMPOSITE WORDSIGNS)
      (|mother|      . #b001000000000000000000000000000000000000010101100) ; "m  (03.04.24 COMPOSITE WORDSIGNS)
      (|mother|      . #b000100000000000000000000000000000000000010101100) ; "m  (03.04.24 COMPOSITE WORDSIGNS)
      (|there|       . #b100000000000000000000000000000000000000010011101) ; "!  (03.04.25 COMPOSITE WORDSIGNS)
      (|there|       . #b010000000000000000000000000000000000000010011101) ; "!  (03.04.25 COMPOSITE WORDSIGNS)
      (|there|       . #b001000000000000000000000000000000000000010011101) ; "!  (03.04.25 COMPOSITE WORDSIGNS)
      (|there|       . #b000100000000000000000000000000000000000010011101) ; "!  (03.04.25 COMPOSITE WORDSIGNS)
      (|name|        . #b100000000000000000000000000000000000000010101110) ; "n  (03.04.26 COMPOSITE WORDSIGNS)
      (|name|        . #b010000000000000000000000000000000000000010101110) ; "n  (03.04.26 COMPOSITE WORDSIGNS)
      (|name|        . #b001000000000000000000000000000000000000010101110) ; "n  (03.04.26 COMPOSITE WORDSIGNS)
      (|name|        . #b000100000000000000000000000000000000000010101110) ; "n  (03.04.26 COMPOSITE WORDSIGNS)
      (|character|   . #b100000000000000000000000000000000000000010100001) ; "*  (03.04.27 COMPOSITE WORDSIGNS)
      (|character|   . #b010000000000000000000000000000000000000010100001) ; "*  (03.04.27 COMPOSITE WORDSIGNS)
      (|character|   . #b001000000000000000000000000000000000000010100001) ; "*  (03.04.27 COMPOSITE WORDSIGNS)
      (|character|   . #b000100000000000000000000000000000000000010100001) ; "*  (03.04.27 COMPOSITE WORDSIGNS)
      (|one|         . #b100000000000000000000000000000000000000010101010) ; "o  (03.04.28 COMPOSITE WORDSIGNS)
      (|one|         . #b010000000000000000000000000000000000000010101010) ; "o  (03.04.28 COMPOSITE WORDSIGNS)
      (|one|         . #b001000000000000000000000000000000000000010101010) ; "o  (03.04.28 COMPOSITE WORDSIGNS)
      (|one|         . #b000100000000000000000000000000000000000010101010) ; "o  (03.04.28 COMPOSITE WORDSIGNS)
      (|through|     . #b100000000000000000000000000000000000000010100111) ; "?  (03.04.29 COMPOSITE WORDSIGNS)
      (|through|     . #b010000000000000000000000000000000000000010100111) ; "?  (03.04.29 COMPOSITE WORDSIGNS)
      (|through|     . #b001000000000000000000000000000000000000010100111) ; "?  (03.04.29 COMPOSITE WORDSIGNS)
      (|through|     . #b000100000000000000000000000000000000000010100111) ; "?  (03.04.29 COMPOSITE WORDSIGNS)
      (|part|        . #b100000000000000000000000000000000000000010111100) ; "p  (03.04.30 COMPOSITE WORDSIGNS)
      (|part|        . #b010000000000000000000000000000000000000010111100) ; "p  (03.04.30 COMPOSITE WORDSIGNS)
      (|part|        . #b001000000000000000000000000000000000000010111100) ; "p  (03.04.30 COMPOSITE WORDSIGNS)
      (|part|        . #b000100000000000000000000000000000000000010111100) ; "p  (03.04.30 COMPOSITE WORDSIGNS)
      (|where|       . #b100000000000000000000000000000000000000010100011) ; ":  (03.04.31 COMPOSITE WORDSIGNS)
      (|where|       . #b010000000000000000000000000000000000000010100011) ; ":  (03.04.31 COMPOSITE WORDSIGNS)
      (|where|       . #b001000000000000000000000000000000000000010100011) ; ":  (03.04.31 COMPOSITE WORDSIGNS)
      (|where|       . #b000100000000000000000000000000000000000010100011) ; ":  (03.04.31 COMPOSITE WORDSIGNS)
      (|question|    . #b100000000000000000000000000000000000000010111110) ; "q  (03.04.32 COMPOSITE WORDSIGNS)
      (|question|    . #b010000000000000000000000000000000000000010111110) ; "q  (03.04.32 COMPOSITE WORDSIGNS)
      (|question|    . #b001000000000000000000000000000000000000010111110) ; "q  (03.04.32 COMPOSITE WORDSIGNS)
      (|question|    . #b000100000000000000000000000000000000000010111110) ; "q  (03.04.32 COMPOSITE WORDSIGNS)
      (|ought|       . #b100000000000000000000000000000000000000010110011) ; "¥  (03.04.33 COMPOSITE WORDSIGNS)
      (|ought|       . #b010000000000000000000000000000000000000010110011) ; "¥  (03.04.33 COMPOSITE WORDSIGNS)
      (|ought|       . #b001000000000000000000000000000000000000010110011) ; "¥  (03.04.33 COMPOSITE WORDSIGNS)
      (|ought|       . #b000100000000000000000000000000000000000010110011) ; "¥  (03.04.33 COMPOSITE WORDSIGNS)
      (|upon|        . #b100000000000000000000000000000000000000110101001) ; ^u  (03.04.01 COMPOSITE WORDSIGNS)
      (|upon|        . #b010000000000000000000000000000000000000110101001) ; ^u  (03.04.01 COMPOSITE WORDSIGNS)
      (|upon|        . #b001000000000000000000000000000000000000110101001) ; ^u  (03.04.01 COMPOSITE WORDSIGNS)
      (|upon|        . #b000100000000000000000000000000000000000110101001) ; ^u  (03.04.01 COMPOSITE WORDSIGNS)
      (|cannot|      . #b100000000000000000000000000000000000000111100100) ; _c  (03.04.02 COMPOSITE WORDSIGNS)
      (|cannot|      . #b010000000000000000000000000000000000000111100100) ; _c  (03.04.02 COMPOSITE WORDSIGNS)
      (|cannot|      . #b001000000000000000000000000000000000000111100100) ; _c  (03.04.02 COMPOSITE WORDSIGNS)
      (|cannot|      . #b000100000000000000000000000000000000000111100100) ; _c  (03.04.02 COMPOSITE WORDSIGNS)
      (|word|        . #b100000000000000000000000000000000000000110010111) ; ^w  (03.04.03 COMPOSITE WORDSIGNS)
      (|word|        . #b010000000000000000000000000000000000000110010111) ; ^w  (03.04.03 COMPOSITE WORDSIGNS)
      (|word|        . #b001000000000000000000000000000000000000110010111) ; ^w  (03.04.03 COMPOSITE WORDSIGNS)
      (|word|        . #b000100000000000000000000000000000000000110010111) ; ^w  (03.04.03 COMPOSITE WORDSIGNS)
      (|had|         . #b100000000000000000000000000000000000000111110010) ; _h  (03.04.04 COMPOSITE WORDSIGNS)
      (|had|         . #b010000000000000000000000000000000000000111110010) ; _h  (03.04.04 COMPOSITE WORDSIGNS)
      (|had|         . #b001000000000000000000000000000000000000111110010) ; _h  (03.04.04 COMPOSITE WORDSIGNS)
      (|had|         . #b000100000000000000000000000000000000000111110010) ; _h  (03.04.04 COMPOSITE WORDSIGNS)
      (|these|       . #b100000000000000000000000000000000000000110011101) ; ^!  (03.04.05 COMPOSITE WORDSIGNS)
      (|these|       . #b010000000000000000000000000000000000000110011101) ; ^!  (03.04.05 COMPOSITE WORDSIGNS)
      (|these|       . #b001000000000000000000000000000000000000110011101) ; ^!  (03.04.05 COMPOSITE WORDSIGNS)
      (|these|       . #b000100000000000000000000000000000000000110011101) ; ^!  (03.04.05 COMPOSITE WORDSIGNS)
      (|many|        . #b100000000000000000000000000000000000000111101100) ; _m  (03.04.06 COMPOSITE WORDSIGNS)
      (|many|        . #b010000000000000000000000000000000000000111101100) ; _m  (03.04.06 COMPOSITE WORDSIGNS)
      (|many|        . #b001000000000000000000000000000000000000111101100) ; _m  (03.04.06 COMPOSITE WORDSIGNS)
      (|many|        . #b000100000000000000000000000000000000000111101100) ; _m  (03.04.06 COMPOSITE WORDSIGNS)
      (|those|       . #b100000000000000000000000000000000000000110100111) ; ^?  (03.04.07 COMPOSITE WORDSIGNS)
      (|those|       . #b010000000000000000000000000000000000000110100111) ; ^?  (03.04.07 COMPOSITE WORDSIGNS)
      (|those|       . #b001000000000000000000000000000000000000110100111) ; ^?  (03.04.07 COMPOSITE WORDSIGNS)
      (|those|       . #b000100000000000000000000000000000000000110100111) ; ^?  (03.04.07 COMPOSITE WORDSIGNS)
      (|spirit|      . #b100000000000000000000000000000000000000111011100) ; _s  (03.04.08 COMPOSITE WORDSIGNS)
      (|spirit|      . #b010000000000000000000000000000000000000111011100) ; _s  (03.04.08 COMPOSITE WORDSIGNS)
      (|spirit|      . #b001000000000000000000000000000000000000111011100) ; _s  (03.04.08 COMPOSITE WORDSIGNS)
      (|spirit|      . #b000100000000000000000000000000000000000111011100) ; _s  (03.04.08 COMPOSITE WORDSIGNS)
      (|whose|       . #b100000000000000000000000000000000000000110100011) ; ^:  (03.04.09 COMPOSITE WORDSIGNS)
      (|whose|       . #b010000000000000000000000000000000000000110100011) ; ^:  (03.04.09 COMPOSITE WORDSIGNS)
      (|whose|       . #b001000000000000000000000000000000000000110100011) ; ^:  (03.04.09 COMPOSITE WORDSIGNS)
      (|whose|       . #b000100000000000000000000000000000000000110100011) ; ^:  (03.04.09 COMPOSITE WORDSIGNS)
      (|world|       . #b100000000000000000000000000000000000000111010111) ; _w  (03.04.10 COMPOSITE WORDSIGNS)
      (|world|       . #b010000000000000000000000000000000000000111010111) ; _w  (03.04.10 COMPOSITE WORDSIGNS)
      (|world|       . #b001000000000000000000000000000000000000111010111) ; _w  (03.04.10 COMPOSITE WORDSIGNS)
      (|world|       . #b000100000000000000000000000000000000000111010111) ; _w  (03.04.10 COMPOSITE WORDSIGNS)
      (|their|       . #b100000000000000000000000000000000000000111011101) ; _!  (03.04.11 COMPOSITE WORDSIGNS)
      (|their|       . #b010000000000000000000000000000000000000111011101) ; _!  (03.04.11 COMPOSITE WORDSIGNS)
      (|their|       . #b001000000000000000000000000000000000000111011101) ; _!  (03.04.11 COMPOSITE WORDSIGNS)
      (|their|       . #b000100000000000000000000000000000000000111011101) ; _!  (03.04.11 COMPOSITE WORDSIGNS)
                        
; Grade2-6【末字略字】
; Two-Cell Contractions(Dots 4-5, 4-5-6)
; 末字略字 These groupsigns may be used only medially and terminally.
      (|ound|        . #b001000000000000000000000000000000000000101100110) ; .d  (03.05.01 COMPOSITE WORDSIGNS)
      (|ound|        . #b000100000000000000000000000000000000000101100110) ; .d  (03.05.01 COMPOSITE WORDSIGNS)
      (|ence|        . #b001000000000000000000000000000000000000011100010) ; ;e  (03.05.02 COMPOSITE WORDSIGNS)
      (|ence|        . #b000100000000000000000000000000000000000011100010) ; ;e  (03.05.02 COMPOSITE WORDSIGNS)
      (|ation|       . #b001000000000000000000000000000000000000001101110) ; ,n  (03.05.03 COMPOSITE WORDSIGNS)
      (|ation|       . #b000100000000000000000000000000000000000001101110) ; ,n  (03.05.03 COMPOSITE WORDSIGNS)
      (|ance|        . #b001000000000000000000000000000000000000101100010) ; .e  (03.05.04 COMPOSITE WORDSIGNS)
      (|ance|        . #b000100000000000000000000000000000000000101100010) ; .e  (03.05.04 COMPOSITE WORDSIGNS)
      (|ong|         . #b001000000000000000000000000000000000000011110110) ; ;g  (03.05.05 COMPOSITE WORDSIGNS)
      (|ong|         . #b000100000000000000000000000000000000000011110110) ; ;g  (03.05.05 COMPOSITE WORDSIGNS)
      (|ally|        . #b001000000000000000000000000000000000000001101111) ; ,y  (03.05.06 COMPOSITE WORDSIGNS)
      (|ally|        . #b000100000000000000000000000000000000000001101111) ; ,y  (03.05.06 COMPOSITE WORDSIGNS)
      (|sion|        . #b001000000000000000000000000000000000000101101110) ; .n  (03.05.07 COMPOSITE WORDSIGNS)
      (|sion|        . #b000100000000000000000000000000000000000101101110) ; .n  (03.05.07 COMPOSITE WORDSIGNS)
      (|ful|         . #b001000000000000000000000000000000000000011111000) ; ;l  (03.05.08 COMPOSITE WORDSIGNS)
      (|ful|         . #b000100000000000000000000000000000000000011111000) ; ;l  (03.05.08 COMPOSITE WORDSIGNS)
      (|less|        . #b001000000000000000000000000000000000000101011100) ; .s  (03.05.09 COMPOSITE WORDSIGNS)
      (|less|        . #b000100000000000000000000000000000000000101011100) ; .s  (03.05.09 COMPOSITE WORDSIGNS)
      (|tion|        . #b001000000000000000000000000000000000000011101110) ; ;n  (03.05.10 COMPOSITE WORDSIGNS)
      (|tion|        . #b000100000000000000000000000000000000000011101110) ; ;n  (03.05.10 COMPOSITE WORDSIGNS)
      (|ount|        . #b001000000000000000000000000000000000000101011110) ; .t  (03.05.11 COMPOSITE WORDSIGNS)
      (|ount|        . #b000100000000000000000000000000000000000101011110) ; .t  (03.05.11 COMPOSITE WORDSIGNS)
      (|ness|        . #b001000000000000000000000000000000000000011011100) ; ;s  (03.05.12 COMPOSITE WORDSIGNS)
      (|ness|        . #b000100000000000000000000000000000000000011011100) ; ;s  (03.05.12 COMPOSITE WORDSIGNS)
      (|ment|        . #b001000000000000000000000000000000000000011011110) ; ;t  (03.05.13 COMPOSITE WORDSIGNS)
      (|ment|        . #b000100000000000000000000000000000000000011011110) ; ;t  (03.05.13 COMPOSITE WORDSIGNS)
      (|ity|         . #b001000000000000000000000000000000000000011101111) ; ;y  (03.05.14 COMPOSITE WORDSIGNS)
      (|ity|         . #b000100000000000000000000000000000000000011101111) ; ;y  (03.05.14 COMPOSITE WORDSIGNS)

; *Grade2-A【縮語】
; Short-Form Words
; 縮語
      (|about|        . #b100000000000000000000000000000000000100000110000) ; ab            (03.06.01 SHORTFORMS)
      (|above|        . #b100000000000000000000000000000100000110000111001) ; abv           (03.06.02 SHORTFORMS)
      (|according|    . #b100000000000000000000000000000000000100000100100) ; ac            (03.06.03 SHORTFORMS)
; 先頭結合は問題があったので、廃止した。Mar 20, 2007
;      (|according|    . #b010000000000000000000000000000000000100000100100) ; ac            (03.06.03 SHORTFORMS)
      (|across|       . #b100000000000000000000000000000100000100100111010) ; acr           (03.06.04 SHORTFORMS)
; 不定詞(to across)
      (|across|       . #b000100000000000000000000000000100000100100111010) ; acr           (03.06.04 SHORTFORMS)
      (|after|        . #b100000000000000000000000000000000000100000110100) ; af            (03.06.05 SHORTFORMS)
      (|afternoon|    . #b100000000000000000000000000000100000110100101110) ; afn           (03.06.06 SHORTFORMS)
      (|afterward|    . #b100000000000000000000000000000100000110100010111) ; afw           (03.06.07 SHORTFORMS)
; 所有格
      (|afterward|    . #b010000000000000000000000000000100000110100010111) ; afw           (03.06.07 SHORTFORMS)
      (|again|        . #b100000000000000000000000000000000000100000110110) ; ag            (03.06.08 SHORTFORMS)
      (|against|      . #b100000000000000000000000000000100000110110001100) ; agst(ag/)     (03.06.09 SHORTFORMS)
      (|almost|       . #b100000000000000000000000000000100000111000101100) ; alm           (03.06.10 SHORTFORMS)
      (|already|      . #b100000000000000000000000000000100000111000111010) ; alr           (03.06.11 SHORTFORMS)
      (|also|         . #b100000000000000000000000000000000000100000111000) ; al            (03.06.12 SHORTFORMS) cf. WW2
      (|although|     . #b100000000000000000000000000000100000111000100111) ; alth(al?)     (03.06.13 SHORTFORMS) cf. WW2
      (|altogether|   . #b100000000000000000000000000000100000111000011110) ; alt           (03.06.14 SHORTFORMS)
      (|always|       . #b100000000000000000000000000000100000111000010111) ; alw           (03.06.15 SHORTFORMS)
      (|because|      . #b100000000000000000000000000000000000011000100100) ; bec(2c)       (03.06.16 SHORTFORMS)
      (|before|       . #b100000000000000000000000000000000000011000110100) ; bef(2f)       (03.06.17 SHORTFORMS)
      (|behind|       . #b100000000000000000000000000000000000011000110010) ; beh(2h)       (03.06.18 SHORTFORMS)
; 動詞の活用
      (|behind|       . #b010000000000000000000000000000000000011000110010) ; beh(2h)       (03.06.18 SHORTFORMS)
      (|below|        . #b100000000000000000000000000000000000011000111000) ; bel(2l)       (03.06.19 SHORTFORMS) cf. WW2
      (|beneath|      . #b100000000000000000000000000000000000011000101110) ; ben(2n)       (03.06.20 SHORTFORMS)
      (|beside|       . #b100000000000000000000000000000000000011000011100) ; bes(2s)       (03.06.21 SHORTFORMS)
; 動詞の活用
      (|beside|       . #b010000000000000000000000000000000000011000011100) ; bes(2s)       (03.06.21 SHORTFORMS)
      (|between|      . #b100000000000000000000000000000000000011000011110) ; bet(2t)       (03.06.22 SHORTFORMS)
      (|beyond|       . #b100000000000000000000000000000000000011000101111) ; bey(2y)       (03.06.23 SHORTFORMS) cf. WW2
; 動詞の活用
      (|beyond|       . #b010000000000000000000000000000000000011000101111) ; bey(2y)       (03.06.23 SHORTFORMS) cf. WW2
      (|blind|        . #b100000000000000000000000000000000000110000111000) ; bl            (03.06.24 SHORTFORMS)
      (|braille|      . #b100000000000000000000000000000110000111010111000) ; brl           (03.06.25 SHORTFORMS)
      (|children|     . #b100000000000000000000000000000000000100001101110) ; chn(*n)       (03.06.26 SHORTFORMS)
; 所有格
      (|children|     . #b010000000000000000000000000000000000100001101110) ; chn(*n)       (03.06.26 SHORTFORMS)
      (|conceive|     . #b100000000000000000000000000000010010100100111001) ; concv(3cv)    (03.06.27 SHORTFORMS)
; 動詞の活用
      (|conceive|     . #b010000000000000000000000000000010010100100111001) ; concv(3cv)    (03.06.27 SHORTFORMS)
; 不定詞(to conceive)
      (|conceive|     . #b000100000000000000000000000000010010100100111001) ; concv(3cv)    (03.06.27 SHORTFORMS)
      (|conceiving|   . #b100000000000000000000000010010100100111001110110) ; concvg(3cvg)  (03.06.28 SHORTFORMS)
      (|could|        . #b100000000000000000000000000000000000100100100110) ; cd            (03.06.29 SHORTFORMS)
; 修飾
      (|could|        . #b010000000000000000000000000000000000100100100110) ; cd            (03.06.29 SHORTFORMS)
      (|deceive|      . #b100000000000000000000000000000100110100100111001) ; dcv           (03.06.30 SHORTFORMS)
; 動詞の活用
      (|deceive|      . #b010000000000000000000000000000100110100100111001) ; dcv           (03.06.30 SHORTFORMS)
; 不定詞(to deceive)
      (|deceive|      . #b000100000000000000000000000000100110100100111001) ; dcv           (03.06.30 SHORTFORMS)
      (|deceiving|    . #b100000000000000000000000100110100100111001110110) ; dcvg          (03.06.31 SHORTFORMS)
; 副詞
      (|deceiving|    . #b010000000000000000000000100110100100111001110110) ; dcvg          (03.06.31 SHORTFORMS)
      (|declare|      . #b100000000000000000000000000000100110100100111000) ; dcl           (03.06.38 SHORTFORMS)
; 動詞の活用
      (|declare|      . #b010000000000000000000000000000100110100100111000) ; dcl           (03.06.38 SHORTFORMS)
; 不定詞(to declare)
      (|declare|      . #b000100000000000000000000000000100110100100111000) ; dcl           (03.06.38 SHORTFORMS)
      (|declaring|    . #b100000000000000000000000100110100100111000110110) ; dclg          (03.06.39 SHORTFORMS)
      (|either|       . #b100000000000000000000000000000000000100010010100) ; ei            (03.06.40 SHORTFORMS)
      (|first|        . #b100000000000000000000000000000000000110100001100) ; fst(f/)       (03.06.42 SHORTFORMS) cf. WW2
      (|friend|       . #b100000000000000000000000000000000000110100111010) ; fr            (03.06.43 SHORTFORMS)
; 複数、修飾、副詞
;      (|friend|       . #b010000000000000000000000000000000000110100111010) ; fr            (03.06.43 SHORTFORMS)
      (|good|         . #b100000000000000000000000000000000000110110100110) ; gd            (03.06.45 SHORTFORMS)
; 複数
      (|good|         . #b010000000000000000000000000000000000110110100110) ; gd            (03.06.45 SHORTFORMS)
      (|great|        . #b100000000000000000000000000000110110111010011110) ; grt           (03.06.47 SHORTFORMS)
; 副詞、複数
      (|great|        . #b010000000000000000000000000000110110111010011110) ; grt           (03.06.47 SHORTFORMS)
      (|herself|      . #b100000000000000000000000000000110010110111110100) ; herf(h]f)     (03.06.48 SHORTFORMS)
; 不定詞(to herself)
      (|herself|      . #b000100000000000000000000000000110010110111110100) ; herf(h]f)     (03.06.48 SHORTFORMS)
      (|him|          . #b100000000000000000000000000000000000110010101100) ; hm            (03.06.49 SHORTFORMS)
; 不定詞(to him)
      (|him|          . #b000100000000000000000000000000000000110010101100) ; hm            (03.06.49 SHORTFORMS)
      (|himself|      . #b100000000000000000000000000000110010101100110100) ; hmf           (03.06.50 SHORTFORMS)
      (|immediate|    . #b100000000000000000000000000000010100101100101100) ; imm           (03.06.52 SHORTFORMS)
      (|its|          . #b100000000000000000000000000000000000101101011100) ; xs            (03.06.53 SHORTFORMS)
; 修飾
      (|its|          . #b010000000000000000000000000000000000101101011100) ; xs            (03.06.53 SHORTFORMS)
      (|itself|       . #b100000000000000000000000000000000000101101110100) ; xf            (03.06.54 SHORTFORMS)
      (|letter|       . #b100000000000000000000000000000000000111000111010) ; lr            (03.06.56 SHORTFORMS)
; 複数
      (|letter|       . #b010000000000000000000000000000000000111000111010) ; lr            (03.06.56 SHORTFORMS)
      (|little|       . #b100000000000000000000000000000000000111000111000) ; ll            (03.06.57 SHORTFORMS)
      (|much|         . #b100000000000000000000000000000000000101100100001) ; mch(m*)       (03.06.58 SHORTFORMS) cf. WW2
      (|must|         . #b100000000000000000000000000000000000101100001100) ; mst(m/)       (03.06.59 SHORTFORMS) cf. WW2
; 否定形、修飾
      (|must|         . #b010000000000000000000000000000000000101100001100) ; mst(m/)       (03.06.59 SHORTFORMS) cf. WW2

      (|myself|       . #b100000000000000000000000000000101100101111110100) ; myf           (03.06.90 SHORTFORMS) cf. WW2
; 不定詞(to myself)
      (|myself|       . #b000100000000000000000000000000101100101111110100) ; myf           (03.06.90 SHORTFORMS) cf. WW2

      (|necessary|    . #b100000000000000000000000000000101110100010100100) ; nec           (03.06.60 SHORTFORMS) cf. WW2
; 接頭辞付(unnecessary)があるので、末端結合を追加した。Mar 20, 2007
      (|necessary|    . #b000100000000000000000000000000101110100010100100) ; nec           (03.06.61 SHORTFORMS)
      (|neither|      . #b100000000000000000000000000000101110100010010100) ; nei           (03.06.62 SHORTFORMS)
      (|o'clock|      . #b100000000000000000000000000000101010001000100100) ; o'c           (03.06.63 SHORTFORMS)
      (|oneself|      . #b100000000000000000000000101010101110100010110100) ; onef          (03.06.64 SHORTFORMS)
      (|ourselves|    . #b100000000000000000000000110011111010111001011100) ; ourvs(\rvs)  (03.06.65 SHORTFORMS)
      (|paid|         . #b100000000000000000000000000000000000111100100110) ; pd            (03.06.66 SHORTFORMS)
      (|perceive|     . #b100000000000000000000000111100110111100100111001) ; percv(p]cv)   (03.06.67 SHORTFORMS)
; 動詞の活用
      (|perceive|     . #b010000000000000000000000111100110111100100111001) ; percv(p]cv)   (03.06.67 SHORTFORMS)
      (|perceiving|   . #b100000000000000000111100110111100100111001110110) ; percvg(p]cvg) (03.06.68 SHORTFORMS)
      (|perhaps|      . #b100000000000000000000000000000111100110111110010) ; perh(p]h)     (03.06.69 SHORTFORMS) cf. WW2
      (|quick|        . #b100000000000000000000000000000000000111110101000) ; qk            (03.06.71 SHORTFORMS)
; 副詞
      (|quick|        . #b010000000000000000000000000000000000111110101000) ; qk            (03.06.71 SHORTFORMS)
      (|receive|      . #b100000000000000000000000000000111010100100111001) ; rcv           (03.06.72 SHORTFORMS)
; 動詞の活用
      (|receive|      . #b010000000000000000000000000000111010100100111001) ; rcv           (03.06.72 SHORTFORMS)
; 不定詞(to receive)
      (|receive|      . #b000100000000000000000000000000111010100100111001) ; rcv           (03.06.72 SHORTFORMS)
      (|receiving|    . #b100000000000000000000000111010100100111001110110) ; rcvg          (03.06.73 SHORTFORMS)
; 副詞
      (|receiving|    . #b010000000000000000000000111010100100111001110110) ; rcvg          (03.06.73 SHORTFORMS)
      (|rejoice|      . #b100000000000000000000000000000111010010110100100) ; rjc           (03.06.74 SHORTFORMS)
      (|rejoicing|    . #b100000000000000000000000111010010110100100110110) ; rjcg          (03.06.75 SHORTFORMS)
      (|said|         . #b100000000000000000000000000000000000011100100110) ; sd            (03.06.76 SHORTFORMS)
      (|should|       . #b100000000000000000000000000000000000100101100110) ; shd(%d)       (03.06.78 SHORTFORMS)
; 否定形、修飾
      (|should|       . #b010000000000000000000000000000000000100101100110) ; shd(%d)       (03.06.78 SHORTFORMS)
      (|such|         . #b100000000000000000000000000000000000011100100001) ; sch(s*)       (03.06.79 SHORTFORMS) cf. WW2
      (|themselves|   . #b100000000000000000000000011101101100111001011100) ; themvs(!mvs)  (03.06.80 SHORTFORMS)
      (|thyself|      . #b100000000000000000000000000000100111101111110100) ; thyf(?yf)     (03.06.81 SHORTFORMS)
      (|today|        . #b100000000000000000000000000000000000011110100110) ; td            (03.06.82 SHORTFORMS) cf. WW2
; 所有格
      (|today|        . #b010000000000000000000000000000000000011110100110) ; td            (03.06.83 SHORTFORMS)
      (|together|     . #b100000000000000000000000000000011110110110111010) ; tgr           (03.06.84 SHORTFORMS)
      (|tomorrow|     . #b100000000000000000000000000000000000011110101100) ; tm            (03.06.85 SHORTFORMS)
      (|tonight|      . #b100000000000000000000000000000000000011110101110) ; tn            (03.06.86 SHORTFORMS) cf. WW2
; 複数
      (|tonight|      . #b010000000000000000000000000000000000011110101110) ; tn            (03.06.86 SHORTFORMS) cf. WW2
      (|would|        . #b100000000000000000000000000000000000010111100110) ; wd            (03.06.88 SHORTFORMS)
; 否定形、修飾
      (|would|        . #b010000000000000000000000000000000000010111100110) ; wd            (03.06.88 SHORTFORMS)
      (|your|         . #b100000000000000000000000000000000000101111111010) ; yr            (03.06.89 SHORTFORMS)
; 所有格
      (|your|         . #b010000000000000000000000000000000000101111111010) ; yr            (03.06.89 SHORTFORMS)
      (|yourself|     . #b100000000000000000000000000000101111111010110100) ; yrf           (03.06.90 SHORTFORMS) cf. WW2
; 不定詞(to yourself)
      (|yourself|     . #b000100000000000000000000000000101111111010110100) ; yrf           (03.06.90 SHORTFORMS) cf. WW2
      (|yourselves|   . #b100000000000000000000000101111111010111001011100) ; yrvs          (03.06.91 SHORTFORMS) cf. WW2

; 禁則
; added by T.M.
; 【松ルール①】
; ? と his が同じ値（8）であることにより、エンコードで副作用がある。
; エンコード時に his が連なる場合は、連結しない。
;
; 以下の区別がつかない！！
; by v.s. was  (0)
; "was(8was) v.s. ?" (80)

      (|?"|           . #b100000000000000000000000000000000000011001001011) ; 80     ugly
      (|?"|           . #b010000000000000000000000000000000000011001001011) ; 80     ugly
      (|?" |          . #b000100000000000000000000000000011001001011000000) ; 80_    ugly

      (|was"|         . #b100000000000000000000000010111100000011100001011) ; was0   4-4
      (|was?|         . #b100000000000000000000000010111100000011100011001) ; was8   4-4
      (|was?"|        . #b100000000000000000010111100000011100011001001011) ; was80  4-4
      (|was?" |       . #b100000000000010111100000011100011001001011000000) ; was80_ 4-4
      (|was;|         . #b100000000000000000000000010111100000011100011000) ; was2   4-4
      (|was;"|        . #b100000000000000000010111100000011100011000001011) ; was20  4-4
      (|was;" |       . #b100000000000010111100000011100011000001011000000) ; was20_ 4-4
      (|was.|         . #b100000000000000000000000010111100000011100010011) ; was4   4-4
      (|was,|         . #b100000000000000000000000010111100000011100010000) ; was1   4-4
      (|was,"|        . #b100000000000000000010111100000011100010000001011) ; was10  4-4
      (|was," |       . #b100000000000010111100000011100010000001011000000) ; was10_ 4-4

      (|be"|          . #b100000000000000000000000000000110000100010001011) ; be0    4-4
      (|be?|          . #b100000000000000000000000000000000000011000011001) ; 28     4-4
      (|be?"|         . #b100000000000000000000000110000100010011001001011) ; be80   4-4
      (|be;|          . #b100000000000000000000000000000110000100010011000) ; be2    4-4
      (|be?" |        . #b100000000000000000110000100010011001001011000000) ; be80_  4-4
      (|be;"|         . #b100000000000000000000000110000100010011000001011) ; be20   4-4
      (|be;" |        . #b100000000000000000110000100010011000001011000000) ; be20_  4-4
      (|be.|          . #b100000000000000000000000000000110000100010010011) ; be4    4-4
      (|be,|          . #b100000000000000000000000000000110000100010010000) ; be1    4-4
      (|be,"|         . #b100000000000000000000000110000100010010000001011) ; be10   4-4
      (|be," |        . #b100000000000000000110000100010010000001011000000) ; be10_  4-4

      (|enough"|      . #b100000000000000000000000010001110011110001001011) ; 5¥<0   4-4
      (|enough?|      . #b100000000000000000000000010001110011110001011001) ; 5¥<8   4-4
      (|enough?"|     . #b100000000000000000010001110011110001011001001011) ; 5¥<80  4-4
      (|enough?" |    . #b100000000000010001110011110001011001001011000000) ; 5¥<80_ 4-4
      (|enough;|      . #b100000000000000000000000010001110011110001011000) ; 5¥<2   4-4
      (|enough;"|     . #b100000000000000000010001110011110001011000001011) ; 5¥<20  4-4
      (|enough;" |    . #b100000000000010001110011110001011000001011000000) ; 5¥<20_ 4-4
      (|enough.|      . #b100000000000000000000000010001110011110001010011) ; 5¥<4   4-4
      (|enough,|      . #b100000000000000000000000010001110011110001010000) ; 5¥<1   4-4
      (|enough,"|     . #b100000000000000000010001110011110001010000001011) ; 5¥<10  4-4
      (|enough," |    . #b100000000000010001110011110001010000001011000000) ; 5¥<10_ 4-4

      (|were"|        . #b100000000000000000000000010111110111100010001011) ; w]e0   4-4
      (|were?|        . #b100000000000000000000000010111110111100010011001) ; w]e8   4-4
      (|were?"|       . #b100000000000000000010111110111100010011001001011) ; w]e80  4-4
      (|were?" |      . #b100000000000010111110111100010011001001011000000) ; w]e80_ 4-4
      (|were;|        . #b100000000000000000000000010111110111100010011000) ; w]e2   4-4
      (|were;"|       . #b100000000000000000010111110111100010011000001011) ; w]e20  4-4
      (|were;" |      . #b100000000000010111110111100010011000001011000000) ; w]e20_ 4-4
      (|were.|        . #b100000000000000000000000010111110111100010010011) ; w]e4   4-4
      (|were,|        . #b100000000000000000000000010111110111100010010000) ; w]e1   4-4
      (|were,"|       . #b100000000000000000010111110111100010010000001011) ; w]e10  4-4
      (|were," |      . #b100000000000010111110111100010010000001011000000) ; w]e10_ 4-4

      (|his"|         . #b100000000000000000000000110010010100011100001011) ; his0   4-4
      (|his?|         . #b100000000000000000000000110010010100011100011001) ; his8   4-4
      (|his?"|        . #b100000000000000000110010010100011100011001001011) ; his80  4-4
      (|his?" |       . #b100000000000110010010100011100011001001011000000) ; his80_ 4-4
      (|his;|         . #b100000000000000000000000110010010100011100011000) ; his2   4-4
      (|his;"|        . #b100000000000000000110010010100011100011000001011) ; his20  4-4
      (|his;" |       . #b100000000000110010010100011100011000001011000000) ; his20_ 4-4
      (|his.|         . #b100000000000000000000000110010010100011100010011) ; his4   4-4
      (|his,|         . #b100000000000000000000000110010010100011100010000) ; his1   4-4
      (|his,"|        . #b100000000000000000110010010100011100010000001011) ; his10  4-4
      (|his," |       . #b100000000000110010010100011100010000001011000000) ; his10_ 4-4

      (|in"|          . #b100000000000000000000000000000010100101110001011) ; in0    4-4
      (|in?|          . #b100000000000000000000000000000010100101110011001) ; in8    4-4
      (|in?"|         . #b100000000000000000000000010100101110011001001011) ; in80   4-4
      (|in?" |        . #b100000000000000000010100101110011001001011000000) ; in80_  4-4
      (|in;|          . #b100000000000000000000000000000010100101110011000) ; in2    4-4
      (|in;"|         . #b100000000000000000000000010100101110011000001011) ; in20   4-4
      (|in;" |        . #b100000000000000000010100101110011000001011000000) ; in20_  4-4
      (|in.|          . #b100000000000000000000000000000010100101110010011) ; in4    4-4
      (|in,|          . #b100000000000000000000000000000010100101110010000) ; in1    4-4
      (|in,"|         . #b100000000000000000000000010100101110010000001011) ; in10   4-4
      (|in," |        . #b100000000000000000010100101110010000001011000000) ; in10_  4-4

      (|to?|          . #b100000000000000000000000000000000000011010011001) ; 68     ugly
      (|to?"|         . #b100000000000000000000000011110101010011001001011) ; to80   ugly
      (|to?" |        . #b100000000000000000011110101010011001001011000000) ; to80_  ugly
      (|to;|          . #b100000000000000000000000000000011110101010011000) ; to2    ugly
      (|to;"|         . #b100000000000000000000000011110101010011000001011) ; to20   ugly
      (|to;" |        . #b100000000000000000011110101010011000001011000000) ; to20_  ugly
      (|to.|          . #b100000000000000000000000000000011110101010010011) ; to4    ugly
      (|to,|          . #b100000000000000000000000000000011110101010010000) ; to1    ugly
      (|to,"|         . #b100000000000000000000000011110101010010000001011) ; to10   ugly
      (|to," |        . #b100000000000000000011110101010010000001011000000) ; to10_  ugly

      (|by?"|         . #b100000000000000000000000110000101111011001001011) ; by80   ugly
      (|by?" |        . #b100000000000000000110000101111011001001011000000) ; by80_  ugly
      (|by;|          . #b100000000000000000000000000000110000101111011000) ; by2    ugly
      (|by;"|         . #b100000000000000000000000110000101111011000001011) ; by20   ugly
      (|by;" |        . #b100000000000000000110000101111011000001011000000) ; by20_  ugly
      (|by.|          . #b100000000000000000000000000000110000101111010011) ; by4    ugly
      (|by,|          . #b100000000000000000000000000000110000101111010000) ; by1    ugly
      (|by,"|         . #b100000000000000000000000110000101111010000001011) ; by10   ugly
      (|by," |        . #b100000000000000000110000101111010000001011000000) ; by10_  ugly

      (|for?|         . #b100000000000000000000000000000000000111111011001) ; =8     ugly
      (|for?"|        . #b100000000000000000000000000000111111011001001011) ; =80    ugly
      (|for?" |       . #b100000000000000000000000111111011001001011000000) ; =80_   ugly
; wholeWord の bexxx が続くと破壊されるので、for/of/with の直後の ; は結合させない。
; ex. sorry for being rate
;     (|for;|         . #b100000000000000000000000000000000000111111011000) ; =2     ugly
;     (|for,|         . #b100000000000000000000000000000000000111111010000) ; =1    ugly
      (|for,"|        . #b100000000000000000000000000000111111010000001011) ; =10    ugly
      (|for," |       . #b100000000000000000000000111111010000001011000000) ; =10_   ugly

      (|of?|          . #b100000000000000000000000000000000000111011011001) ; (8     ugly
      (|of?"|         . #b100000000000000000000000000000111011011001001011) ; (80    ugly
      (|of?" |        . #b100000000000000000000000111011011001001011000000) ; (80_   ugly
; wholeWord の bexxx が続くと破壊されるので、for/of/with の直後の ; は結合させない。
; ex. sorry for being rate
;     (|of;|          . #b100000000000000000000000000000000000111011011000) ; (2     ugly
;     (|of,|          . #b100000000000000000000000000000000000111011010000) ; (1    ugly
      (|of,"|         . #b100000000000000000000000000000111011010000001011) ; (10    ugly
      (|of," |        . #b100000000000000000000000111011010000001011000000) ; (10_   ugly

      (|with?|        . #b100000000000000000000000000000000000011111011001) ; )8     ugly
      (|with?"|       . #b100000000000000000000000000000011111011001001011) ; )80    ugly
      (|with?" |      . #b100000000000000000000000011111011001001011000000) ; )80_   ugly
; wholeWord の bexxx が続くと破壊されるので、for/of/with の直後の ; は結合させない。
; ex. sorry for being rate
;     (|with;|        . #b100000000000000000000000000000000000011111011000) ; )2     ugly
;     (|with,|        . #b100000000000000000000000000000000000011111010000) ; )1    ugly
      (|with,"|       . #b100000000000000000000000000000011111010000001011) ; )10    ugly
      (|with," |      . #b100000000000000000000000011111010000001011000000) ; )10_   ugly

;      (|on|           . #b001000000000000000000000000000000000000000000011) ; ; (US のみか？)
;      (|on|           . #b000100000000000000000000000000000000000000000011) ; ; (US のみか？)
    )
  )

  (setf *us_grade2_excp_whole*
   '(
      (|,|    . #b100000000000000000000000000000000000000000010000) ; wholeWord の "," はカンマ(,)
      (|.|    . #b100000000000000000000000000000000000000000010011) ; 語の始まりの "." はピリオド(4)
    )
  )

  (setf *us_grade2_excp_initial*
   '(
      (|.|    . #b010000000000000000000000000000000000000000000101) ; 語の始まりの "." はイタリック符(.)
      (|"|    . #b010000000000000000000000000000000000000000011001) ; 語の始まりの """ はダブルクォート開始(8)
      (|'|    . #b010000000000000000000000000000000000000001011001) ; 語の始まりの "'" はシングルクォート開始(,8)
      ([      . #b010000000000000000000000000000000000000001011011) ; 語の始まりの "[" は左カギ括弧(,7)
    )
  )

  ; RULE XIII - LOWER SIGNS <http://www.brl.org/ebae/rule13.html> は多くの問題を含んでいる。
  ; 以下は、異なる墨字シンボルが全く同じ点字コードにエンコードされるため、正しくデコードできない。
  ; "." "(" ")" は語の途中に挿入が可能であるため、このような不都合が発生する。
  ;
  ; "4" <-- "dd" "."
  ;    "dd" は *us_grade2* に、"." を *us_grade2_excp_medial* を具備させるが、語中の "."（省略） は正しくデコードされない。
  ; "7" <-- "gg" "(" ")"
  ;   以下の |(| や |)| を *us_grade2* に具備させると、"gg" が正しくデコードされない。
  (setf *us_grade2_excp_medial*
   '(
      (|.|    . #b001000000000000000000000000000000000000000010011) ; 語の途中の "." は省略(4)
      (|(|    . #b001000000000000000000000000000000000000000011011) ; 語の途中の "(" (7)
      (|)|    . #b001000000000000000000000000000000000000000011011) ; 語の途中の ")" (7)
      (|"|    . #b001000000000000000000000000000000000000000001011) ; 語の途中の """ はダブルクォート終了(0)
      (|'|    . #b001000000000000000000000000000000000000000001000) ; 語の途中の "'" はアポストロフィー(')
    )
  )

  (setf *us_grade2_excp_final*
   '(
      (|.|    . #b000100000000000000000000000000000000000000010011) ; 語の終わりの "." はピリオド(4)
      (|"|    . #b000100000000000000000000000000000000000000001011) ; 語の終わりの """ はダブルクォート終了(0)
      (|'|    . #b000100000000000000000000000000000000001011001000) ; 語の終わりの "'" はシングルクォート終了(0')
      (|,|    . #b000100000000000000000000000000000000000000010000) ; 語の終わりの "," はカンマ(,)
      (>      . #b000100000000000000000000000000000000000111011011) ; 語の終わりの ">" は close angle bracket
      (]      . #b000100000000000000000000000000000000011011001000) ; 語の終わりの "]" は右カギ括弧(7')
      (|;|    . #b000100000000000000000000000000000000000000011000) ; 語の終わりの ";" はセミコロン(2)
    )
  )

  (setf *us_grade2_excp_none*
   '(
      (|'|    . #b000000000000000000000000000000000000000000001000) ; 結合なしの "'" はアポストロフィー(')
    )
  )

  (setf *us_grade3*
   '(
; Grade3（未実装）
    )
  )

  (setf *us_grade4*
   '(
; Grade4（未実装）
    )
  )
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 genUsGrade2Dictionary
;; 【機能　】 ファイルのデータから英語グレード２辞書の連想配列やファイルを作成する。
;; 【入力　】 infn : 辞書データファイル（入力）のパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (genUsGrade2Dictionary "../dic/us_grade2.txt")
;;           → nil
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun initUsGrade2Dictionary ()
  (dolist (xx *us_grade2_enc_dict*)
    (if (nth 2 xx)
      nil
      (format t "~%~S" xx)))
  (dolist (xx *us_grade2_dec_dict*)
    (if (nth 2 xx)
      nil
      (format t "~%~S" xx))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 genUsGrade2Dictionary
;; 【機能　】 ファイルのデータから英語グレード２辞書の連想配列やファイルを作成する。
;; 【入力　】 infn : 辞書データファイル（入力）のパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (genUsGrade2Dictionary "../dic/us_grade2.txt")
;;           → nil
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun genUsGrade2Dictionary (infn)
  (let (buff (lineNo 1) (gradeSaver *grade*) (isJP (string= *defaultMode* "JP")) (errList nil))
    (setf *us_grade2_enc_dict* nil *us_grade2_dec_dict* nil)
    (initLang 2 "us")
    ;; 辞書入力ファイルをオープンする。
    (with-open-file (instream infn :direction :input)
      (do ()
        ((null (setf buff (read-line instream nil))) nil)
        ; 1行エンコードする。
        (if (and (> (length buff) 1)
                 (string/= (subseq buff 0 2) _commentMark_)) ; ";;"
          (progn
            (registUsGrade2Dic buff lineNo nil errList)
            (incf lineNo))
          nil))
      ;; 辞書入力ファイルをクローズする。
      (close instream))
    (initLang gradeSaver "us" isJP)
    (setUsDicMaxLength)
    errList))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 registUsGrade2Dic
;; 【機能　】 バッファのデータから英語グレード２（米国）辞書の連想配列情報を登録する。
;; 【入力　】 buff   : 辞書データファイル（入力）のパス
;;          lineNo : 行番号
;;          scan   : 連想配列を検索するか否か
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (registUsGrade2Dic ",w")
;;           → nil
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun registUsGrade2Dic (buff lineNo scan errList)
  (let ((srcStr nil) lst flags (mask 0) enc dec convPair s b e)
    (setf lst (split-string buff _fieldSeparator_))
    (setf buff (nth 0 lst))
    (setf flags (nth 1 lst))
    ; フラグに応じて辞書の結合マスクを設定する。
    ; Whole
    (if (search "w" flags) (setf mask (logior mask _wholeWordMask_)) nil)
    ; Initial
    (if (search "i" flags) (setf mask (logior mask _initialWordMask_)) nil)
    ; Medial
    (if (search "m" flags) (setf mask (logior mask _medialWordMask_)) nil)
    ; Final
    (if (search "f" flags) (setf mask (logior mask _finalWordMask_)) nil)
    (setf convPair (explode-string buff '("→") nil))
    (if (= (length convPair) 2) ; 直接変換がある場合
      (progn
        (setf srcStr (substitute-string (nth 0 convPair) "→" ""))
        (setf buff (nth 1 convPair)))
      nil)
    (multiple-value-setq (s b e) (genUsGrade2DicInfo buff lineNo))
    (if e (push e errList) nil)
    (if srcStr ; 直接変換がある場合
      (progn
        (setf enc (list (intern srcStr) nil mask b 0)
              dec (list (intern b) nil mask srcStr 0))
        ; エンコード用辞書登録
        (if (and scan (assoc (intern srcStr) *us_grade2_enc_dict*))
          (setf (car (assoc (intern srcStr) *us_grade2_enc_dict*)) enc)
          (push enc *us_grade2_enc_dict*))
        (if (and scan (assoc (intern b) *us_grade2_dec_dict*))
          (setf (car (assoc (intern b) *us_grade2_dec_dict*)) dec)
          (setf dec *us_grade2_dec_dict*)))
      (progn
        (setf enc (list (intern s) nil mask b 0)
              dec (list (intern b) nil mask s 0))
        ; エンコード用辞書登録
        (if (and scan (assoc (intern s) *us_grade2_enc_dict*))
          (do ((i 0 (1+ i)))
            ((= i (length enc)) nil)
            (setf (nth i (assoc (intern s) *us_grade2_enc_dict*)) (nth i enc)))
          (push enc *us_grade2_enc_dict*))
        ; デコード用辞書登録
        (if (and scan (assoc (intern b) *us_grade2_dec_dict*))
          (do ((i 0 (1+ i)))
            ((= i (length dec)) nil)
            (setf (nth i (assoc (intern b) *us_grade2_dec_dict*)) (nth i dec)))
          (push dec *us_grade2_dec_dict*))))
    (format nil "(~S ~S)" enc dec)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 saveUsGrade2ExtFile
;; 【機能　】 ファイルのデータから英語グレード２辞書のエクストラクトファイルを作成する。
;; 【入力　】 extfn : 辞書エクストラクトファイル（出力用）のパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (saveUsGrade2ExtFile "../dic/us_grade2.ext" t)
;;           → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun saveUsGrade2ExtFile (extfn &optional (collect nil))
  (let ((delim _fieldSeparator_) (errList nil))
    (if (and *us_grade2_enc_dict* *us_grade2_dec_dict*)
      (let ((gradeSaver *grade*) (isJP (string= *defaultMode* "JP")))
        (initLang 2 "us")
        ;; 辞書エクストラクトファイルを削除する。
        (if (probe-file extfn)
          (delete-file extfn)
          nil)
        ;; 辞書エクストラクトファイルをライトオープンする。
        (with-open-file (outstream extfn :direction :output :if-exists :new-version)
          (let ((lineNo 0) g2infoEnc g2infoDec encRefCnt decRefCnt)
            (dolist (xx *us_grade2_enc_dict*)
              (setf g2infoEnc (nth lineNo *us_grade2_enc_dict*))
              (setf g2infoDec (nth lineNo *us_grade2_dec_dict*))
              (if collect
                (progn
                  (setf encRefCnt (getCount (nth _dic_symbol_index_ g2infoEnc)))
                  (setf decRefCnt (getCount (nth _dic_symbol_index_ g2infoDec)))
                  ; エンコード用の辞書の参照回数を更新する。
                  (replace g2infoEnc (list encRefCnt) :start1 _dic_ref_count_index_)
                  ; デコード用の辞書の参照回数を更新する。
                  (replace g2infoDec (list decRefCnt) :start1 _dic_ref_count_index_))
                nil)
              (format outstream "~S~A~S~%" g2infoEnc delim g2infoDec)
              (incf lineNo)))
          ;; 辞書エクストラクトファイルをクローズする。
          (close outstream))
        (initLang gradeSaver "us" isJP))
      (push "*us_grade2_enc_dict* または *us_grade2_dec_dict* が設定されていません。" errList))
    errList))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 loadUsGrade2ExtFile
;; 【機能　】 ファイルのデータから英語グレード２辞書の連想配列やファイルを作成する。
;; 【入力　】 extfn : 辞書エクストラクトファイル（入力）のパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (loadUsGrade2ExtFile "../dic/us_grade2.ext")
;;           → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun loadUsGrade2ExtFile (extfn)
  (let (buff (lineNo 1) (delim _fieldSeparator_) (gradeSaver *grade*) (isJP (string= *defaultMode* "JP")) (errList nil))
    (setf *us_grade2_enc_dict* nil *us_grade2_dec_dict* nil)
    (initLang 2 "us")
    ;; 辞書エクストラクトファイルをリードオープンする。
    (with-open-file (instream extfn :direction :input)
      (let (lst tmp)
        (do ()
          ; 1行読み込み、エンコード・デコード情報を取得する。
          ((null (setf buff (read-line instream nil))) nil)
          (if (and (> (length buff) 1)
                   (string/= (subseq buff 0 1) "("))
            (progn
              ; エンコード情報、デコード情報の区切りは、_fieldSeparator_。
              (setf lst (split-string buff delim))
              ; エンコード情報を追加する。
              (setf tmp (nth 0 lst))
              (if (> *debug* 0)
                (format t "~S:~S~%" lineNo tmp)
                nil)
              (push (read-from-string tmp) *us_grade2_enc_dict*)
              ; デコード情報を追加する。
              (setf tmp (nth 1 lst))
              (if (> *debug* 0)
                (format t "~S:~S~%" lineNo tmp)
                nil)
              (push (read-from-string tmp) *us_grade2_dec_dict*)
              (incf lineNo))
            (push buff errList))))
      ;; 辞書エクストラクトファイルをクローズする。
      (close instream))
    (initLang gradeSaver "us" isJP)
    (setUsDicMaxLength)
    errList))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 genUsGrade2DicInfo
;; 【機能　】 1行の文字列から英語グレード２の辞書の連想配列のメンバー情報を作成する。
;; 【入力　】 buff   : 文字列
;;            lineNo : 行番号
;; 【出力　】 墨字、点字、エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (g2us) (genUsGrade2DicInfo "(st)oreroom" 1) → "storeroom"
;;                                                       "/OREROOM"
;;                                                       NIL
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun genUsGrade2DicInfo (buff lineNo)
  (let ((sret nil) (bret nil) lst ds b tokLen errList)
    (setf lst (explode-string buff '("(" ")") nil))
    (dolist (s lst)
      (setf tokLen (length s))
      (if (string= (subseq s (1- tokLen) tokLen) ")")
        (progn ; 括弧の中はチャンクで処理する。
          (setf ds (string-downcase (substitute-string s ")" "")))
          (setf b (encodeBrailleStr ds nil *defaultMode* 0 t nil t))
          (if (null b) (push (list lineNo buff ds) errList) nil)
          (setf sret (concatenate 'string sret ds))
          (setf bret (concatenate 'string bret b)))
        (if (string/= s "(")
          (let (tlst) ; 括弧の外は一文字づつ処理する。
            (setf ds (string-downcase s))
            (setf tlst (explode-string ds '("")))
            (dolist (ts tlst)
              (if (string/= ts "(")
                (progn
                  ; 半角の空白は変換しない。
                  (if (string= ts _blank_s_)
                    (setf b _blank_s_)
                    (setf b (encodeBrailleStr ts nil *defaultMode* 0 t nil t)))
                  ; "." はマニュアルで "4" に変換する。
                  (if (string= b _dot_s_)
                    (setf b (substitute-string b _dot_s_ _dot_brl_))
                    nil)
                  ; エラー（点字が存在しない。）
                  (if (null b) (push (list lineNo buff ds ts) errList) nil)
                  (setf sret (concatenate 'string sret ts))
                  (setf bret (concatenate 'string bret b)))
                nil)))
          nil)))
    (values sret bret errList)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 updateUsG2DicAccessInfo
;; 【機能　】 ファイルのデータから URLサフィックスリストを作成する。
;; 【入力　】 infn : URLサフィックスファイルのパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (updateUsG2DicAccessInfo ) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun updateUsG2DicAccessInfo (g2info)
  (let (cell (sym (nth _dic_symbol_index_ g2info)) cnt)
    (setf cell (assoc sym *g2DicRefCntList*))
    (if cell
      (progn
        (setf cnt (1+ (cdr cell)))
        ; 以前のコンスセルを削除する。
        (delete-if #'(lambda(x) (equal x cell)) *g2DicRefCntList*))
      (setf cnt 1))
    (setf *g2DicRefCntList* (acons sym cnt *g2DicRefCntList*))
    *g2DicRefCntList*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 setUsDicMaxLength
;; 【機能　】 英語グレード２辞書メンバーの最大長を設定する。
;; 【入力　】 なし
;; 【出力　】 なし
;; 【例外　】 なし
;; 【使用例】 (setUsDicMaxLength)
;;           → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun setUsDicMaxLength ()
  (setf *maxDicBrailleLength*
    (progn
      (let (lst)
        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *us_grade2_dec_dict*))
        (apply 'max lst))))
  (setf *maxDicSumijiLength*
    (progn
      (let (lst)
        (setf lst (mapcar #'(lambda(x) (length (string (nth _dic_symbol_index_ x)))) *us_grade2_enc_dict*))
        (apply 'max lst))))
  nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 makeUsUrlList
;; 【機能　】 ファイルのデータから URLサフィックスリストを作成する。
;; 【入力　】 infn : URLサフィックスファイルのパス
;; 【出力　】 エラー情報のリスト
;; 【例外　】 なし
;; 【使用例】 (makeUsUrlList "../dict/url.txt") → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun makeUsUrlList (infn)
  (let (buff)
    (setf *url_suffix_list* nil)
    ;; URL ファイルをオープンする。
    (with-open-file (instream infn :direction :input)
      (do ()
        ((null (setf buff (read-line instream nil))) nil)
        ; 1行エンコードする。
        (if (and (> (length buff) 1)
                 (string/= (subseq buff 0 2) _commentMark_)) ; ";;"
          (pushnew (intern (string-upcase buff)) *url_suffix_list*)
          nil))
      ;; URL ファイルをクローズする。
      (close instream)))
  t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_effectiveLeft
;; 【機能　】 最初の有効な文字のインデックスを返す。
;; 【入力　】 str    : 文字列
;;            wide : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                   半角として処理する。
;;            encode : t の場合 str を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;; 【出力　】 最初の有効な文字のインデックス
;; 【例外　】 なし
;; 【使用例】 (us_effectiveLeft ",abc" nil nil) → 1
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_effectiveLeft (str wide encode)
  (let ((ret 0) lst delim (ss (string-downcase str)) s)
    (if encode
      (progn
        (if wide
          (progn
            (setf delim _blank_w_)
            (setf lst _effectiveLeft-encode-w-p_))
          (progn
            (setf delim _blank_s_)
            (setf lst _effectiveLeft-encode-s-p_))))
      (progn
        (setf delim _blank_s_)
        (setf lst _effectiveLeft-decode-p_)))
    (setf s (car (explode-string (subtract-strings ss lst delim) (list delim) nil)))
    (if (and (constant-char-stringp s (char delim 0))
             (< (length s) (length str)))
      (setf ret (length s))
      nil)
    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_ignoreableLeft
;; 【機能　】 処理済みの文字列が無視できるか否かを返す。
;; 【入力　】 str    : 文字列
;;            wide : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                   半角として処理する。
;;            encode : t の場合 token を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;;            all    : t の場合文字列全体が対象、nil の場合は末端が対象。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (us_ignoreableLeft "&" nil t) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_ignoreableLeft (str wide encode &optional (all t))
  (let (lst (ss (string-downcase str)))
    (if encode
      (if wide
        (setf lst _ignoreableLeft-encode-w-p_)
        (setf lst _ignoreableLeft-encode-s-p_))
      (setf lst _ignoreableLeft-decode-p_))
    (if all
      (= (length (subtract-strings ss lst)) 0)
      (string-tail= ss lst))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_ignoreableRight
;; 【機能　】 未処理の文字列が無視できるか否かを返す。
;; 【入力　】 str    : 文字列
;;            wide : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                   半角として処理する。
;;            encode : t の場合 token を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (us_ignoreableRight " " nil t) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_ignoreableRight (str wide encode &optional (all t))
;  (let (lst (ss (string-downcase str)))
  (let (lst (ss str))
    (if encode
      (if wide
        (setf lst _ignoreableRight-encode-w-p_)
        (setf lst _ignoreableRight-encode-s-p_))
      (setf lst _ignoreableRight-decode-p_))
    (if all
      (= (length (subtract-strings ss lst)) 0)
      (string-head= ss lst))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_ignoreableTail
;; 【機能　】 処理中の文字列の末端が無視できるか否かを返す。
;; 【入力　】 str    : 文字列
;;            wide : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                   半角として処理する。
;;            encode : t の場合 token を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (us_ignoreableTail "," nil t) → |,|
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_ignoreableTail (str wide encode)
;  (let ((ss (string-downcase str)))
  (let ((ss str))
    (if encode
      (if wide
        (ignoreableTail-encode-w-p ss)
        (ignoreableTail-encode-s-p ss))
      (ignoreableTail-decode-p ss))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_wholeWordCandidate
;; 【機能　】 点字文字列が完結した一語に置換される物（大半の１マス略語）か否かを返す。
;; 【入力　】 s      : 評価中の部分文字列（文字列）
;;            left   : チャンクの開始位置から評価中の部分文字列の先頭までのオフセット（整数）
;;            right  : チャンクの開始位置から評価中の部分文字列の末端の１文字までのオフセット（整数）
;;            past   : 評価済みの部分文字列（文字列）
;;            next   : 評価予定の部分文字列（文字列）
;;            wide   : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                     半角として処理する。
;;            encode : t の場合 token を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;; 【出力　】 t/インデクス/nil
;;            末端の１文字がデリミタ的なものであった場合、末端の１文字
;;              を空白に置き換えた文字列
;; 【例外　】 なし
;; 【使用例】 (us_wholeWordCandidate 1 "," "bea" "tles " nil t) → nil
;;            (us_wholeWordCandidate 1 "," "beatles" " " nil t) → T
;;            (us_wholeWordCandidate 1 "," "beatles " "" nil t) → | |
;;            (us_wholeWordCandidate 1 "," "afternoon" " " nil t) → T
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_wholeWordCandidate (left past s next wide encode)
  (let ((ret nil) (ret_s s) (tail nil))
    (if (> (length s) 1)
      (setf tail (subseq s (1- (length s))))
      nil)
    ; 下記の①～②が全て真である場合に、真を返す。
    (setf ret
      (and
        ; ①
        ; 変換中の部分文字列は最初の部分文字列である。
        ; または
        ; 既に変換した部分文字列は【全て】デリミタ的なものである。
        (or (= left 0) (us_ignoreableLeft past wide encode))
        ; ②
        ; 変換中の部分文字列の【末端】の１文字はデリミタ的なものである。
        ; または
        ; 変換予定の部分文字列は【全て】デリミタ的なものである。
        (or (us_ignoreableTail tail wide encode) (us_ignoreableRight next wide encode))))
    (if (and (null encode)                                        ; デコード時である。
             (> (length s) 2)                                     ; 変換中の部分文字列は３バイト以上の長さである。(eg. |of | |to |)
             (null (atomic-p (substitute-string s _blank_s_ ""))) ; 変換中の部分文字列は加工可能である。（アトミックでない）
             (us_ignoreableTail tail wide encode))                ; 変換中の部分文字列の【末端の１文字】はデリミタ的なものである。
      (progn
        (setf ret_s (concatenate 'string (subseq s 0 (1- (length s))) _blank_s_))
        (setf ret t))
      nil)
#|
(format t "~%s :~S ret_s: ~S " s ret_s)
(format t " encode :~S" encode)
(format t " length :~S" (length s))
(format t " atomic-p :~S" (atomic-p s))
(format t " us_ignoreableTail :~S" (us_ignoreableTail tail wide encode))
|#
    (values ret ret_s)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_initialWordCandidate
;; 【機能　】 点字文字列が先頭に位置するか否かを返す。
;; 【入力　】 s      : 評価中の部分文字列（文字列）
;;            left   : チャンクの開始位置から評価中の部分文字列の先頭までのオフセット（整数）
;;            right  : チャンクの開始位置から評価中の部分文字列の末端の１文字までのオフセット（整数）
;;            past   : 評価済みの部分文字列（文字列）
;;            next   : 評価予定の部分文字列（文字列）
;;            wide   : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                     半角として処理する。
;;            encode : t の場合 token を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;; 【出力　】 t/インデクス/nil
;; 【例外　】 なし
;; 【使用例】 (us_initialWordCandidate 1 "," "bea" "tles " nil t) → t
;;            (us_initialWordCandidate 1 "," "beatles" " " nil t) → nil
;;            (us_initialWordCandidate 1 "," "beatles " "" nil t) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_initialWordCandidate (left past s next wide encode)
  (let ((tail nil) (ret nil))
    (if (> (length s) 1)
      (setf tail (subseq s (1- (length s))))
      nil)
    ; 下記の①～③が全て真である場合に、真を返す。
    (setf ret
      (and
        ; ①
        ; 変換中の部分文字列は最初の部分文字列である。
        ; または
        ; 既に変換した部分文字列は【全て】デリミタ的なものである。
        (or (= left 0) (us_ignoreableLeft past wide encode))
        ; ②
        ; 変換中の部分文字列の長さは１バイトである。
        ; または
        ; 変換中の部分文字列の【末端の１文字】はデリミタ的なものでない。
        (or (= (length s) 1) (null (us_ignoreableTail tail wide encode)))
        ; ③
        ; 変換予定の部分文字列はデリミタ的でないものを含んでいる。
        (null (us_ignoreableRight next wide encode))))
    ; アポストロフィーの場合は結合なしとする。
    (if (and ret wide (string= s _apostrophy_w_)
                      (string/= (subseq next (- (length next) 2) (1- (length next))) _apostrophy_w_))
      (setf ret nil)
      nil)
  ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_medialWordCandidate
;; 【機能　】 点字文字列が語中に位置するか否かを返す。
;; 【入力　】 s      : 評価中の部分文字列（文字列）
;;            left   : チャンクの開始位置から評価中の部分文字列の先頭までのオフセット（整数）
;;            right  : チャンクの開始位置から評価中の部分文字列の末端の１文字までのオフセット（整数）
;;            past   : 評価済みの部分文字列（文字列）
;;            next   : 評価予定の部分文字列（文字列）
;;            wide   : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                     半角として処理する。
;;            encode : t の場合 token を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (us_medialWordCandidate 2 ",b" "ea" "tles " nil t) → t
;;            (us_medialWordCandidate 2 ",b" "eatles" " " nil t) → nil
;;            (us_medialWordCandidate 2 ",b" "eatles " "" nil t) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_medialWordCandidate (left past s next wide encode)
  (let ((tail nil))
    (if (> (length s) 1)
      (setf tail (subseq s (1- (length s))))
      nil)
    ; 下記の①～③が全て真である場合に、真を返す。
    (and
      ; ①
      ; 最初の部分文字列でない。
      ; かつ
      ; 既に変換した部分文字列はデリミタ的でないものを含んでいる。
      (and (/= left 0) (null (us_ignoreableLeft past wide encode)))
      ; ②
      ; 変換中の部分文字列の長さは１バイトである。
      ; または
      ; 変換中の部分文字列の【末端の１文字】はデリミタ的なものでない。
      (or (= (length s) 1) (null (us_ignoreableTail tail wide encode)))
      ; ③
      ; 変換予定の部分文字列はデリミタ的でないものを含んでいる。
      (null (us_ignoreableRight next wide encode)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_terminalWordCandidate
;; 【機能　】 点字文字列が末端に位置するか否かを返す。
;; 【入力　】 s      : 評価中の部分文字列（文字列）
;;            left   : チャンクの開始位置から評価中の部分文字列の先頭までのオフセット（整数）
;;            right  : チャンクの開始位置から評価中の部分文字列の末端の１文字までのオフセット（整数）
;;            past   : 評価済みの部分文字列（文字列）
;;            next   : 評価予定の部分文字列（文字列）
;;            wide   : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                     半角として処理する。
;;            encode : t の場合 token を墨字として処理、nil の場合 token
;;                     を点字として処理する。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (us_terminalWordCandidate 2 ",b" "ea" "tles " nil t) → nil
;;            (us_terminalWordCandidate 2 ",b" "eatles" " " nil t) → t
;;            (us_terminalWordCandidate 2 ",b" "eatles " "" nil t) → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_terminalWordCandidate (left past s next wide encode)
  (let ((tail nil) (ret nil))
    (if (> (length s) 1)
      (setf tail (subseq s (1- (length s))))
      nil)
    ; 下記の①～③が全て真である場合に、真を返す。
    (setf ret
      (and
        ; ①
        ; 最初の部分文字列でない。
        ; かつ
        ; 既に変換した部分文字列はデリミタ的でないものを含んでいる。
        (and (/= left 0) (null (us_ignoreableLeft past wide encode)))
        ; ②
        ; 変換中の部分文字列の長さは１バイトである。
        ; または
        ; 変換中の部分文字列の【末端の１文字】はデリミタ的なものでない。
        (or (= (length s) 1) (null (us_ignoreableTail tail wide encode)))
        ; ③
        ; 変換予定の部分文字列は【全て】デリミタ的なものである。
        (us_ignoreableRight next wide encode)))
    ; アポストロフィーの場合は結合なしとする。
    (if (and ret wide (string= s _apostrophy_w_)
                      (string/= (subseq past 0 1) _apostrophy_w_)
                      (us_ignoreableRight next wide encode))
      (setf ret nil)
      nil)
    ret))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_prep-inf-conj-p
;; 【機能　】 文字列が続く語に結合する語（前置詞・不定詞・接続詞）であるか否かを返す。
;; 【入力　】 str  : 文字列
;;          wide   : (エンコード時のみ) t の場合 str を全角として処理、nil の場合は
;;                   半角として処理する。
;;          encode : t の場合 token を墨字として処理、nil の場合 token
;;                   を点字として処理する。
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (us_prep-inf-conj-p "to" t) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_prep-inf-conj-p (str wide encode)
  (let ((ss (string-downcase str)))
    (if encode
      (if wide
        (prep-inf-conj-encode-w-p ss)
        (prep-inf-conj-encode-s-p ss))
      (prep-inf-conj-decode-p ss))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 us_url-p
;; 【機能　】 文字列が URL であるか否かを返す。
;; 【入力　】 brl : 点字文字列
;; 【出力　】 インデクス/URLサフィックス/nil
;; 【例外　】 なし
;; 【使用例】 (us_url-p "www4rikki4dyndns4org") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun us_url-p (brl)
  (if (> (length brl) (length "xx.xx"))
    (let (lst extract)
      ; 文字列の末端の空白を削除する。（空白は末端にしかないので、substitute-string で良い。）
      (setf extract (substitute-string brl _blank_s_ ""))
      ; 文字列の左辺の有効でない部分を削除する。
      (if (and (> (length extract) 0) (us_ignoreableLeft (subseq extract 0 1) nil nil nil))
        (setf extract (subseq extract 1))
        nil)
      ; 文字列の右辺の有効でない部分を削除する。
      (if (and (> (length extract) 0) (us_ignoreableRight (subseq extract (1- (length extract))) nil nil nil))
        (setf extract (subseq extract 0 (1- (length extract))))
        nil)
      ; 予め文字列から "." で分割したリストを作成しておく。
      ; 追加開始(Oct1, 2007)
      (setf lst (remove-if #'(lambda (x) (search "HTTP" x)) (split-string extract "//")))
      (setf extract (join-string lst ""))
      (setf lst (remove-if #'(lambda (x) (not (search _dot_brl_ x))) (split-string extract "/")))
      (setf extract (join-string lst ""))
      ; 追加終了(Oct1, 2007)
      (setf lst (remove-if #'(lambda (x) (string= x "")) (split-string extract _dot_brl_)))
      (setf lst (mapcar #'(lambda (x) (substitute-string x "," "")) lst))
      ; 文字列は "." が１つ以上存在し且つ
      ; 冒頭に "www" があるか、もしくは末端に "com" などがあれば URL と見なす。
      (and (> (length extract) (length "xx.xx"))
           (> (count-if #'(lambda (x) (string= x _dot_brl_)) extract) 0)
           (or
             (string= (string-downcase (first lst)) "www")
             (find (intern (string-upcase (car (last lst)))) *url_suffix_list*))))
    nil))

;(assoc '@ *us_grade1*)
;(dolist (x *us_grade1*) (print x))
;(assoc (intern "but ") *us_grade2*)
;(dolist (x *us_grade2*) (print x))
;(assoc 'a *us_grade3*)
;(dolist (x *us_grade3*) (print x))
;(assoc 'a *us_grade4*)
;(dolist (x *us_grade4*) (print x))

(defun us_grade2_test (lit)
  (if
    (numberp (cdr (assoc lit *us_grade2*)))
    (conv lit *us_grade2* *represent*)
    (let (l (s nil))
      (setf l (cdr (assoc lit *us_grade2*)))
      (dolist (x l)
        (setf s (concatenate 'string s (conv x *common* *represent*))))
      (values s))))
