;
; rcsID=$Id: Macros.lisp,v 1.16 2008/04/29 16:25:15 tmatsugaki Exp $
;
(proclaim '(optimize speed))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 explode-delims
;; 【機能　】 文字列が全て指定した区切り文字列であれば分割し、文字列のリストを
;;            生成する。
;; 【入力　】 str   : 文字列
;;            delim : 区切り文字列
;; 【出力　】 文字列のリスト
;; 【例外　】 なし
;; 【使用例】 (explode-delims "    " #\Space) → (" " " " " " " ")
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#|
(defmacro explode-delims (m_str m_delim)
  `(if (= (count-if #'(lambda (x) (string= x ,m_delim)) ,m_str) (length ,m_str))
    (explode-string ,m_str (list ,m_delim))
    (list ,m_str)))
|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 constant-char-stringp
;; 【機能　】 文字列が、全て指定した文字で構成されているか否かを返す。
;; 【入力　】 str : 文字列
;;            chr : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (constant-char-stringp "        " #\Space) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#|
(defmacro constant-char-stringp (m_str m_chr)
  `(= (count-if #'(lambda (x) (string= x (string ,m_chr))) ,m_str) (length ,m_str)))
|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 alpha-etc-charp
;; 【機能　】 文字がアルファベット・カンマであるか否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (alpha-etc-charp "a") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro alpha-etc-charp (m_ch)
  `(and (not (null ,m_ch))
        (or (char= #\, ,m_ch) (both-case-p ,m_ch))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 zero-nine-charp
;; 【機能　】 対象文字が [0-9] か否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (zero-nine-charp (char "0" 0)) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro zero-nine-charp (m_ch)
  `(and (not (null ,m_ch))
        (char>= ,m_ch #\0) (char>= #\9 ,m_ch)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 zero-nine-wcharp
;; 【機能　】 対象文字が [0-9] か否かを返す。
;; 【入力　】 ch : 文字
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (zero-nine-wcharp (char "０" 0)) → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro zero-nine-wcharp (m_ch)
  `(and (not (null ,m_ch))
        (char>= ,m_ch #\FULLWIDTH_DIGIT_ZERO)
        (char>= #\FULLWIDTH_DIGIT_NINE ,m_ch)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 prohibit-hankaku-p
;; 【機能　】 エンコード時に墨字を半角化できないか否かを返す。
;; 【入力　】 str : 文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (prohibit-hankaku-p "＜") → nil
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#|
(defmacro prohibit-hankaku-p (m_str m_mode)
  `(or
    (and (string= ,m_mode "JP")
         (not (null ,m_str))
         (find (intern ,m_str) _prohibit-hankaku-jp-list_))
    (and (string= ,m_mode "DI")
         (not (null ,m_str))
         (find (intern ,m_str) _prohibit-hankaku-di-list_))))
|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 atomic-p
;; 【機能　】 処理済みの文字列が分解できるか否かを返す。
;; 【入力　】 str : 文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (atomic-p ",8") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro atomic-p (m_brl)
  `(and (not (null ,m_brl))
        (find (intern ,m_brl) _atomic-list_)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 formatter-decode-p
;; 【機能　】 構成符号を表す文字列か否かを返す。
;; 【入力　】 brl : 点字文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (formatter-decode-p "=") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#|
(defmacro formatter-decode-p (m_brl)
  `(and (not (null ,m_brl))
        (find (intern ,m_brl) _formatter-encode-list_)))
|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; 【関数名】 punctuation-p
;; 【機能　】 句読点などを表す文字列（"." "," "-"）か否かを返す。
;;          "?" は【松ルール①】に従って *us_grade2* で直接宣言されているので、適用外。
;;          "!" は頻度が低いと考えられるので、双方とも対処しない。
;; 【入力　】 str : 墨字文字列
;;            brl : 点字文字列
;; 【出力　】 t/nil
;; 【例外　】 なし
;; 【使用例】 (punctuation-p "." "4") → t
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro punctuation-p (m_str m_brl)
  `(and (not (null ,m_str)) (not (null ,m_brl))
        (equal (car (cdr (assoc (intern ,m_str) _punctuation-list_))) (intern ,m_brl))))

(defmacro prep-inf-conj-encode-s-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _prep-inf-conj-encode-s-list_)))

(defmacro prep-inf-conj-encode-w-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _prep-inf-conj-encode-w-list_)))

(defmacro prep-inf-conj-decode-p (m_brl)
  `(and (not (null ,m_brl))
        (find (intern ,m_brl) _prep-inf-conj-decode-list_)))

(defmacro effectiveLeft-decode-p (m_brl)
  `(and (not (null ,m_brl))
        (find (intern ,m_brl) _effectiveLeft-decode-list_)))

(defmacro effectiveLeft-encode-s-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _effectiveLeft-encode-s-list_)))

(defmacro effectiveLeft-encode-w-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _effectiveLeft-encode-w-list_)))

(defmacro ignoreableLeft-decode-p (m_brl)
  `(and (not (null ,m_brl))
        (find (intern ,m_brl) _ignoreableLeft-decode-list_)))

(defmacro ignoreableLeft-encode-s-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ignoreableLeft-encode-s-list_)))

(defmacro ignoreableLeft-encode-w-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ignoreableLeft-encode-w-list_)))

(defmacro ignoreableRight-decode-p (m_brl)
  `(and (not (null ,m_brl))
        (find (intern ,m_brl) _ignoreableRight-decode-list_)))

(defmacro ignoreableRight-encode-s-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ignoreableRight-encode-s-list_)))

(defmacro ignoreableRight-encode-w-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ignoreableRight-encode-w-list_)))

(defmacro ignoreableTail-decode-p (m_brl)
  `(and (not (null ,m_brl))
        (find (intern ,m_brl) _ignoreableTail-decode-list_)))

(defmacro ignoreableTail-encode-s-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ignoreableTail-encode-s-list_)))

(defmacro ignoreableTail-encode-w-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ignoreableTail-encode-w-list_)))

(defmacro checkMask (m_mask m_whole m_init m_mid m_fin)
  `(if
     (or (null ,m_mask)
         (and  ,m_whole (= (logand ,m_mask _wholeWordMask_  ) 0))
         (and  ,m_init  (= (logand ,m_mask _initialWordMask_) 0))
         (and  ,m_mid   (= (logand ,m_mask _medialWordMask_ ) 0))
         (and  ,m_fin   (= (logand ,m_mask _finalWordMask_  ) 0)))
     nil
     t))

(defmacro getCount (m_sym)
  `(let ((cell (gensym)) (cnt (gensym)))
    (setf cell (assoc ,m_sym *g2DicRefCntList*))
    (if cell
      (setf cnt (cdr cell))
      (setf cnt 0))
    cnt))

;-------------------------------------------------------------------------------
; 【1マス略語】
;  -----------------------------------------------------------------------------
; 1マス略語が連続している。【連結/分割は必須】
(defmacro prefer-divide-p (m_lastWord m_nextWord)
  `(and (ocAbbrWord-leader-p ,m_lastWord)
        (ocAbbrWord-member-p ,m_nextWord)))

; 1マス略語で後続を要求するもの【リーダ】(and/for/of/with)
(defmacro ocAbbrWord-leader-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ocAbbrWord-leader-encode-s-list_)))

; 後続を要求する1マス略語に連なっても良い 1マス略語【メンバ】(and/for/of/the/with/a)
(defmacro ocAbbrWord-member-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _ocAbbrWord-member-encode-s-list_)))

;-------------------------------------------------------------------------------
; 低下略語では略語の適用が許可されない前後の文章記号であるか？
; eg. (inhibit-ocAbbrWord-neighbour-p "\"" "0") → T
; eg. (inhibit-ocAbbrWord-neighbour-p "\"" "8") → T
(defmacro inhibit-ocAbbrWord-neighbour-p (m_str m_brl)
  `(and (not (null ,m_str)) (not (null ,m_brl))
        (or
          (equal (cdr (assoc (intern (subseq ,m_str 0 1)) _inhibit-ocAbbrWord-neighbour-dlist_))
            (intern (subseq ,m_brl 0 1)))
          (equal (car (rassoc (intern (subseq ,m_brl 0 1)) _inhibit-ocAbbrWord-neighbour-dlist_))
            (intern (subseq ,m_str 0 1))))))

;-------------------------------------------------------------------------------
; 【低下略語】
;  -----------------------------------------------------------------------------
; 低下略語が連続している。【連結/分割は禁止】
(defmacro inhibited-lwAbbrWord-convert-order-p (m_lastWord m_nextWord)
  `(and (lwAbbrWord-leader-p ,m_lastWord)
        (lwAbbrWord-member-p ,m_nextWord)))

; 後続を要求する低下略語【リーダ】
(defmacro lwAbbrWord-leader-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _lwAbbrWord-leader-encode-s-list_)))

; 後続を要求する低下略語に連なってはならない低下略語【メンバ】
(defmacro lwAbbrWord-member-p (m_str)
  `(and (not (null ,m_str))
        (find (intern ,m_str) _lwAbbrWord-member-encode-s-list_)))

;-------------------------------------------------------------------------------
; 低下略語では略語の適用が許可されない前後の文章記号であるか？
; eg. (inhibit-lwAbbrWord-neighbour-p "\"" "0") → T
; eg. (inhibit-lwAbbrWord-neighbour-p "\"" "8") → T
(defmacro inhibit-lwAbbrWord-neighbour-p (m_str m_brl)
  `(and (not (null ,m_str)) (not (null ,m_brl))
        (or
          (equal (cdr (assoc (intern (subseq ,m_str 0 1)) _inhibit-lwAbbrWord-neighbour-dlist_))
            (intern (subseq ,m_brl 0 1)))
          (equal (car (rassoc (intern (subseq ,m_brl 0 1)) _inhibit-lwAbbrWord-neighbour-dlist_))
            (intern (subseq ,m_str 0 1))))))
;-------------------------------------------------------------------------------
