;
; rcsID=$Id: tips.lisp,v 1.5 2008/04/29 16:25:15 tmatsugaki Exp $
;
;(nth 1 (eval '(list 'われらわ、 'いずれの)))
;(nth 1 (apply 'list '(われらわ、 いずれの)))
;
;(format nil "~A" (code-char 12))
;(format t "~@{~S~}" *us_grade2_dec_dict*)

#|
; regexp サンプル
(defun sh ()
  (let ((h (make-hash-table :test #'equal :size 10)) (n 0))
    (with-open-file (f "/etc/passwd")
      (regexp::with-loop-split (s f ":")
        (incf (gethash (seventh s) h 0))))
    (with-hash-table-iterator (i h)
      (loop (multiple-value-bind (r k v) (i)
              (unless r (return))
              (format t "[~d] ~s~30t== ~5:d~%" (incf n) k v))))))
|#

(defun env ()
  (shell "cat ~/.clisprc.lisp"))

(defun rr ()
  (jp)
  (load "load.lisp"))

(defun qq ()
  (quit))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ゴミ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun t2 ()
  (dotimes (i 10 t)
    (format t "~S~S" i #\BackSpace)))

(defun ftest (&optional (fn "../dic/us_grade2.ext"))
  (with-open-file (tststream fn :direction :input)
    (format t "~%~S" (open-stream-p tststream))))

(defun ftest2 (&optional (extfn "../dic/us_grade2.ext"))
  (with-open-file (instream extfn :direction :input)
    (let (buff lst (lineNo 0))
      (do ()
        ((null (setf buff (read-line instream nil))) nil)
        (setf lst (split-string buff _fieldSeparator_))
        ; 1行読み込み、エンコード・デコード情報を取得する。
        (push (read-from-string (nth 0 lst)) *us_grade2_enc_dict*)
        (push (read-from-string (nth 1 lst)) *us_grade2_dec_dict*)
        (incf lineNo)))
    ;; 辞書入力ファイルをクローズする。
    (close instream)))

; 例外処理
;
; SBCL のファイルライトオープン失敗のメッセージ
;(SB-IMPL::SIMPLE-FILE-PERROR
; "error opening ~S"
; #P"/home/matsu/BrailleConverter/lisp/../txt/test/a.txt"
; 17)
;
;(define-condition simple-file-error    (simple-condition file-error)    ())
;
;0[4] (diag g1)
;
;
;debugger invoked on a UNBOUND-VARIABLE in thread #<THREAD "initial thread" {A7BD509}>:
;  The variable G1 is unbound.
;
;Type HELP for debugger help, or (SB-EXT:QUIT) to exit from SBCL.
;
;restarts (invokable by number or by possibly-abbreviated name):
;  0: [ABORT   ] Reduce debugger level (to debug level 4).
;  1:            Reduce debugger level (to debug level 3).
;  2: [CONTINUE] Return from SB-UNIX:SIGINT.
;  3:            Reduce debugger level (to debug level 2).
;  4:            Reduce debugger level (to debug level 1).
;  5:            Ignore and continue processing.
;  6:            Skip rest of initialization file.
;  7:            Skip to toplevel READ/EVAL/PRINT loop.
;  8: [QUIT    ] Quit SBCL (calling #'QUIT, killing the process).
;
;(SB-INT:EVAL-IN-LEXENV G1 #<NULL-LEXENV>)
;
;

; ファイル削除
;(delete-file (open "/tmp/tmp-file" :direction :output Helmut> :if-does-not-exist :create :if-exists :supersede))
;
#|
(defun delete-file (file)
  "Delete the specified file."
  (let ((namestring (unix-namestring file t)))
    (unless namestring
      (error 'simple-file-error
             :pathname file
             :format-control "~S doesn't exist."
             :format-arguments (list file)))
    (if (streamp file)
        (close file :abort t)
        (multiple-value-bind (res err) (unix:unix-unlink namestring)
          (unless res
            (error 'simple-file-error
                   :pathname namestring
                   :format-control "Could not delete ~A: ~A."
                   :format-arguments (list namestring
                                           (unix:get-unix-error-msg err))))))
    t))
|#

;(sort *us_grade2_dec_dict* #'(lambda (x y) (< (length (string (car x))) (length (string (car y))))))

; sbcl だと SYSTEM::SIMPLE-FILE-ERROR → SB-INT:SIMPLE-FILE-ERROR
;(defun exception-test ()
;  (if (equal
;        (type-of
;          (handler-case
;            (delete-file "/Users/matsu/projects/brc/lisp/b.txt")
;            (file-error (c) c)))
;        'SYSTEM::SIMPLE-FILE-ERROR)
;    (format t "file-error~%")
;    (format t "unknown~%")))
