#! /usr/bin/perl

# rcsid = "$Id: getline.pl,v 1.7 2008/04/29 16:25:15 tmatsugaki Exp $";
################################################################################
# 【機能】
# 指定したファイルの冒頭にある行番号を抽出し、当該行番号のみ標準入力を標準出力に出力する。
# 【出力形式】
# バイトストリーム
# 【注意】
# なし
################################################################################
use strict;

## オプション
our %linHash = ();
our $rc = -1;

################################################################################
# メイン（アーギュメントは下記の2個に固定）
#    行番号リストファイル名
#    行番号のオフセット
################################################################################
if ($#ARGV == 1) {
    my ($buffer, $i);

    # 行番号を抽出し、ハッシュに格納する。
    &getLineNo($ARGV[0]);
    # ハッシュに存在する行番号のみ出力する。
    $i = 1;
    while (<STDIN>) {
        if (defined $linHash{sprintf("%d", $i + $ARGV[1])}) {
            print "[" . $i . "] " . $_;
        }
        $i++;
    }
    $rc = 0;
} else {
    &usage();
    $rc = 1;
}
exit $rc;

################################################################################
# 行番号を抽出し、ハッシュに格納する。
################################################################################
sub getLineNo {
    my ($file) = @_;

    open(f,"<$file") || die "ファイル「$file」が開けません";
    while ($_ = <f>) {
        chop($_);
        $_ =~ s/\t/ /g;           # タブを空白に置換する
        $_ =~ s/ {1,}/ /g;        # 複数の空白を１個に置換する
        my @lines = split(/ /, $_);
        $linHash{sprintf("%d", $lines[0])} = 0;
    }
    close (f);
}

################################################################################
# usageを表示する
################################################################################
sub usage {
    my $normal = 4;
    my $big = 8;

    printf(STDERR "\nNAME\n");
    printf(STDERR "%${normal}sgetline.pl - only output line being assigned.\n\n", " ");
    printf(STDERR "SYNOPSYS\n", " ");
    printf(STDERR "%${normal}scat data_file | perl getline.pl lines_file offset \n", " ");
    printf(STDERR "\nEXAMPLE\n", " ");
    printf(STDERR "%${normal}scat data.txt | perl getline.pl diff.lst -349 \n", " ");
    printf(STDERR "\nDESCRIPTION\n", " ");
    printf(STDERR "%${normal}sShows line contents assigned by the file.\n", " ");
    printf(STDERR "\n%${normal}sdata_file\n%${big}sraw data file to be processed\n", " ", " ");
    printf(STDERR "\n%${normal}slines_file\n%${big}sfile holds line numbers\n", " ", " ");
    printf(STDERR "\n%${normal}soffset\n%${big}soffset of line numbers\n", " ", " ");
}
