/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <glib.h>
#include <gtk/gtk.h>

#include "breeze.h"
#include "user_commands.h"
#include "config.h"

GHashTable *preset_commands = NULL;

static void free_preset_commands(void)
{
  if (!preset_commands)
    ;   /* commands already freed or not loaded. */
  else {
    g_hash_table_destroy(preset_commands);
    preset_commands = NULL;
  }
}

static void preset_command_quit(void)
{
  extern gboolean continue_loop_flag;

  continue_loop_flag = FALSE;
  gtk_main_quit();
}

static void preset_command_reload(void)
{
  load_user_commands();
  gtk_main_quit();
}

static void preset_command_edit(void)
{
  popup_editorwin();
}

static void store_preset_command(gchar *keyword, gpointer callback)
{
  g_hash_table_insert(preset_commands, keyword, callback);
}

static void create_preset_commands_table(void)
{
  preset_commands = g_hash_table_new(g_str_hash, g_str_equal);

  store_preset_command("Reload", preset_command_reload);
  store_preset_command("Quit", preset_command_quit);
  store_preset_command("Edit", preset_command_edit);
}

gconstpointer lookup_preset_commands(const gchar *keyword)
{
  return g_hash_table_lookup(preset_commands, keyword);
}

void commands_table_foreach(GHFunc func, gpointer user_data)
{
  g_hash_table_foreach(preset_commands, func, user_data);
  g_hash_table_foreach(user_commands, func, user_data);
}

int initialize_commands(void)
{
  create_preset_commands_table();
  return load_user_commands();
}

void finalize_commands(void)
{
  free_user_commands();
  free_preset_commands();
}
