// $Id: BRbOutputBuffer.h,v 1.5 2002/09/04 03:44:26 yuya Exp $

#if !defined(_BRbOutputBuffer_h_)
#define _BRbOutputBuffer_h_

#include "BRbBase.h"
#include <math.h>

class BRbOutputBuffer
{

public:
	BRbOutputBuffer();
	virtual ~BRbOutputBuffer();

public:
	virtual VALUE to_string();
	virtual void write_byte(byte value);
	virtual void write_word(word value);
	virtual void write_dword(dword value);
	virtual void write_bytes(void* value, int size);
	virtual void write_buffer(BRbOutputBuffer& buffer);

protected:
	virtual void resize(long new_length);
	virtual void reserve(long size);

protected:
	long  m_position;
	long  m_length;
	char* m_buffer;

protected:
	static const long LENGTH_FIRST;
	static const long LENGTH_UNIT;

};

#endif
