// $Id: BRbReadNode.h,v 1.7 2002/09/04 03:44:26 yuya Exp $

#if !defined(_BRbReadNode_h_)
#define _BRbReadNode_h_

#include "BRbBase.h"
#include "BRbNode.h"
#include "BRbInputBuffer.h"
#include "BRbStringTable.h"

class BRbReadNode : public BRbNode
{

public:
	BRbReadNode(BRbInputBuffer& buffer, bool debug = false);
	virtual ~BRbReadNode();

public:
	virtual NODE* read();

protected:
	virtual BRbHeader read_header();
	virtual NODE* read_node();
	virtual NODE* read_node_opt();
	virtual byte read_byte();
	virtual word read_word();
	virtual dword read_dword();
	virtual const char* read_cstr();
	virtual const char* read_cstr(word* len);
	virtual VALUE read_string();
	virtual ID read_id();
	virtual VALUE read_literal();
	virtual VALUE read_object();

protected:
	BRbInputBuffer& m_buffer;
	BRbStringTable m_strtbl;
	bool m_debug;

};

#endif
