// $Id: BRbStringTable.h,v 1.1 2002/09/04 08:56:18 yuya Exp $

#if !defined(_BRbStringTable_h_)
#define _BRbStringTable_h_

#include <vector.h>
#include "BRbBase.h"
#include "BRbOutputBuffer.h"
#include "BRbInputBuffer.h"

typedef struct {
	word  len;
	char* str;
} STRITEM;

class BRbStringTable
{

public:
	BRbStringTable();
	virtual ~BRbStringTable();

public:
	virtual word set(const char* str);
	virtual word set(const char* str, word len);
	virtual const char* get(word idx);
	virtual const char* get(word idx, word* len);

	virtual void clear();
	virtual void dump(BRbOutputBuffer& buffer);
	virtual void load(BRbInputBuffer& buffer);

protected:
	vector<STRITEM*> m_table;

};

#endif
