#!/usr/local/bin/ruby

#==============================================================================#
# bin/bruby.rb
# $Id: bruby.rb,v 1.7 2002/09/10 10:01:26 yuya Exp $
#==============================================================================#

require 'bruby.so'
require 'getoptlong'

#==============================================================================#
# BRbCommand Module
module BRbCommand

  def self.main
    opt = self.parse_option

    if opt[:help]
      self.usage
      return
    end

    BRb.debug = opt[:debug]

    if opt[:execute] && ARGV.size >= 1
      input = ARGV[0]
      self.execute(input)
    elsif opt[:compile] && ARGV.size >= 1
      input  = ARGV[0]
      output = input.sub(/\.rb$/i, '.rbb')
      output << '.rbb' unless /\.rbb$/i =~ output
      self.compile(input, output)
    elsif opt[:verify] && ARGV.size >= 1
      input = ARGV[0]
      self.verify(input)
    else
      self.usage
      return
    end
  end

  def self.parse_option
    option = {}

    parser = GetoptLong.new
    parser.set_options(
      ['--execute', '-e', GetoptLong::NO_ARGUMENT],
      ['--compile', '-c', GetoptLong::NO_ARGUMENT],
      ['--verify',  '-v', GetoptLong::NO_ARGUMENT],
      ['--debug',   '-g', GetoptLong::NO_ARGUMENT],
      ['--help',    '-h', GetoptLong::NO_ARGUMENT]
    )

    parser.each_option { |name, argument|
      option[name.sub(/^--/, '').intern] = argument
    }

    return option
  end

  def self.usage
    STDERR.puts "Usage: bruby [options] file"
    STDERR.puts "Options:"
    STDERR.puts "  -e  --execute  execute bytecode."
    STDERR.puts "  -c  --compile  compile ruby script to bytecode."
    STDERR.puts "  -v  --verify   verify bytecode."
    STDERR.puts "  -g  --debug    enable debug mode."
    STDERR.puts "  -h  --help     display this information."
  end

  def self.execute(input)
    BRb.loadfile(input);
  end

  def self.compile(input, output)
    binary = BRb.dumpfile(input)

    File.open(output, 'wb') { |file|
      file.write(binary)
    }
  end

  def self.verify(input)
    if BRb.verifyfile(input)
      puts 'ok'
    else
      puts 'ng'
    end
  end

end

#==============================================================================#

BRbCommand.main

#==============================================================================#
# end of source
#==============================================================================#
